/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.AbstractReportExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.InstanceIDComparator;
import org.eclipse.birt.report.engine.internal.document.v4.PageRangeIterator;
import org.eclipse.birt.report.engine.internal.document.v4.ReportBodyExecutor;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;

public class ReportPageExecutorV4
extends AbstractReportExecutor {
    private boolean paged;
    private ArrayList outputPages = new ArrayList();
    private PageRangeIterator pageIter;
    private ReportBodyExecutor bodyExecutor;

    public ReportPageExecutorV4(ExecutionContext context, List pages, boolean paged) throws IOException, BirtException {
        super(context);
        this.outputPages.addAll(pages);
        this.paged = paged;
        this.pageIter = new PageRangeIterator(this.outputPages);
        if (!paged) {
            Fragment fragment = this.loadPageHints(this.outputPages);
            this.bodyExecutor = new ReportBodyExecutor(this.manager, fragment);
        }
    }

    public void close() {
        this.pageIter = null;
        if (this.bodyExecutor != null) {
            this.bodyExecutor.close();
            this.bodyExecutor = null;
        }
        super.close();
    }

    public IReportContent execute() {
        if (this.bodyExecutor != null) {
            this.bodyExecutor.execute();
        }
        return this.reportContent;
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            try {
                if (this.paged) {
                    long pageNumber = this.pageIter.next();
                    IPageHint pageHint = this.getPageHint(pageNumber);
                    Collection<PageVariable> vars = pageHint.getPageVariables();
                    this.context.addPageVariables(vars);
                    Fragment fragment = this.createFragment(pageHint);
                    return new ReportBodyExecutor(this.manager, fragment);
                }
                return this.bodyExecutor.getNextChild();
            }
            catch (IOException ex) {
                this.context.addException(new EngineException("Error.PagesLoadingError", ex));
            }
        }
        return null;
    }

    public boolean hasNextChild() {
        if (this.paged) {
            return this.pageIter.hasNext();
        }
        return this.bodyExecutor.hasNextChild();
    }

    protected Fragment loadPageHints(List pageSequence) throws IOException {
        long[] pages;
        if (pageSequence.size() == 1 && this.context.getReportDocument().isComplete() && (pages = (long[])pageSequence.get(0))[0] == 1L && pages[1] == this.hintsReader.getTotalPage()) {
            return null;
        }
        Fragment fragment = new Fragment(new InstanceIDComparator());
        PageRangeIterator iter = new PageRangeIterator(pageSequence);
        while (iter.hasNext()) {
            long pageNumber = iter.next();
            IPageHint pageHint = this.hintsReader.getPageHint(pageNumber);
            int sectCount = pageHint.getSectionCount();
            int i = 0;
            while (i < sectCount) {
                PageSection section = pageHint.getSection(i);
                Object[] leftEdges = section.starts;
                Object[] rightEdges = section.ends;
                fragment.addSection(leftEdges, rightEdges);
                ++i;
            }
        }
        fragment.build();
        return fragment;
    }

    protected Fragment createFragment(IPageHint pageHint) {
        Fragment fragment = new Fragment(new InstanceIDComparator());
        int sectCount = pageHint.getSectionCount();
        int i = 0;
        while (i < sectCount) {
            PageSection section = pageHint.getSection(i);
            Object[] leftEdges = section.starts;
            Object[] rightEdges = section.ends;
            fragment.addSection(leftEdges, rightEdges);
            ++i;
        }
        fragment.build();
        return fragment;
    }

    public IPageHint getPageHint(long pageNumber) throws IOException {
        return this.hintsReader.getPageHint(pageNumber);
    }
}

