/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view.internal;

import hiro.yoshioka.sdh.RDHTableViewer;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.notes.AbsNotesRunner;
import hiro.yoshioka.ui.multispan.JFaceSwingBothViewer;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.util.ProgramUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;

public class SimaPureViewer
extends JFaceSwingBothViewer {
    public SimaPureViewer(Composite parent, boolean swing_mode, boolean isVirtual, boolean supportDiff) {
        super(parent, swing_mode, isVirtual, supportDiff);
    }

    protected RDHTableViewer createRDHTableViewer(Composite parent, boolean isVirtual) {
        RDHTableViewer2 viewer = null;
        viewer = isVirtual ? new RDHTableViewer2(parent, 268536578) : new RDHTableViewer2(parent);
        return viewer;
    }

    class RDHTableViewer2
    extends RDHTableViewer {
        public RDHTableViewer2(Composite parent, int style) {
            super(parent, style);
        }

        public RDHTableViewer2(Composite parent) {
            super(parent);
        }

        public void menuAboutToShow(IMenuManager manager) {
            Action action = null;
            final ResultSetDataHolder rdh = this.getRDH();
            if (rdh != null) {
                try {
                    if (rdh.isForUpdate() && rdh.hasResultSetMetaData() && rdh.getPkPositions().length > 0) {
                        manager.add((IAction)new Action("Delete selected records", ImageUtil.getImageDescriptor((String)"action/clear_co.gif")){

                            public void run() {
                                RDHTableViewer2.this.deleteSelectedRows();
                            }
                        });
                    }
                    switch (rdh.getDatabaseType()) {
                        case ORACLE: {
                            int[] sel = SimaPureViewer.this.getSelectionIndices();
                            if (sel.length == 0) {
                                Application.openDialog("error", "Please select session", 1);
                                return;
                            }
                            StringBuilder buf = new StringBuilder();
                            int i = 0;
                            while (i < sel.length) {
                                String sid = rdh.getStringData(sel[i], "SID");
                                String serial = rdh.getStringData(sel[i], "SERIAL#");
                                String user = rdh.getStringData(sel[i], "OSUSER");
                                String machine = rdh.getStringData(sel[i], "MACHINE");
                                String.format("ALTER SYSTEM KILL SESSION '%s,%s'", sid, serial);
                                buf.append("\n SID[").append(sid).append(",").append(serial);
                                buf.append("] \u3010").append(user).append(",").append(machine);
                                buf.append("\u3011");
                                ++i;
                            }
                            Application.openDialog("result", "session killed" + buf, 2);
                            break;
                        }
                        case DOMINO: {
                            if (rdh != null && rdh.getRowCount() > 0) {
                                Program notesClient = ProgramUtil.getNotesProgram();
                                if (notesClient != null && rdh.hasColumn(AbsNotesRunner.NotesURL)) {
                                    action = new Action("Open Notes Client"){

                                        public void run() {
                                            Program.launch((String)rdh.getStringData(RDHTableViewer2.this.lastSelectedRow, AbsNotesRunner.NotesURL));
                                        }
                                    };
                                    manager.add((IAction)action);
                                }
                                if (rdh.hasColumn(AbsNotesRunner.HttpURL)) {
                                    action = new Action("Open Browser"){

                                        public void run() {
                                            Program.launch((String)rdh.getStringData(RDHTableViewer2.this.lastSelectedRow, AbsNotesRunner.HttpURL));
                                        }
                                    };
                                    manager.add((IAction)action);
                                }
                            }
                            break;
                        }
                        case TWITTER: {
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    Application.openErrorDialog(null, "error", e);
                }
            }
        }
    }
}

