/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view;

import hiro.yoshioka.gef.autolayout.TableFigure;
import hiro.yoshioka.gef.model.AbstractConnectionModel;
import hiro.yoshioka.gef.model.Column;
import hiro.yoshioka.gef.model.FkConnectionModel;
import hiro.yoshioka.gef.model.Schema;
import hiro.yoshioka.gef.model.Table;
import hiro.yoshioka.sql.resource.xml.DBColumnValue;
import hiro.yoshioka.sql.resource.xml.DBTableValue;
import hiro.yoshioka.util.SQLDataType;
import hiro.yoshioka.wolfdbmanager.resource.ImageManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;

public class TableListLayoutViewer
extends ViewPart {
    public static final String ID = "TableListLayoutViewerID";
    Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    Schema schema;
    HashMap<Table, GraphNode> map;
    org.eclipse.swt.widgets.Label layoutName;
    private Graph graph;
    static int layoutIndex = 0;
    static final AbstractLayoutAlgorithm[] algorithms = new AbstractLayoutAlgorithm[]{new SpringLayoutAlgorithm(1), new TreeLayoutAlgorithm(1), new RadialLayoutAlgorithm(1), new GridLayoutAlgorithm(1)};

    public static TableFigure createClassFigure1(DBTableValue tableModel) {
        Image image = null;
        image = tableModel.isType_view() ? ImageManager.getImageDescriptor("dbresource/04view.gif").createImage() : (tableModel.isType_function() ? ImageManager.getImageDescriptor("dbresource/08function.gif").createImage() : (tableModel.isType_table() ? ImageManager.getImageDescriptor("dbresource/03table.gif").createImage() : (tableModel.isType_procedure() ? ImageManager.getImageDescriptor("dbresource/06procedure.gif").createImage() : ImageManager.getImageDescriptor("dbresource/03table.gif").createImage())));
        Label classLabel1 = new Label(tableModel.getNameWithComment(20), image);
        TableFigure classFigure = new TableFigure(classLabel1);
        DBColumnValue[] cols = tableModel.getColumns();
        int j = 0;
        while (j < cols.length) {
            Label lb;
            SQLDataType dataType = cols[j].getType();
            image = dataType.isDateOrDateTimeOrTime() ? ImageManager.getImageDescriptor("dbresource/50date.gif").createImage() : (dataType.isString() ? ImageManager.getImageDescriptor("dbresource/51label.gif").createImage() : (dataType.isNumerics() ? ImageManager.getImageDescriptor("dbresource/53number.gif").createImage() : ImageManager.getImageDescriptor("dbresource/54column.gif").createImage()));
            if (cols[j].isPkey()) {
                lb = new Label(cols[j].getNameWithComment(20), image);
                classFigure.getAttributesCompartment().add((IFigure)lb);
            } else {
                lb = new Label(cols[j].getNameWithComment(20), image);
                classFigure.getMethodsCompartment().add((IFigure)lb);
            }
            ++j;
        }
        classFigure.setSize(-1, -1);
        return classFigure;
    }

    public HashMap<Table, GraphNode> getLayoutInfo() {
        return this.map;
    }

    public void reset(Point viewerSize) {
        this.fLogger.warn((Object)("reset:" + this.schema));
        try {
            if (this.schema != null) {
                Table table;
                this.map = new HashMap();
                List<Table> tlist = this.schema.getTables();
                int i = 0;
                while (i < tlist.size()) {
                    table = tlist.get(i);
                    TableFigure n = TableListLayoutViewer.createClassFigure1(table.getDBTable());
                    UMLNode n1 = new UMLNode((IContainer)this.graph, 0, (IFigure)n);
                    this.map.put(table, n1);
                    ++i;
                }
                i = 0;
                while (i < tlist.size()) {
                    table = tlist.get(i);
                    ArrayList<Column> cl = table.getColumns();
                    int j = 0;
                    while (j < cl.size()) {
                        Column column = cl.get(j);
                        List<AbstractConnectionModel> scList = column.getSourceConnectionList();
                        int k = 0;
                        while (k < scList.size()) {
                            AbstractConnectionModel model = scList.get(k);
                            Table targetTable = model.getTarget().getParent();
                            if (!(model instanceof FkConnectionModel)) {
                                GraphConnection gc = new GraphConnection(this.graph, 0, this.map.get(table), this.map.get(targetTable));
                                gc.setWeight(0.0);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                this.graph.setLayoutAlgorithm((LayoutAlgorithm)new SpringLayoutAlgorithm(1), true);
                this.layoutName.setText("LAYOUT:" + SpringLayoutAlgorithm.class.getName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        viewerSize.x += 20;
        viewerSize.y += 20;
        this.getViewSite().getShell().setSize(viewerSize);
    }

    public void createPartControl(Composite parent) {
        this.fLogger.warn((Object)("create:" + this.schema));
        parent.setLayout((Layout)new GridLayout());
        this.graph = new Graph(parent, 0);
        this.graph.setLayoutData((Object)new GridData(1808));
        this.graph.setConnectionStyle(2);
        this.layoutName = new org.eclipse.swt.widgets.Label(parent, 0);
        this.layoutName.setLayoutData((Object)new GridData(768));
    }

    public void setInput(Schema schema) {
        this.fLogger.warn((Object)("schema:" + schema));
        this.schema = schema;
    }

    public void switchLayout() {
        try {
            if (algorithms.length <= ++layoutIndex) {
                layoutIndex = 0;
            }
            this.graph.setLayoutAlgorithm((LayoutAlgorithm)algorithms[layoutIndex], true);
            this.layoutName.setText("LAYOUT:" + algorithms[layoutIndex].getClass().getName());
            this.layoutName.update();
            this.graph.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFocus() {
    }

    static class UMLNode
    extends GraphNode {
        IFigure customFigure = null;

        public UMLNode(IContainer graphModel, int style, IFigure figure) {
            super(graphModel, style, (Object)figure);
        }

        protected IFigure createFigureForModel() {
            return (IFigure)this.getData();
        }
    }
}

