/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class RhinoView
extends ViewPart {
    protected transient Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String ID = "RhinoViewID";
    SourceViewer inputViewer;
    SourceViewer outputView;
    ScriptEngineManager manager = new ScriptEngineManager();
    ScriptEngine engine = this.manager.getEngineByName("js");
    StringWriter writer;

    public SourceViewer getInputViewer() {
        return this.inputViewer;
    }

    public SourceViewer getOutputView() {
        return this.outputView;
    }

    public void createPartControl(Composite parent) {
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new LineNumberRulerColumn());
        this.inputViewer = new SourceViewer(parent, (IVerticalRuler)ruler, 2816);
        this.inputViewer.setDocument((IDocument)new Document());
        ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new LineNumberRulerColumn());
        this.outputView = new SourceViewer(parent, (IVerticalRuler)ruler, 2816);
        this.outputView.setDocument((IDocument)new Document());
        this.writer = new StringWriter();
        this.engine.getContext().setWriter(new PrintWriter(this.writer));
    }

    public void setFocus() {
        this.inputViewer.getTextWidget().setFocus();
    }

    public void exec() {
        this.writer.getBuffer().setLength(0);
        try {
            String exp = this.inputViewer.getDocument().get();
            this.engine.eval(exp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("writer=" + this.writer.toString());
        this.writer.flush();
        this.outputView.getDocument().set(this.writer.toString());
    }
}

