/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view;

import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.ResourceSorter;
import hiro.yoshioka.sql.engine.GettingResourceRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBColumn;
import hiro.yoshioka.sql.resource.DBResource;
import hiro.yoshioka.sql.resource.DBResourceTransfer;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.DBSchema;
import hiro.yoshioka.sql.resource.DBSequence;
import hiro.yoshioka.sql.resource.DBTable;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.view.DBResourceCompositeMaker;
import hiro.yoshioka.sql.resource.view.DBResourceTreeViewer;
import hiro.yoshioka.sql.resource.view.DBTreeFilter;
import hiro.yoshioka.sql.resource.view.IDBResourceTreeViewerContextMenuListener;
import hiro.yoshioka.sql.resource.view.IDBResourceTreeViewerListener;
import hiro.yoshioka.sql.resource.view.action.FunctionExecuteAction;
import hiro.yoshioka.ui.action.ConnectAction;
import hiro.yoshioka.ui.util.IPressEnterListener;
import hiro.yoshioka.ui.view.ConnectionStatusComposite;
import hiro.yoshioka.ui.view.internal.ExplorerMenu;
import hiro.yoshioka.ui.view.internal.WolfSelectTableDialog;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.util.Util;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class ExplorerView
extends ViewPart
implements IPressEnterListener {
    protected transient Log fLogger = LogFactory.getLog(this.getClass());
    public static final String ID = "ExplorerID";
    private DBResourceTreeViewer viewer;
    private Text fSearchText;
    ResourceSorter fResourceSorter = new ResourceSorter();
    DBTreeFilter fFilter = new DBTreeFilter();
    static final GridLayout RootGridLayout = new GridLayout();
    private boolean action_for_filter = false;
    Action action1 = null;

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPropertySheetPage.class)) {
            return new PropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void pressEnter() {
        this.refreshExplorer();
    }

    public DBTreeFilter getFilter() {
        return this.fFilter;
    }

    public void refreshExplorer() {
        if (this.fSearchText.getText().length() > 0) {
            this.fFilter.setPattern(this.fSearchText.getText());
        } else {
            this.fFilter.setPattern(null);
        }
        this.viewer.refresh();
    }

    public void createPartControl(Composite parent) {
        try {
            GridLayout gl = new GridLayout(1, false);
            gl.horizontalSpacing = 0;
            gl.verticalSpacing = 0;
            gl.marginRight = 0;
            gl.marginLeft = 0;
            gl.marginWidth = 0;
            gl.marginBottom = 0;
            gl.marginTop = 0;
            parent.setLayout((Layout)gl);
            DBResourceCompositeMaker maker = DBResourceCompositeMaker.getInstance((boolean)true);
            Composite c = maker.createControl(parent);
            c.setLayoutData((Object)new GridData(1808));
            this.viewer = maker.getTreeViewer();
            this.viewer.setDBResourceTreeViewerContextMenuListener((IDBResourceTreeViewerContextMenuListener)new ExplorerMenu(this));
            this.fSearchText = maker.getSearchText();
            this.fSearchText.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ExplorerView.this.action_for_filter = true;
                }

                public void focusLost(FocusEvent e) {
                    ExplorerView.this.action_for_filter = false;
                }
            });
            this.viewer.setInput((Object)SQLServerThread.getSQLServer().getConnectionList());
            this.viewer.refresh();
            ConnectionStatusComposite cc = new ConnectionStatusComposite(parent, 0);
            cc.setLayoutData(new GridData(768));
            this.makeActions();
            this.hookDoubleClickAction();
            this.contributeToActionBars();
            SQLServerThread.getSQLServer().addRequestListner((IRequestListener)cc);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public DBResourceTreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void setSortMode(int mode) {
        this.fResourceSorter.setMode(mode);
        this.refreshExplorer();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.clearGlobalActionHandlers();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new MyAction(ActionFactory.COPY.getId()));
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new MyAction(ActionFactory.SELECT_ALL.getId()));
    }

    public void makeActions() {
        try {
            this.makeMirrorAction();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ConnectionProperties getSelectedConnectionProperties() {
        return this.viewer.getLatestSelectedConnectionProperties();
    }

    private void setNames(TreeSet<String> set, IDBResource res) {
        IDBResource[] children = res.listArrayResources();
        int i = 0;
        while (i < children.length) {
            set.add(children[i].getUName());
            this.setNames(set, children[i]);
            ++i;
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
        this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "SQLBrowserHelp.ExplorerView");
    }

    private void makeMirrorAction() {
    }

    public IDBTable refreshTableOnTree(ConnectionProperties connectionProperties, IDBTable tbl) {
        GettingResourceRequest req = new GettingResourceRequest(connectionProperties);
        req.targetType = GettingResourceRequest.GettingTarget.ONLY_TABLE;
        req.selectionResource = tbl;
        try {
            SQLServerThread.runNowThisRequest((Request)req);
            System.out.println(req.selectionResource + "/" + req.selectionResource.childrenNum());
            System.out.println(tbl + "/" + tbl.childrenNum());
            this.viewer.refreshResourceLazy((Object)tbl);
            this.viewer.reveal((Object)tbl);
            System.out.println("refreshedd");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tbl;
    }

    public IDBSchema refreshSchemaOnTree(ConnectionProperties connectionProperties, IDBSchema schema) {
        GettingResourceRequest req = new GettingResourceRequest(connectionProperties);
        req.targetType = GettingResourceRequest.GettingTarget.ONLY_SCHEMA;
        req.selectionResource = schema;
        try {
            SQLServerThread.runNowThisRequest((Request)req);
            this.viewer.refreshResourceLazy((Object)schema);
            this.viewer.reveal((Object)schema);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return schema;
    }

    private void hookDoubleClickAction() {
        this.viewer.addDBResourceTreeViewerListener(new IDBResourceTreeViewerListener(){

            public void fireDoubleClick(ConnectionProperties connectionProperties, Object selection) {
                if (selection instanceof ConnectionProperties) {
                    if (!connectionProperties.isConnected()) {
                        ConnectAction c = new ConnectAction(ExplorerView.this, connectionProperties);
                        c.run();
                    }
                } else if (selection instanceof IDBSchema) {
                    IDBSchema schema = (IDBSchema)selection;
                    if (schema.childrenNum() == 0) {
                        schema = ExplorerView.this.refreshSchemaOnTree(connectionProperties, schema);
                    }
                } else if (selection instanceof IDBTable) {
                    IDBTable tbl = (IDBTable)selection;
                    if (tbl.isTable() || tbl.isView() || tbl.isFunction() || tbl.isProcudeure()) {
                        tbl = ExplorerView.this.viewer.refreshTableColumnsOnTree(tbl, false);
                    }
                    if (tbl.isTable() || tbl.isView()) {
                        WolfSelectTableDialog dialog = new WolfSelectTableDialog(connectionProperties, ExplorerView.this.getTreeViewer().getTree().getShell(), tbl, PreferenceUtil.getInt("SELECT_DIALOG_WINDOW_WIDTH"), PreferenceUtil.getInt("SELECT_DIALOG_WINDOW_HEIGHT"));
                        dialog.open();
                        PreferenceUtil.setInt("SELECT_DIALOG_WINDOW_WIDTH", dialog.getLatest_width());
                        PreferenceUtil.setInt("SELECT_DIALOG_WINDOW_HEIGHT", dialog.getLatest_height());
                    } else if (tbl.isProcudeure() || tbl.isFunction()) {
                        new FunctionExecuteAction(ExplorerView.this.getTreeViewer(), tbl).run();
                    }
                }
            }

            public void fireSelectionChanged(ConnectionProperties connectionProperties, Object selection) {
            }
        });
    }

    public void openConfigDialog() {
        this.viewer.openConfigDialog();
    }

    private class DragSourceAdapterImpl
    extends DragSourceAdapter {
        private TreeViewer viewer;

        public DragSourceAdapterImpl(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void dragSetData(DragSourceEvent event) {
            ExplorerView.this.fLogger.warn((Object)"dragSetData(DragSourceEvent) - start");
            TreeItem[] items = this.viewer.getTree().getSelection();
            DBResource[] sels = new DBResource[items.length];
            int i = 0;
            while (i < sels.length) {
                sels[i] = (DBResource)items[i].getData();
                ++i;
            }
            if (DBResourceTransfer.getInstance().isSupportedType(event.dataType)) {
                ExplorerView.this.fLogger.warn((Object)"DBResourceTransfer event.dataType");
                event.data = sels;
            } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                ExplorerView.this.fLogger.warn((Object)"TextTransfer event.dataType");
                event.data = sels[0].getNameWithComment();
            }
            ExplorerView.this.fLogger.warn((Object)event.toString());
            ExplorerView.this.fLogger.warn((Object)"dragSetData(DragSourceEvent) - end");
        }
    }

    class MyAction
    extends Action
    implements ISelectionChangedListener {
        private String fMode;

        public MyAction(String mode) {
            this.fMode = mode;
            ExplorerView.this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void run() {
            try {
                IStructuredSelection sel = (IStructuredSelection)ExplorerView.this.viewer.getSelection();
                if (ActionFactory.COPY.getId().equals(this.fMode)) {
                    StringBuffer buf = new StringBuffer();
                    if (ExplorerView.this.action_for_filter) {
                        buf.append(ExplorerView.this.fSearchText.getSelectionText());
                    } else {
                        for (Object o : sel) {
                            if (o instanceof ConnectionProperties) {
                                buf.append(String.format("%s,", ((ConnectionProperties)o).getDisplayString()));
                                continue;
                            }
                            buf.append(String.format("%s,", ((DBResource)o).getName()));
                        }
                        if (buf.length() > 0) {
                            buf.setLength(buf.length() - 1);
                        }
                    }
                    this.setContents(buf.toString());
                } else if (!ActionFactory.PASTE.getId().equals(this.fMode) && ActionFactory.SELECT_ALL.getId().equals(this.fMode)) {
                    if (ExplorerView.this.action_for_filter) {
                        if (ExplorerView.this.fSearchText.getText().length() > 0) {
                            ExplorerView.this.fSearchText.setSelection(0, ExplorerView.this.fSearchText.getText().length());
                        }
                    } else if (sel != null) {
                        Object root = sel.getFirstElement();
                        if (root instanceof DBRoot) {
                            ExplorerView.this.viewer.getTree().selectAll();
                        } else if (root instanceof DBColumn) {
                            DBColumn column = (DBColumn)root;
                            IDBColumn[] columns = ((IDBTable)column.getParent()).getColumns();
                            TreeItem[] root_items = ExplorerView.this.viewer.getTree().getItems();
                            ArrayList<TreeItem> retList = new ArrayList<TreeItem>();
                            int i = 0;
                            while (i < columns.length) {
                                TreeItem[] schema_items = root_items[0].getItems();
                                int j = 0;
                                while (j < schema_items.length) {
                                    TreeItem[] table_items = schema_items[j].getItems();
                                    int k = 0;
                                    while (k < table_items.length) {
                                        TreeItem[] column_items = table_items[k].getItems();
                                        int l = 0;
                                        while (l < column_items.length) {
                                            if (columns[i].equals(column_items[l].getData())) {
                                                retList.add(column_items[l]);
                                                break;
                                            }
                                            ++l;
                                        }
                                        ++k;
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                            ExplorerView.this.viewer.getTree().setSelection(retList.toArray(new TreeItem[0]));
                        } else if (root instanceof DBTable) {
                            DBTable table = (DBTable)root;
                            IDBTable[] tables = ((IDBSchema)table.getParent()).getTableOrViews();
                            TreeItem[] root_items = ExplorerView.this.viewer.getTree().getItems();
                            ArrayList<TreeItem> retList = new ArrayList<TreeItem>();
                            int i = 0;
                            while (i < tables.length) {
                                TreeItem[] schema_items = root_items[0].getItems();
                                int j = 0;
                                while (j < schema_items.length) {
                                    TreeItem[] table_items = schema_items[j].getItems();
                                    int k = 0;
                                    while (k < table_items.length) {
                                        if (tables[i].equals(table_items[k].getData())) {
                                            retList.add(table_items[k]);
                                            break;
                                        }
                                        ++k;
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                            ExplorerView.this.viewer.getTree().setSelection(retList.toArray(new TreeItem[0]));
                        } else if (root instanceof DBSchema) {
                            DBSchema scheme = (DBSchema)root;
                            IDBSchema[] schemas = ((DBRoot)scheme.getParent()).getSchemas();
                            TreeItem[] root_items = ExplorerView.this.viewer.getTree().getItems();
                            ArrayList<TreeItem> retList = new ArrayList<TreeItem>();
                            int i = 0;
                            while (i < schemas.length) {
                                TreeItem[] schema_items = root_items[0].getItems();
                                int k = 0;
                                while (k < schema_items.length) {
                                    if (schemas[i].equals(schema_items[k].getData())) {
                                        retList.add(schema_items[k]);
                                        break;
                                    }
                                    ++k;
                                }
                                ++i;
                            }
                            ExplorerView.this.viewer.getTree().setSelection(retList.toArray(new TreeItem[0]));
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)ExplorerView.this.viewer.getSelection();
            if (ActionFactory.COPY.getId().equals(this.fMode)) {
                this.setEnabled(sel.size() > 0);
            } else if (ActionFactory.SELECT_ALL.getId().equals(this.fMode)) {
                this.setEnabled(sel.size() == 1);
            }
            Object osel = sel.getFirstElement();
            if (osel instanceof DBRoot || osel instanceof DBSequence) {
                try {
                    PropertySheet sheet = (PropertySheet)Application.getWorkbenchPage().showView("org.eclipse.ui.views.PropertySheet");
                    sheet.selectionChanged((IWorkbenchPart)ExplorerView.this, (ISelection)sel);
                }
                catch (Exception e) {
                    ExplorerView.this.fLogger.warn((Object)e);
                }
            }
        }

        protected void setContents(String copyTo) {
            try {
                if (StringUtil.isEmpty((Object)copyTo)) {
                    return;
                }
                System.out.println("to=[" + copyTo + "]");
                Util.getClipboard().setContents(new Object[]{copyTo}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (RuntimeException e) {
                ExplorerView.this.fLogger.warn((Object)"", (Throwable)e);
            }
        }
    }
}

