/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view;

import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh.StringRecordData;
import hiro.yoshioka.sdh.StringRecordDataHolder;
import hiro.yoshioka.sdh.StringRecordPairData;
import hiro.yoshioka.sdh.diff.DiffElementType;
import hiro.yoshioka.sdh.diff.DiffToResultSetDataHolder;
import hiro.yoshioka.sdh.pair.DifferenceStringData;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.ui.view.IResultSetView;
import hiro.yoshioka.ui.view.internal.SimaPureViewer;
import hiro.yoshioka.vaction.SelectAndDiffExecuteAction;
import hiro.yoshioka.wolfdbmanager.Application;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class DiffResultSetView
extends ViewPart
implements IResultSetView {
    protected transient Log fLogger = LogFactory.getLog(this.getClass());
    public static final String ID = "DiffResultSetViewID";
    private CTabFolder fFolder1;
    private CTabFolder fFolder2;
    CLabel statusLine;
    Button filterDiffBtn;
    String[] fSQLStatements;
    int[][] fMatchingPos;
    String[] diffMessages;
    boolean f_is_virtual;
    boolean show_only_diff_mode_flg = false;
    private ResultSetDataHolder2[] fResultSetDataHolder1;
    private ResultSetDataHolder2[] fResultSetDataHolder2;
    private ResultSetDataHolder2[] fResultSetDataHolder1_only_diff;
    private ResultSetDataHolder2[] fResultSetDataHolder2_only_diff;
    private DiffToResultSetDataHolder[] drhs;
    ArrayList<SimaPureViewer> fViewerList1 = new ArrayList();
    ArrayList<SimaPureViewer> fViewerList2 = new ArrayList();
    private String connectionDisplayString;
    private String targetConnectionDisplayString;
    private String message = "";

    public void setMessage(String message) {
        this.message = message;
    }

    public DiffToResultSetDataHolder[] getDrhs() {
        if (this.show_only_diff_mode_flg) {
            DiffToResultSetDataHolder[] ret = (DiffToResultSetDataHolder[])DiffResultSetView.copyObject(this.drhs);
            int i = 0;
            while (i < ret.length) {
                ret[i].setLeftTarget((StringRecordDataHolder)this.fResultSetDataHolder1_only_diff[i]);
                ret[i].setRightTarget((StringRecordDataHolder)this.fResultSetDataHolder2_only_diff[i]);
                ++i;
            }
            return ret;
        }
        return this.drhs;
    }

    public void disableNextDiff() {
        IContributionItem item = this.getViewSite().getActionBars().getToolBarManager().find(SelectAndDiffExecuteAction.ID);
        if (item instanceof ActionContributionItem) {
            ((ActionContributionItem)item).getAction().setEnabled(false);
        }
    }

    public void createPartControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.marginBottom = 0;
        gl.marginTop = 0;
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginHeight = 0;
        main.setLayout((Layout)gl);
        Composite top = new Composite(main, 0);
        top.setLayoutData((Object)new GridData(768));
        top.setLayout((Layout)new FillLayout(256));
        this.statusLine = new CLabel(top, 0);
        this.filterDiffBtn = new Button(top, 32);
        this.filterDiffBtn.setText("shows only diff");
        this.filterDiffBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiffResultSetView.this.show_only_diff_mode_flg = DiffResultSetView.this.filterDiffBtn.getSelection();
                if (DiffResultSetView.this.show_only_diff_mode_flg) {
                    DiffResultSetView.this.setInput(DiffResultSetView.this.fResultSetDataHolder1_only_diff, DiffResultSetView.this.fResultSetDataHolder2_only_diff);
                } else {
                    DiffResultSetView.this.setInput(DiffResultSetView.this.fResultSetDataHolder1, DiffResultSetView.this.fResultSetDataHolder2);
                }
            }
        });
        SashForm sash = new SashForm(main, 256);
        sash.setLayoutData((Object)new GridData(1808));
        this.fFolder1 = this.createTab((Composite)sash);
        this.fFolder2 = this.createTab((Composite)sash);
        this.fFolder1.addSelectionListener((SelectionListener)new MySelection(this.fFolder1, this.fFolder2));
        this.fFolder2.addSelectionListener((SelectionListener)new MySelection(this.fFolder2, this.fFolder1));
        sash.setWeights(new int[]{3, 7});
    }

    private CTabFolder createTab(Composite parent) {
        CTabFolder ctab = new CTabFolder(parent, 2048);
        ctab.setSimple(false);
        ctab.setTabPosition(1024);
        ctab.setSelectionBackground(new Color[]{this.getViewSite().getShell().getDisplay().getSystemColor(31), this.getViewSite().getShell().getDisplay().getSystemColor(32)}, new int[]{70}, true);
        ctab.setSelectionForeground(this.getViewSite().getShell().getDisplay().getSystemColor(1));
        return ctab;
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    private void resetView(CTabFolder f1, ResultSetDataHolder2[] o, ArrayList<SimaPureViewer> vl, boolean isVirtual, boolean isHeader) {
        int ii = 0;
        while (ii < o.length) {
            try {
                this.fLogger.debug((Object)("LOOP [" + ii + "/" + o.length + "]"));
                CTabItem tabItem1 = new CTabItem(f1, 0);
                String tabName = o[ii].getTableNameE();
                if (o[ii].getTableName().trim().length() > 0) {
                    tabName = o[ii].getTableName();
                }
                if (tabName.length() == 0) {
                    tabName = "T_" + ii;
                }
                this.fLogger.debug((Object)(" tabName3[" + tabName + "]"));
                tabItem1.setText(tabName);
                SimaPureViewer viewer = new SimaPureViewer((Composite)f1, PreferenceUtil.getBoolean("BOOLEAN_VIEWER_SWING"), isVirtual, true);
                viewer.setInput((ResultSetDataHolder)o[ii], isHeader);
                tabItem1.setControl(viewer.getControl());
                vl.add(viewer);
            }
            catch (Exception e) {
                this.fLogger.warn((Object)"", (Throwable)e);
            }
            ++ii;
        }
        if (f1.getItemCount() > 0) {
            f1.setSelection(0);
        }
    }

    public void setInput(DiffToResultSetDataHolder[] drhs, boolean isVirtual) {
        this.drhs = drhs;
        this.f_is_virtual = isVirtual;
        this.fResultSetDataHolder1 = new ResultSetDataHolder2[drhs.length];
        this.fResultSetDataHolder2 = new ResultSetDataHolder2[drhs.length];
        this.diffMessages = new String[drhs.length];
        int total = 0;
        int i = 0;
        while (i < drhs.length) {
            total += drhs[i].getSumDelete() + drhs[i].getSumInsert() + drhs[i].getSumUpdate();
            this.fResultSetDataHolder1[i] = (ResultSetDataHolder2)drhs[i].getLeftTarget();
            this.fResultSetDataHolder2[i] = (ResultSetDataHolder2)drhs[i].getRightTarget();
            this.diffMessages[i] = drhs[i].getDiffInfomation();
            ++i;
        }
        this.filterDiffBtn.setSelection(false);
        if (total > 0) {
            this.fResultSetDataHolder1_only_diff = new ResultSetDataHolder2[this.fResultSetDataHolder1.length];
            this.fResultSetDataHolder2_only_diff = new ResultSetDataHolder2[this.fResultSetDataHolder2.length];
            i = 0;
            while (i < this.fResultSetDataHolder1.length) {
                this.fResultSetDataHolder1_only_diff[i] = this.createOnlyDiff(this.fResultSetDataHolder1[i]);
                ++i;
            }
            i = 0;
            while (i < this.fResultSetDataHolder2.length) {
                this.fResultSetDataHolder2_only_diff[i] = this.createOnlyDiff(this.fResultSetDataHolder2[i]);
                ++i;
            }
            this.filterDiffBtn.setEnabled(true);
        } else {
            this.filterDiffBtn.setEnabled(false);
        }
        this.setInput(this.fResultSetDataHolder1, this.fResultSetDataHolder2);
    }

    public ResultSetDataHolder2 createOnlyDiff(ResultSetDataHolder2 original) {
        ResultSetDataHolder2 ret = (ResultSetDataHolder2)DiffResultSetView.copyObject(original);
        int j = 0;
        while (j < ret.getRowCount()) {
            boolean has_diff = false;
            int i = 0;
            while (i < ret.getKey().length) {
                DiffElementType type;
                StringRecordData sr = ret.getStringRecordRow(j)[i];
                StringRecordPairData pair = sr.getPair();
                if (pair != null && pair instanceof DifferenceStringData && !(type = ((DifferenceStringData)sr.getPair()).fDifferenceKind).isNoChange()) {
                    has_diff = true;
                    break;
                }
                ++i;
            }
            if (!has_diff) {
                ret.deleteRow(j);
                --j;
            }
            ++j;
        }
        return ret;
    }

    public static Object copyObject(Object target) {
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        Object newObject = null;
        try {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                out = new ObjectOutputStream(bout);
                out.writeObject(target);
                out.flush();
                byte[] bytes = bout.toByteArray();
                in = new ObjectInputStream(new ByteArrayInputStream(bytes));
                newObject = in.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return newObject;
    }

    private void setInput(ResultSetDataHolder2[] o1, ResultSetDataHolder2[] o2) {
        this.fViewerList1.clear();
        CTabItem[] items = this.fFolder1.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        this.fViewerList2.clear();
        items = this.fFolder2.getItems();
        i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        this.resetView(this.fFolder1, o1, this.fViewerList1, this.f_is_virtual, false);
        this.resetView(this.fFolder2, o2, this.fViewerList2, this.f_is_virtual, false);
        this.setFocus();
    }

    public ResultSetDataHolder2[][] getInput() {
        if (this.show_only_diff_mode_flg) {
            return new ResultSetDataHolder2[][]{this.fResultSetDataHolder1_only_diff, this.fResultSetDataHolder2_only_diff};
        }
        return new ResultSetDataHolder2[][]{this.fResultSetDataHolder1, this.fResultSetDataHolder2};
    }

    public void setFocus() {
        int selIdx = this.fFolder2.getSelectionIndex();
        if (this.fViewerList2.size() > selIdx && selIdx >= 0) {
            this.fViewerList2.get(selIdx).setFocus();
        } else {
            this.fLogger.debug((Object)("fFolder2.getSelectionIndex[" + selIdx + "] fViewerList2#size[" + this.fViewerList2.size() + "]"));
        }
        if (this.diffMessages != null && this.diffMessages.length > 0) {
            this.statusLine.setText(String.valueOf(this.message) + " :: " + this.diffMessages[0]);
            Application.setStatus(this.diffMessages[0]);
        }
    }

    @Override
    public ResultSetDataHolder2[] getResultSetDataHolders() {
        return this.fResultSetDataHolder2;
    }

    public void setSQLStatements(String[] strings) {
        this.fSQLStatements = strings;
    }

    @Override
    public String[] getSQLStatements() {
        return this.fSQLStatements;
    }

    public void setMatchingPos(int[][] pos) {
        this.fMatchingPos = pos;
    }

    @Override
    public int[][] getMatchingPos() {
        return this.fMatchingPos;
    }

    @Override
    public void adjustDatum() {
        try {
            System.out.println("adjustDatum");
            this.fViewerList2.get(this.fFolder2.getSelectionIndex()).adjustDatum();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void selectAll() {
        this.fViewerList2.get(this.fFolder2.getSelectionIndex()).selectAll();
    }

    @Override
    public void adjustHeader() {
        try {
            this.fViewerList2.get(this.fFolder2.getSelectionIndex()).adjustHeader();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void adjustArea() {
        try {
            this.fViewerList2.get(this.fFolder2.getSelectionIndex()).adjustArea();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getConnectionPropertiesDisplay() {
        return this.connectionDisplayString;
    }

    @Override
    public void setConnectionPropertiesDisplay(String connectionDisplayString) {
        this.connectionDisplayString = connectionDisplayString;
    }

    public String getTargetConnectionDisplayString() {
        return this.targetConnectionDisplayString;
    }

    public void setTargetConnectionPropertiesDisplay(String displayString) {
        this.targetConnectionDisplayString = displayString;
    }

    class MySelection
    extends SelectionAdapter {
        CTabFolder me;
        CTabFolder you;

        public MySelection(CTabFolder me, CTabFolder you) {
            this.me = me;
            this.you = you;
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                this.you.setSelection(this.me.getSelectionIndex());
                if (DiffResultSetView.this.diffMessages != null && DiffResultSetView.this.diffMessages.length > 0 && this.me.getSelectionIndex() < DiffResultSetView.this.diffMessages.length) {
                    DiffResultSetView.this.statusLine.setText(String.valueOf(DiffResultSetView.this.message) + " :: " + DiffResultSetView.this.diffMessages[this.me.getSelectionIndex()]);
                    Application.setStatus(DiffResultSetView.this.diffMessages[this.me.getSelectionIndex()]);
                }
            }
            catch (Exception exception) {}
        }
    }
}

