/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.action;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.ui.action.SQLAction;
import hiro.yoshioka.ui.view.ExplorerView;
import hiro.yoshioka.ui.view.ResultSetView;
import hiro.yoshioka.wolfdbmanager.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;

public class RenameFieldAction
extends SQLAction {
    protected ExplorerView fView;
    Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private IDBColumn column;

    public RenameFieldAction(ExplorerView view, ConnectionProperties connectionProperties, IDBColumn treeSelection) {
        super(null, 1, connectionProperties);
        this.fView = view;
        this.column = treeSelection;
    }

    @Override
    public void run() {
        try {
            ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(this.connectionProperties);
            InputDialog dialog = new InputDialog(this.fView.getTreeViewer().getTree().getShell(), "Rename Field", "Input new field Name", this.column.getName(), new IInputValidator(){

                public String isValid(String newText) {
                    if (RenameFieldAction.this.column.getName().equals(newText)) {
                        return "Please enter a new name";
                    }
                    if (newText.trim().length() == 0) {
                        return "Please enter a new name";
                    }
                    return null;
                }
            });
            if (dialog.open() == 0) {
                ResultSetDataHolder rdh = sql.renameField(this.column, dialog.getValue());
                System.out.println("ret=" + rdh);
                ResultSetView rview = Application.showAndCreateRstView("rename_action");
                rview.setInput(rdh, null);
                if (rdh != null && rdh.getRowCount() > 0 && "success".equals(rdh.getStringData(0, "result"))) {
                    this.fView.refreshTableOnTree(this.connectionProperties, (IDBTable)this.column.getParent());
                    System.out.println("doneeeee!");
                }
            }
        }
        catch (Throwable e) {
            Application.openErrorDialog(null, "[Rename Field Action Error]", e);
        }
    }
}

