/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.selenium;

import hiro.yoshioka.selenium.Messages;

public enum Action {
    openUrl(Messages.Action_openUrl),
    back(Messages.Action_back),
    forward(Messages.Action_forward),
    refresh(Messages.Action_refresh),
    execute_script(Messages.Action_execute_script),
    execute_async_script(Messages.Action_execute_async_script),
    clear(Messages.Action_clear),
    click(Messages.Action_click),
    doubleClick(Messages.Action_doubleClick),
    moveToElement(Messages.Action_moveToElement),
    contextClick(Messages.Action_contextClick),
    selectByIndex(Messages.Action_select_by_index),
    selectByVisibleText(Messages.Action_select_by_visible_text),
    selectByValue(Messages.Action_select_by_value),
    getAttribute(Messages.Action_get_attr),
    getCssValue(Messages.Action_get_css),
    getText(Messages.Action_get_text),
    submit(Messages.Action_submit),
    sendKeys(Messages.Action_send_keys),
    takesScreenshot(Messages.Action_takes_screenshot),
    takesAllScreenshot(Messages.Action_takes_all_screenshot),
    waitForInvisible(Messages.Action_wait_for_invisible),
    switchTo(Messages.Action_switch_to),
    switchToConfirmAndAccept(Messages.Action_switchToConfirmAndAccept),
    switchToConfirmAndDismiss(Messages.Action_switchToConfirmAndDismiss),
    switchToErrorAndAccept(Messages.Action_switchToErrorAndAccept),
    switchToParentFrame(Messages.Action_switch_to_parent_frame),
    switchToDefaultContent(Messages.Action_switch_to_default),
    setWindowSize(Messages.Action_set_window_size),
    inspectBrowser(Messages.Action_inspect_browser),
    inspectDatabase(Messages.Action_inspectDatabase),
    gotoNoWhenExistsSelector(Messages.Action_gotoNoWhenExistsSelector),
    gotoNoWhenExistsMultipleSelectors(Messages.Action_gotoNoWhenExistsMultipleSelectors),
    gotoNoWhenNotExistsSelector(Messages.Action_gotoNoWhenNotExistsSelector),
    setFile(Messages.Action_setFile),
    deleteAllCookies(Messages.Action_deleteAllCookies);

    private String title;

    private Action(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public static Action parse(String text) {
        Action[] actionArray = Action.values();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            if (action.name().equalsIgnoreCase(text)) {
                return action;
            }
            if (action.getTitle().equals(text)) {
                return action;
            }
            ++n2;
        }
        return null;
    }

    public boolean isInspectBrowser() {
        return inspectBrowser.equals((Object)this);
    }

    public boolean isInspectDatabase() {
        return inspectDatabase.equals((Object)this);
    }

    public boolean isClick() {
        return click.equals((Object)this);
    }
}

