/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.preferences.EXCELPreferencePage;
import hiro.yoshioka.preferences.Messages;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.selenium.IScenarioRunnerListener;
import hiro.yoshioka.selenium.ScenarioRunner;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.util.Tuple;
import hiro.yoshioka.wolfdbmanager.Application;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class SQTExecutionDialog
extends Dialog
implements IScenarioRunnerListener {
    private final Log fLogger = LogFactory.getLog(this.getClass());
    static final String[] COLS = new String[]{Messages.SQTExecutionDialog_Sheet, Messages.SQTExecutionDialog_Description, Messages.SQTExecutionDialog_Command, Messages.SQTExecutionDialog_Parameter, Messages.SQTExecutionDialog_Status, Messages.SQTExecutionDialog_Result, Messages.SQTExecutionDialog_InspectDB, Messages.SQTExecutionDialog_InspectionBrowser, Messages.SQTExecutionDialog_Variables, Messages.SQTExecutionDialog_JsLog};
    static final int[] COLS_LEN = new int[]{150, 175, 100, 80, 58, 73, 95, 87, 87, 52};
    Composite statusLine;
    CLabel runStatus;
    CLabel errorStatus;
    CLabel failureStatus;
    CCombo lb_file_path;
    Button btn_quit_on_end;
    TreeViewer treeViewer;
    TableViewer scenarioTableViewer;
    StyledText dbmsText;
    StyledText outputParamText;
    private CTabFolder fFolder;
    ProgressBar progbar;
    boolean doWork = true;
    static final int SampleSheet_ID = 40012;
    static final String SampleSheet_LABEL = Messages.SQTExecutionDialog_SampleSheet;
    static final int EXEC_ID = 40030;
    static final String EXEC_LABEL = Messages.SQTExecutionDialog_Run;
    static final int PAUSE_ID = 40036;
    static final String PAUSE_LABEL = Messages.SQTExecutionDialog_Pause;
    static final String Resume_LABEL = Messages.SQTExecutionDialog_Resume;
    static final int REPORT_HTML_ID = 40040;
    static final String REPORT_LABEL = "Report";
    private List<Tuple.Pair<String, String>> scenario_variable_list = new ArrayList<Tuple.Pair<String, String>>();
    private ScenarioRunner runner;
    private Thread scenario_runner_thread;
    private List<ScenarioRunner.TestCaseResult> result_list = new ArrayList<ScenarioRunner.TestCaseResult>();
    private List<String> filePathList = new ArrayList<String>();

    public SQTExecutionDialog(Shell shell) {
        super(shell);
        this.setShellStyle(2144);
        this.setBlockOnOpen(false);
    }

    protected Point getInitialSize() {
        return new Point(990, 600);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 40012, SampleSheet_LABEL, false);
        this.createButton(parent, 40030, EXEC_LABEL, false);
        this.createButton(parent, 40036, PAUSE_LABEL, false);
        this.createButton(parent, 6, IDialogConstants.STOP_LABEL, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    private void stop() {
        this.doWork = false;
        if (this.runner != null) {
            this.runner.stop();
        }
    }

    private void pause() {
        this.doWork = false;
        if (this.runner != null) {
            this.runner.pause(180);
        }
    }

    private void resume() {
        this.doWork = false;
        if (this.runner != null) {
            this.runner.pause(0);
            this.scenario_runner_thread.interrupt();
        }
    }

    private void resetProgresAndStatus() {
        int num_of_test_case = 0;
        ScenarioRunner.Counter counter = null;
        if (this.runner != null) {
            counter = this.runner.getCounter();
            num_of_test_case = this.runner.getSetting().num_of_test_case;
        } else {
            counter = new ScenarioRunner.Counter();
        }
        this.runStatus.setText(String.format(Messages.SQTExecutionDialog_RunsTitle, counter.rans, num_of_test_case));
        this.errorStatus.setText(String.valueOf(Messages.SQTExecutionDialog_ErrorsCount) + counter.errors);
        this.failureStatus.setText(String.valueOf(Messages.SQTExecutionDialog_FailuresCount) + counter.failures);
        this.progbar.setSelection(counter.rans);
        if (counter.errors > 0) {
            Application.timer_exec(600, new ChangeStatus(this.errorStatus, 1));
            Application.timer_exec(1500, new ChangeStatus(this.errorStatus, 1));
        }
        if (counter.failures > 0) {
            Application.timer_exec(600, new ChangeStatus(this.failureStatus, 1));
            Application.timer_exec(1500, new ChangeStatus(this.failureStatus, 1));
        }
    }

    private void exec() {
        this.doWork = true;
        this.getButton(40030).setEnabled(false);
        SQLServerThread.getSQLServer();
        try {
            if (this.runner != null) {
                this.runner.getSetting().quitting_the_browser_at_end_of_scenario = this.btn_quit_on_end.getSelection();
                Runnable thread_runner = new Runnable(){

                    @Override
                    public void run() {
                        SQTExecutionDialog.this.runner.run();
                    }
                };
                this.scenario_runner_thread = new Thread(thread_runner);
                this.scenario_runner_thread.start();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.fLogger.error((Object)e);
        }
    }

    private void refresh() {
        this.treeViewer.refresh();
        this.scenarioTableViewer.refresh();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.setReturnCode(buttonId);
            this.stop();
            this.close();
        } else if (buttonId == 40012) {
            File temp = null;
            FileUtil util = new FileUtil(EXCELPreferencePage.class, "sample_scenario.xls");
            try {
                if (temp == null) {
                    temp = File.createTempFile("scenario_sample", ".xls");
                    temp.deleteOnExit();
                    FileOutputStream out = new FileOutputStream(temp);
                    BufferedInputStream input = util.getStream();
                    byte[] buff = new byte[256];
                    int len = 0;
                    while ((len = input.read(buff, 0, 256)) > 0) {
                        out.write(buff, 0, len);
                    }
                    out.close();
                    input.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (temp != null && !Program.launch((String)temp.getAbsolutePath())) {
                Program.launch((String)("/usr/lib/openoffice.org/program/scalc " + temp.getAbsolutePath()));
            }
        } else if (buttonId == 40036) {
            Button button = this.getButton(buttonId);
            if (PAUSE_LABEL.equals(button.getText())) {
                button.setText(Resume_LABEL);
                this.pause();
            } else {
                button.setText(PAUSE_LABEL);
                this.resume();
            }
        } else if (buttonId == 6) {
            this.stop();
        } else {
            this.exec();
        }
    }

    protected Control createDialogArea(Composite parent) {
        try {
            String paths = PreferenceUtil.getString("scenario_file_path");
            if (!StringUtil.isEmpty((Object)paths)) {
                String[] stringArray = paths.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f;
                    String p = stringArray[n2];
                    if (!StringUtil.isEmpty((Object)p) && (f = new File(p)).exists()) {
                        this.filePathList.add(f.getAbsolutePath());
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite up = new Composite(composite, 0);
        up.setLayoutData((Object)this.createGridData(330, 1808));
        GridLayout layout = new GridLayout(1, false);
        up.setLayout((Layout)layout);
        Composite up_scenario_file = new Composite(up, 0);
        up_scenario_file.setLayoutData((Object)new GridData(768));
        up_scenario_file.setLayout((Layout)new GridLayout(4, false));
        new CLabel(up_scenario_file, 0).setText(Messages.SQTExecutionDialog_ScenarioFileLb);
        this.lb_file_path = new CCombo(up_scenario_file, 2052);
        this.lb_file_path.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQTExecutionDialog.this.resetScenarioFile();
            }
        });
        this.lb_file_path.setLayoutData((Object)new GridData(1808));
        Button open = new Button(up_scenario_file, 8);
        open.setText(Messages.SQTExecutionDialog_FileChooserBtn);
        open.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(SQTExecutionDialog.this.getShell(), 4096);
                dlg.setFilterNames(new String[]{"Microsoft Excel (*.xls)"});
                dlg.setFilterExtensions(new String[]{"*.xls", "*.*"});
                String fn = dlg.open();
                if (fn != null) {
                    SQTExecutionDialog.this.runner = null;
                    SQTExecutionDialog.this.setScenarioFile(fn);
                    SQTExecutionDialog.this.resetScenarioFile();
                }
            }
        });
        this.btn_quit_on_end = new Button(up_scenario_file, 32);
        this.btn_quit_on_end.setText(Messages.SQTExecutionDialog_quitBrowserAtEos);
        this.btn_quit_on_end.setToolTipText(Messages.SQTExecutionDialog_quittingTheBrowserAtEndOfScenario);
        this.btn_quit_on_end.setSelection(true);
        Composite upup = new Composite(up, 0);
        upup.setLayoutData((Object)new GridData(768));
        upup.setLayout((Layout)new FillLayout(512));
        this.statusLine = new Composite(upup, 2048);
        this.statusLine.setLayout((Layout)new FillLayout(256));
        this.runStatus = new CLabel(this.statusLine, 2048);
        this.failureStatus = new CLabel(this.statusLine, 2048);
        this.errorStatus = new CLabel(this.statusLine, 2048);
        this.progbar = new ProgressBar(upup, 0);
        this.progbar.setMinimum(0);
        this.treeViewer = new TreeViewer(up, 2818);
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)this.createGridData(300, 1808));
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        int i = 0;
        while (i < COLS.length) {
            TreeColumn col1 = new TreeColumn(tree, 0);
            col1.setText(COLS[i]);
            col1.setWidth(COLS_LEN[i]);
            ++i;
        }
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)SQTExecutionDialog.this.treeViewer.getSelection();
                Object o = sel.getFirstElement();
                if (o == null) {
                    return;
                }
            }
        });
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setInput(this.result_list);
        this.fFolder = new CTabFolder(composite, 2048);
        this.fFolder.setSimple(false);
        this.fFolder.setLayout((Layout)new FillLayout());
        this.fFolder.setLayoutData((Object)this.createGridData(300, 1808));
        CTabItem tabItem0 = new CTabItem(this.fFolder, 0);
        tabItem0.setText("Scenario variables");
        Table generatorSettingTable = new Table((Composite)this.fFolder, 68352);
        generatorSettingTable.setHeaderVisible(true);
        this.scenarioTableViewer = new TableViewer(generatorSettingTable);
        String[] COLUMN_HEADERS = new String[]{"Name", "Value"};
        int i2 = 0;
        while (i2 < COLUMN_HEADERS.length) {
            String column_name = COLUMN_HEADERS[i2];
            TableColumn col = new TableColumn(generatorSettingTable, 0);
            col.setText(column_name);
            col.setWidth(150 + 150 * i2);
            ++i2;
        }
        this.scenarioTableViewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.scenarioTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.scenarioTableViewer.setColumnProperties(COLUMN_HEADERS);
        this.scenarioTableViewer.setInput(this.scenario_variable_list);
        this.scenarioTableViewer.getTable().setLinesVisible(true);
        tabItem0.setControl((Control)generatorSettingTable);
        this.fFolder.setSelection(0);
        this.resetProgresAndStatus();
        this.refresh();
        this.setScenarioFile(null);
        if (this.filePathList.size() > 0) {
            this.resetScenarioFile();
        }
        return composite;
    }

    public void resetScenarioFile() {
        String file_path = this.lb_file_path.getText();
        ScenarioRunner runner = new ScenarioRunner();
        runner.init(new File(file_path));
        this.runner = runner;
        runner.setListerner(this);
        this.progbar.setMaximum(runner.countTestCase(runner.getSetting()));
        this.resetProgresAndStatus();
    }

    private void setScenarioFile(String file_path) {
        this.lb_file_path.removeAll();
        if (!StringUtil.isEmpty((Object)file_path)) {
            this.filePathList.remove(file_path);
            this.filePathList.add(0, file_path);
        }
        int i = 0;
        while (i < this.filePathList.size()) {
            this.lb_file_path.add(this.filePathList.get(i));
            if (i == 0) {
                this.lb_file_path.select(0);
            }
            ++i;
        }
        while (this.filePathList.size() > 5) {
            this.filePathList.remove(this.filePathList.size() - 1);
        }
        try {
            PreferenceUtil.setString("scenario_file_path", StringUtil.join(this.filePathList, (String)","));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private GridData createGridData(int height, int type) {
        GridData gd = new GridData(type);
        gd.heightHint = height;
        gd.minimumHeight = height;
        return gd;
    }

    @Override
    public void statusChanged() {
        Application.exec(new Runnable(){

            @Override
            public void run() {
                SQTExecutionDialog.this.resetProgresAndStatus();
                SQTExecutionDialog.this.result_list = SQTExecutionDialog.this.runner.getResult_list();
                SQTExecutionDialog.this.treeViewer.setInput((Object)SQTExecutionDialog.this.result_list);
                SQTExecutionDialog.this.treeViewer.refresh();
                Properties p = SQTExecutionDialog.this.runner.getScenario_variable_property();
                SQTExecutionDialog.this.scenario_variable_list.clear();
                for (Object key : p.keySet()) {
                    Object val = p.get(key);
                    SQTExecutionDialog.this.scenario_variable_list.add(new Tuple.Pair(key, val));
                }
                SQTExecutionDialog.this.scenarioTableViewer.refresh();
            }
        });
    }

    @Override
    public void done(File evidence_output_folder) {
        if (evidence_output_folder != null && evidence_output_folder.exists()) {
            Program.launch((String)evidence_output_folder.getAbsolutePath());
        }
    }

    private class ChangeStatus
    implements Runnable {
        int state;
        CLabel lb;

        public ChangeStatus(CLabel lb, int state) {
            this.state = state;
            this.lb = lb;
        }

        @Override
        public void run() {
            this.lb.setForeground(ColorConstants.red);
            SQTExecutionDialog.this.progbar.setState(this.state);
        }
    }

    private class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MyLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Tuple.Pair) {
                Tuple.Pair pair = (Tuple.Pair)element;
                if (columnIndex == 0) {
                    return (String)pair.getLeft();
                }
                return (String)pair.getRight();
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    class ReportHeader {
        int numOfRan;
        int failures;
        int errors;
        String successRateString;
        String totalTimeString;
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof List) {
                return ((List)element).size() > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TreeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        TreeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ScenarioRunner.TestCaseResult) {
                ScenarioRunner.TestCaseResult result = (ScenarioRunner.TestCaseResult)element;
                String ret = null;
                switch (columnIndex) {
                    case 0: {
                        ret = result.sheet_name;
                        break;
                    }
                    case 1: {
                        ret = result.description;
                        break;
                    }
                    case 2: {
                        ret = result.command;
                        break;
                    }
                    case 3: {
                        ret = result.parameter;
                        break;
                    }
                    case 4: {
                        ret = result.status;
                        break;
                    }
                    case 5: {
                        ret = result.result;
                        break;
                    }
                    case 6: {
                        ret = result.inspection_result_of_db;
                        break;
                    }
                    case 7: {
                        ret = result.inspection_result_of_browser;
                        break;
                    }
                    case 8: {
                        ret = StringUtil.nvl((Object)result.ctrl_variable);
                        break;
                    }
                    case 9: {
                        ret = result.getLog_list().size() > 0 ? Messages.SQTExecutionDialog_Exists_Error : "";
                        break;
                    }
                    default: {
                        ret = "-";
                    }
                }
                return StringUtil.nvl((Object)ret);
            }
            return "";
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof ScenarioRunner.TestCaseResult) {
                ScenarioRunner.TestCaseResult caze = (ScenarioRunner.TestCaseResult)element;
                if ("error".equals(caze.result) || "failure".equals(caze.result)) {
                    return ColorConstants.red;
                }
            }
            return null;
        }
    }
}

