/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.preferences.PreferenceUtil;
import java.io.File;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class RhinoPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "RhinoPreferencePage";
    List fJarList;

    protected Control createContents(Composite parent) {
        try {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            ScrolledForm root = toolkit.createScrolledForm(parent);
            root.setText("Rhino Settings");
            root.getBody().setLayout((Layout)new GridLayout());
            Section section = toolkit.createSection(root.getBody(), 320);
            section.setText("External JAR FILES");
            Composite inner = toolkit.createComposite((Composite)section);
            TableWrapLayout layout = new TableWrapLayout();
            inner.setLayout((Layout)layout);
            layout.numColumns = 3;
            this.fJarList = new List(inner, 2564);
            TableWrapData td = new TableWrapData(256);
            td.colspan = 2;
            td.rowspan = 2;
            td.heightHint = this.fJarList.getItemHeight() * 3;
            this.fJarList.setLayoutData((Object)td);
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            Button addButton = toolkit.createButton(inner, "ADD File", 0);
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String openFile = dialog.open();
                    if (openFile != null) {
                        String[] items = RhinoPreferencePage.this.fJarList.getItems();
                        int i = 0;
                        while (i < items.length) {
                            if (items[i].equals(openFile)) {
                                return;
                            }
                            ++i;
                        }
                        RhinoPreferencePage.this.fJarList.add(openFile);
                    }
                }
            });
            Button delButton = toolkit.createButton(inner, "Del File", 0);
            delButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (RhinoPreferencePage.this.fJarList.getSelectionIndex() >= 0) {
                        RhinoPreferencePage.this.fJarList.remove(RhinoPreferencePage.this.fJarList.getSelectionIndex());
                    }
                }
            });
            String[] pathes = PreferenceUtil.getString("RHINO_EXTERNAL_JARS").split(File.pathSeparator);
            int i = 0;
            while (i < pathes.length) {
                if (pathes[i].trim().length() > 0) {
                    this.fJarList.add(pathes[i]);
                }
                ++i;
            }
            section.setClient((Control)inner);
            section.setLayoutData((Object)new GridData(768));
            return root;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void performApply() {
        try {
            PreferenceUtil.setString("RHINO_EXTERNAL_JARS", this.flatFiles());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    public void init(IWorkbench workbench) {
    }

    public String flatFiles() {
        StringBuffer buf = new StringBuffer();
        String[] list = this.listFiles();
        int i = 0;
        while (i < list.length) {
            if (i > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(list[i]);
            ++i;
        }
        return buf.toString();
    }

    public String[] listFiles() {
        return this.fJarList.getItems();
    }
}

