/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.job.AbsBasicPoiWriter;
import hiro.yoshioka.preferences.ExcelDefData;
import hiro.yoshioka.preferences.Messages;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ReadExcelDefinitionDialog
extends Dialog
implements ModifyListener {
    protected Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    static final int CREATE_DDL = 400;
    static final Pattern AC = Pattern.compile("([a-zA-Z]+)([0-9]+)");
    static String[] MODE = new String[]{Messages.ReadExcelDefinitionDialog_ONE_TABLE_ONE_SHEET, Messages.ReadExcelDefinitionDialog_ALL_TABLE_ONE_SHEET};
    Button btOpenExcel;
    String[] files = new String[0];
    String dir;
    List fileList;
    private int selectedMode = 0;
    public static int MODE_ONE = 0;
    public static int MODE_ALL = 1;
    Spinner fStartLine;
    Text fPhysicalTableName;
    Text fLogicalTableName;
    Text fPhysicalColumnName;
    Text fLogicalColumnName;
    Text fDataType;
    CTabFolder tab;
    ExcelDefData data;
    int pc = -1;
    int lc = -1;
    int ptRow = -1;
    int ptCol = -1;
    int ltRow = -1;
    int ltCol = -1;
    static final String[] HEADER = new String[]{"ROW", "A", "B", "C", "D", "E", "F", "H", "I", "J", "K", "L", "M", "N", "O", "P"};

    public ReadExcelDefinitionDialog(Shell shell) {
        super(shell);
    }

    protected Point getInitialSize() {
        return new Point(780, 620);
    }

    private void refrButtons() {
        if (this.fileList.getItemCount() > 0) {
            this.fStartLine.setEnabled(true);
            this.fPhysicalTableName.setEnabled(true);
            this.fLogicalTableName.setEnabled(true);
            this.fPhysicalColumnName.setEnabled(true);
            this.fPhysicalTableName.setEnabled(true);
            this.fDataType.setEnabled(true);
            boolean btnFlg = this.pc > 0;
            btnFlg &= this.lc > 0;
            btnFlg &= this.ptCol > 0 && this.ptRow > 0;
            this.getButton(0).setEnabled(btnFlg &= this.ltCol > 0 && this.ltRow > 0);
        } else {
            this.fStartLine.setEnabled(false);
            this.fPhysicalTableName.setEnabled(false);
            this.fLogicalTableName.setEnabled(false);
            this.fPhysicalColumnName.setEnabled(false);
            this.fPhysicalTableName.setEnabled(false);
            this.fDataType.setEnabled(false);
            this.getButton(0).setEnabled(false);
        }
        this.getButton(0).setEnabled(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.ReadExcelDefinitionDialog_CREATE_COMMENT, false);
        this.createButton(parent, 400, Messages.ReadExcelDefinitionDialog_CREATE_TABLE, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    public int getSelection() {
        return this.selectedMode;
    }

    protected Control createDialogArea(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm root = toolkit.createScrolledForm(parent);
        root.setText(Messages.ReadExcelDefinitionDialog_Import_DBResource_Definition_From_Excel_Document);
        root.setLayout((Layout)new GridLayout());
        root.setLayoutData((Object)new GridData(1808));
        root.getBody().setLayout((Layout)new GridLayout(2, false));
        root.getBody().setLayoutData((Object)new GridData(1808));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        Section section = toolkit.createSection(root.getBody(), 320);
        section.setText(Messages.ReadExcelDefinitionDialog_Document_Condition);
        Section section2 = toolkit.createSection(root.getBody(), 320);
        section2.setText(Messages.ReadExcelDefinitionDialog_Definition_Document);
        Section section3 = toolkit.createSection(root.getBody(), 320);
        section3.setText(Messages.ReadExcelDefinitionDialog_Preview);
        section3.setLayoutData((Object)gd);
        Composite inner = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        inner.setLayout((Layout)layout);
        layout.numColumns = 2;
        List list = new List(inner, 2052);
        int i = 0;
        while (i < MODE.length) {
            list.add(MODE[i]);
            ++i;
        }
        this.selectedMode = 0;
        list.setSelection(0);
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReadExcelDefinitionDialog.this.selectedMode = list.getSelectionIndex();
            }
        });
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        list.setLayoutData((Object)gd);
        gd = new GridData(768);
        CLabel lb = new CLabel(inner, 16);
        lb.setText(Messages.ReadExcelDefinitionDialog_Start_Continuous_RowNum);
        lb.setForeground(ColorConstants.lightBlue);
        this.fStartLine = new Spinner(inner, 72);
        this.fStartLine.setValues(5, 1, 50, 0, 1, 1);
        this.fStartLine.setSelection(5);
        this.fStartLine.setLayoutData((Object)gd);
        this.fStartLine.addModifyListener((ModifyListener)this);
        lb = new CLabel(inner, 16);
        lb.setText(Messages.ReadExcelDefinitionDialog_PhysicalTableName);
        lb.setForeground(ColorConstants.green);
        this.fPhysicalTableName = new Text(inner, 2052);
        this.fPhysicalTableName.setMessage("ex. A1, BB20");
        this.fPhysicalTableName.setLayoutData((Object)gd);
        this.fPhysicalTableName.addModifyListener((ModifyListener)this);
        lb = new CLabel(inner, 16);
        lb.setText(Messages.ReadExcelDefinitionDialog_LogicalTableName);
        lb.setForeground(ColorConstants.darkGreen);
        this.fLogicalTableName = new Text(inner, 2052);
        this.fLogicalTableName.setLayoutData((Object)gd);
        this.fLogicalTableName.addModifyListener((ModifyListener)this);
        lb = new CLabel(inner, 16);
        lb.setText(Messages.ReadExcelDefinitionDialog_PhysicalColumnName);
        lb.setForeground(ColorConstants.gray);
        this.fPhysicalColumnName = new Text(inner, 2052);
        this.fPhysicalColumnName.setLayoutData((Object)gd);
        this.fPhysicalColumnName.setTextLimit(2);
        this.fPhysicalColumnName.addModifyListener((ModifyListener)this);
        lb = new CLabel(inner, 16);
        lb.setText(Messages.ReadExcelDefinitionDialog_LogicalColumnName);
        lb.setForeground(ColorConstants.lightGray);
        this.fLogicalColumnName = new Text(inner, 2052);
        this.fLogicalColumnName.setLayoutData((Object)gd);
        this.fLogicalColumnName.setTextLimit(2);
        this.fLogicalColumnName.addModifyListener((ModifyListener)this);
        new CLabel(inner, 16).setText(Messages.ReadExcelDefinitionDialog_DataType);
        this.fDataType = new Text(inner, 2052);
        this.fDataType.setLayoutData((Object)gd);
        section.setClient((Control)inner);
        section.setLayoutData((Object)new GridData(1808));
        Composite inner2 = toolkit.createComposite((Composite)section2);
        GridLayout layout2 = new GridLayout();
        inner2.setLayout((Layout)layout2);
        layout2.numColumns = 1;
        this.btOpenExcel = new Button(inner2, 2048);
        this.btOpenExcel.setText(Messages.ReadExcelDefinitionDialog_SelectExcel);
        this.fileList = new List(inner2, 2052);
        this.fileList.setItems(this.files);
        gd = new GridData(768);
        this.fileList.setLayoutData((Object)gd);
        gd = new GridData(1808);
        this.fileList.setLayoutData((Object)gd);
        this.fileList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReadExcelDefinitionDialog.this.refresh();
            }
        });
        this.btOpenExcel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ReadExcelDefinitionDialog.this.getShell(), 4098);
                dialog.setFilterExtensions(new String[]{"*.xls"});
                dialog.open();
                ReadExcelDefinitionDialog.this.dir = dialog.getFilterPath();
                ReadExcelDefinitionDialog.this.files = dialog.getFileNames();
                ReadExcelDefinitionDialog.this.fileList.setItems(ReadExcelDefinitionDialog.this.files);
                if (ReadExcelDefinitionDialog.this.fileList.getItemCount() > 0) {
                    ReadExcelDefinitionDialog.this.fileList.setSelection(0);
                    ReadExcelDefinitionDialog.this.refresh();
                }
            }
        });
        section2.setClient((Control)inner2);
        section2.setLayoutData((Object)new GridData(1808));
        this.tab = new CTabFolder((Composite)section3, 2048);
        section3.setClient((Control)this.tab);
        return root;
    }

    private void refresh() {
        File f = new File(this.dir, this.files[this.fileList.getSelectionIndex()]);
        this.fLogger.info((Object)("Refresh[" + f + "]"));
        if (f.exists()) {
            try {
                ReadExcel excel = new ReadExcel(f);
                if (this.selectedMode == MODE_ONE) {
                    excel.parse();
                } else {
                    excel.parse();
                }
            }
            catch (Exception e) {
                this.fLogger.warn((Object)e);
            }
        }
    }

    public ExcelDefData getExcelDefData() {
        return this.data;
    }

    protected void buttonPressed(int buttonId) {
        File[] ret = new File[this.files.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = new File(this.dir, this.files[i]);
            ++i;
        }
        try {
            this.data = new ExcelDefData();
            if (buttonId == 0) {
                this.data.is_create_comment_ddl = true;
            } else if (buttonId == 400) {
                this.data.is_create_table_ddl = true;
            }
            this.data.files = ret;
            this.data.selectedMode = this.selectedMode;
            this.data.fStartLine = this.fStartLine.getSelection();
            this.data.fPhysicalTableName = this.fPhysicalTableName.getText();
            this.data.fLogicalTableName = this.fLogicalTableName.getText();
            this.data.fPhysicalColumnName = this.fPhysicalColumnName.getText();
            this.data.fLogicalColumnName = this.fLogicalColumnName.getText();
            this.data.fDataType = this.fDataType.getText();
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (buttonId == 12) {
            this.close();
        }
    }

    public void modifyText(ModifyEvent arg0) {
        System.out.println(arg0.data + "/" + arg0.getSource() + "/" + arg0.getClass());
        this.refrButtons();
        this.refresh();
    }

    class ReadExcel
    extends AbsBasicPoiWriter {
        public ReadExcel(File f) {
            super(f);
            this.init();
        }

        public void parse() {
            Matcher m;
            CTabItem[] items = ReadExcelDefinitionDialog.this.tab.getItems();
            int i = 0;
            while (i < items.length) {
                items[i].dispose();
                ++i;
            }
            ReadExcelDefinitionDialog.this.pc = -1;
            ReadExcelDefinitionDialog.this.lc = -1;
            ReadExcelDefinitionDialog.this.ptRow = -1;
            ReadExcelDefinitionDialog.this.ptCol = -1;
            if (ReadExcelDefinitionDialog.this.fPhysicalColumnName.getText().matches("[a-zA-Z]")) {
                ReadExcelDefinitionDialog.this.pc = this.getIndexByColAlphName(ReadExcelDefinitionDialog.this.fPhysicalColumnName.getText());
            }
            if (ReadExcelDefinitionDialog.this.fLogicalColumnName.getText().matches("[a-zA-Z]")) {
                ReadExcelDefinitionDialog.this.lc = this.getIndexByColAlphName(ReadExcelDefinitionDialog.this.fLogicalColumnName.getText());
            }
            if ((m = AC.matcher(ReadExcelDefinitionDialog.this.fPhysicalTableName.getText())).matches()) {
                ReadExcelDefinitionDialog.this.ptRow = Integer.parseInt(m.group(2));
                ReadExcelDefinitionDialog.this.ptCol = this.getIndexByColAlphName(m.group(1));
            }
            if ((m = AC.matcher(ReadExcelDefinitionDialog.this.fLogicalTableName.getText())).matches()) {
                ReadExcelDefinitionDialog.this.ltRow = Integer.parseInt(m.group(2));
                ReadExcelDefinitionDialog.this.ltCol = this.getIndexByColAlphName(m.group(1));
            }
            int i2 = 0;
            while (i2 < this.fHSSFWorkbook.getNumberOfSheets()) {
                CTabItem item = new CTabItem(ReadExcelDefinitionDialog.this.tab, 0);
                item.setText(this.fHSSFWorkbook.getSheetName(i2));
                HSSFSheet sheet = this.fHSSFWorkbook.getSheetAt(i2);
                Table t = new Table((Composite)ReadExcelDefinitionDialog.this.tab, 2048);
                item.setControl((Control)t);
                t.setHeaderVisible(true);
                t.setLinesVisible(true);
                int j = 0;
                while (j < HEADER.length) {
                    TableColumn col = new TableColumn(t, 0);
                    col.setText(HEADER[j]);
                    col.setWidth(50);
                    ++j;
                }
                int irow = 0;
                while (irow < sheet.getPhysicalNumberOfRows() && irow < 30) {
                    TableItem ti = new TableItem(t, 0);
                    if (ReadExcelDefinitionDialog.this.pc > 1 && ReadExcelDefinitionDialog.this.pc < HEADER.length) {
                        ti.setBackground(ReadExcelDefinitionDialog.this.pc + 1, ColorConstants.gray);
                    }
                    if (ReadExcelDefinitionDialog.this.lc > 1 && ReadExcelDefinitionDialog.this.lc < HEADER.length) {
                        ti.setBackground(ReadExcelDefinitionDialog.this.lc + 1, ColorConstants.lightGray);
                    }
                    if (ReadExcelDefinitionDialog.this.ptRow == irow + 1) {
                        ti.setBackground(ReadExcelDefinitionDialog.this.ptCol + 1, ColorConstants.green);
                    }
                    if (ReadExcelDefinitionDialog.this.ltRow == irow + 1) {
                        ti.setBackground(ReadExcelDefinitionDialog.this.ltCol + 1, ColorConstants.darkGreen);
                    }
                    if (irow + 1 == ReadExcelDefinitionDialog.this.fStartLine.getSelection()) {
                        ti.setBackground(ColorConstants.lightBlue);
                    }
                    String[] def = new String[HEADER.length];
                    def[0] = "" + (irow + 1);
                    int j2 = 1;
                    while (j2 < def.length) {
                        def[j2] = "";
                        ++j2;
                    }
                    HSSFRow row = sheet.getRow(irow);
                    if (row == null) {
                        ti.setText(def);
                    } else {
                        int j3 = row.getFirstCellNum();
                        while (j3 < row.getLastCellNum() && j3 < def.length - 1) {
                            HSSFCell cell = row.getCell(j3);
                            if (cell != null) {
                                def[j3 + 1] = this.getCellString(cell);
                            }
                            ++j3;
                        }
                        ti.setText(def);
                    }
                    ++irow;
                }
                ++i2;
            }
            if (ReadExcelDefinitionDialog.this.tab.getItemCount() > 0) {
                ReadExcelDefinitionDialog.this.tab.setSelection(0);
            }
        }
    }
}

