/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import hiro.yoshioka.job.DiffResultSetExcelWriter;
import hiro.yoshioka.job.ResultSetExcelWriter;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sdh.diff.DiffToResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.program.Program;

public class ResultSet2ExcelJob
extends Job {
    protected transient Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    ResultSetDataHolder2[] fResultSetDataHolder;
    DiffToResultSetDataHolder[] fDiffToResultSetDataHolder;
    String displayName;
    String targetDisplayName;

    public ResultSet2ExcelJob(ResultSetDataHolder2[] rdh) {
        super("ResultSet Excel");
        this.fResultSetDataHolder = rdh;
    }

    public ResultSet2ExcelJob(DiffToResultSetDataHolder[] drh, String displayName, String targetDisplayName) {
        super("Diff ResultSet Excel");
        this.fDiffToResultSetDataHolder = drh;
        this.displayName = displayName;
        this.targetDisplayName = targetDisplayName;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus ret = Status.CANCEL_STATUS;
        try {
            monitor.beginTask("ResultSet2Excel", 100);
            IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.xlsFolder);
            File file = ResourceMarker.cnvFile(ResourceMarker.createRandomFile(folder, ResourceMarker.xlsFolder));
            ResultSetExcelWriter writer = null;
            writer = this.fDiffToResultSetDataHolder == null ? new ResultSetExcelWriter(this.fResultSetDataHolder, file) : new DiffResultSetExcelWriter(this.fDiffToResultSetDataHolder, this.displayName, this.targetDisplayName, file);
            this.fLogger.trace((Object)("EXCEL_DO_COLBREAK=" + PreferenceUtil.getBoolean("EXCEL_DO_COLBREAK")));
            this.fLogger.trace((Object)("EXCEL_COLBREAK_NUM=" + PreferenceUtil.getInt("EXCEL_COLBREAK_NUM")));
            this.fLogger.trace((Object)("EXCEL_COL_WIDTH=" + PreferenceUtil.getInt("EXCEL_COL_WIDTH")));
            ResultSetExcelWriter.configure(PreferenceUtil.getBoolean("EXCEL_DO_COLBREAK"), PreferenceUtil.getInt("EXCEL_COLBREAK_NUM"), PreferenceUtil.getInt("EXCEL_COL_WIDTH"), PreferenceUtil.getBoolean("EXCEL_DO_SHEETBREAK"));
            ret = writer.write(monitor);
            this.fLogger.trace((Object)("ret=" + ret));
            if (ret == Status.OK_STATUS) {
                Application.setStatus("File[" + file.getAbsolutePath() + "]");
                this.fLogger.trace((Object)("launch[" + file.getAbsolutePath() + "]"));
                if (!Program.launch((String)file.getAbsolutePath()) && !Program.launch((String)("/usr/lib/openoffice.org/program/scalc " + file.getAbsolutePath()))) {
                    Program.launch((String)file.getAbsoluteFile().getParentFile().getAbsolutePath());
                }
            }
        }
        catch (Throwable e) {
            this.fLogger.warn((Object)"", e);
            ret = Status.CANCEL_STATUS;
        }
        return ret;
    }
}

