/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sdh.StringRecordDataHolder;
import hiro.yoshioka.sdh.diff.DiffCatalog;
import hiro.yoshioka.sdh.diff.DiffToResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.engine.DifferenceInStructureRequest;
import hiro.yoshioka.sql.engine.MirroringRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.ui.view.DiffResultSetView;
import hiro.yoshioka.wolfdbmanager.Application;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CompareDatabasesJob
extends Job
implements Runnable {
    static String[] EMPTY = new String[0];
    protected Log fLogger = LogFactory.getLog(this.getClass());
    DiffToResultSetDataHolder[] drhs;
    MirroringRequest request;
    DifferenceInStructureRequest difference_struct_request;
    Set<IDBTable> compareTableSet;

    public CompareDatabasesJob(DifferenceInStructureRequest difference_struct_request, MirroringRequest request, Set<IDBTable> compareTableSet) {
        super("Compare to Another DB Job");
        this.difference_struct_request = difference_struct_request;
        this.request = request;
        this.compareTableSet = compareTableSet;
    }

    @Override
    public void run() {
        DiffResultSetView view = Application.showAndCreateDiffRstView("Compare to Another DB");
        view.setPartName("Compare to Another DB");
        try {
            ConnectionProperties me = this.request.getConnectionProperties();
            ConnectionProperties you = this.request.getTargetConnectionProperties();
            String message = String.format("[%s <=> %s]", me.getDisplayString(), you.getDisplayString());
            view.setMessage(message);
            view.setConnectionPropertiesDisplay(me.getDisplayString());
            view.setTargetConnectionPropertiesDisplay(you.getDisplayString());
        }
        catch (Exception exception) {}
        view.setInput(this.drhs, true);
        view.disableNextDiff();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus ret = Status.CANCEL_STATUS;
        try {
            this.compare(monitor);
            ret = Status.OK_STATUS;
        }
        catch (Exception e) {
            this.fLogger.error((Object)"", (Throwable)e);
            Application.openErrorDialog(null, "[Compare to Another DB Error]", e);
            ret = Status.CANCEL_STATUS;
        }
        return ret;
    }

    public IStatus compare(IProgressMonitor monitor) throws SQLException {
        IStatus ret = Status.CANCEL_STATUS;
        try {
            ArrayList<DiffToResultSetDataHolder> rList = new ArrayList<DiffToResultSetDataHolder>();
            monitor.beginTask("Compare Start", 2);
            if (this.difference_struct_request != null) {
                monitor.subTask("Check difference in structure.");
                try {
                    SQLServerThread.runNowThisRequest((Request)this.difference_struct_request);
                    DiffCatalog catalog = this.difference_struct_request.getDiffCatalog();
                    for (String key : catalog.getDdhMap().keySet()) {
                        DiffToResultSetDataHolder differ = (DiffToResultSetDataHolder)catalog.getDdhMap().get(key);
                        ResultSetDataHolder2 cfr_ignored_0 = (ResultSetDataHolder2)differ.getLeftTarget();
                        ResultSetDataHolder2 cfr_ignored_1 = (ResultSetDataHolder2)differ.getRightTarget();
                        rList.add(differ);
                    }
                }
                catch (Exception e) {
                    this.fLogger.debug((Object)("Failuer DiffCatalog:" + e.getMessage()));
                }
            }
            monitor.worked(1);
            if (this.request != null) {
                String fromDisplay = this.request.getConnectionProperties().getDisplayString();
                String toDisplay = this.request.getTargetConnectionProperties().getDisplayString();
                ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(this.request.getConnectionProperties());
                ITransactionSQL target_sql = SQLServerThread.getSQLServer().getTransactionSQL(this.request.getTargetConnectionProperties());
                System.out.println("FROM**" + this.request.getConnectionProperties().getDisplayString());
                System.out.println("TO**" + this.request.getTargetConnectionProperties().getDisplayString());
                for (String fromSchema : this.request.getMappingFromSchemaNames()) {
                    String toSchema = this.request.getMappingToSchemaName(fromSchema);
                    Set fromTableSet = sql.getTables(fromSchema);
                    Set toTableSet = target_sql.getTables(toSchema);
                    int tCnt = 1;
                    monitor.beginTask(String.format("Compare [%s]%s to [%s]%s", fromDisplay, fromSchema, toDisplay, toSchema), fromTableSet.size());
                    ResultSetDataHolder2 rdh = null;
                    ResultSetDataHolder2 rdh2 = null;
                    for (String fromTable : fromTableSet) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        monitor.subTask(String.format("(%03d/%03d) Select %s.%s", tCnt, fromTableSet.size(), fromSchema, fromTable));
                        try {
                            String toTable = null;
                            for (String t : toTableSet) {
                                if (!t.equalsIgnoreCase(fromTable)) continue;
                                toTable = t;
                                break;
                            }
                            if (toTable == null) {
                                rdh2 = new ResultSetDataHolder2(new String[]{"Result"}, null, DatabaseType.UNKNOWN);
                                rdh2.addRow(new String[]{"The Table [" + fromTable + "] is nothing in this schema."});
                                rdh2.setTableNameE(fromTable);
                                rdh = new ResultSetDataHolder2(new String[]{"Result"}, null, DatabaseType.UNKNOWN);
                                String target = String.format("Compare target %s#%s.%s is nothing", toDisplay, toSchema, fromTable);
                                rdh.addRow(new String[]{target});
                                rdh.setTableNameE(fromTable);
                                DiffToResultSetDataHolder differ = new DiffToResultSetDataHolder();
                                differ.diffConfigure((StringRecordDataHolder)rdh, (StringRecordDataHolder)rdh2, new int[1]);
                                rList.add(differ);
                            } else {
                                rdh = sql.getAllData2(fromSchema, fromTable, (Request)this.request);
                                rdh2 = target_sql.getAllData2(toSchema, toTable, (Request)this.request);
                                if (rdh != null && rdh2 != null) {
                                    DiffToResultSetDataHolder differ = new DiffToResultSetDataHolder();
                                    List pkColNameList = sql.getTablePrimaryKeys(null, fromSchema, fromTable);
                                    ArrayList<Integer> pkPosList = new ArrayList<Integer>();
                                    String[] keys = rdh.getKey();
                                    int jj = 0;
                                    while (jj < keys.length) {
                                        for (String pkCol : pkColNameList) {
                                            if (!keys[jj].equalsIgnoreCase(pkCol)) continue;
                                            pkPosList.add(jj);
                                            break;
                                        }
                                        ++jj;
                                    }
                                    int[] dp = new int[pkPosList.size()];
                                    if (pkColNameList.size() == 0) {
                                        dp = new int[1];
                                    } else {
                                        int jj2 = 0;
                                        while (jj2 < dp.length) {
                                            dp[jj2] = (Integer)pkPosList.get(jj2);
                                            ++jj2;
                                        }
                                    }
                                    int m = 0;
                                    while (m < dp.length) {
                                        this.fLogger.info((Object)("Compare Key->" + dp[m]));
                                        ++m;
                                    }
                                    differ.diffConfigure((StringRecordDataHolder)rdh, (StringRecordDataHolder)rdh2, dp);
                                    differ.diff();
                                    rList.add(differ);
                                }
                            }
                            ++tCnt;
                        }
                        catch (Exception e) {
                            this.fLogger.debug((Object)"", (Throwable)e);
                        }
                        monitor.worked(1);
                    }
                }
            }
            this.drhs = rList.toArray(new DiffToResultSetDataHolder[rList.size()]);
            monitor.setTaskName("Result");
            monitor.worked(1);
            Application.exec(this);
        }
        catch (Throwable e) {
            this.fLogger.warn((Object)"", e);
            ret = Status.CANCEL_STATUS;
        }
        return ret;
    }
}

