/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.generator.usingrdh;

import hiro.yoshioka.generator.formatter.ColumnGenerateFormat;
import hiro.yoshioka.generator.usingrdh.ColumnDefPage;
import hiro.yoshioka.generator.usingrdh.Messages;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sdh.RDHTableViewer;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.INameFamily;
import hiro.yoshioka.sql.resource.xml.DBColumnValue;
import hiro.yoshioka.sql.resource.xml.DBTableValue;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class RDHCustomizedWizard
extends Wizard {
    public ResultSetDataHolder2 rdh;
    private ChoiceRowsPage page0;
    TableDefPage page1;
    ColumnDefPage page2;
    List<ColumnGenerateFormat> list = new ArrayList<ColumnGenerateFormat>();
    private DBTableValue tbl;
    private boolean pageOneFlg;
    boolean doTableSelectFlg;
    private int colIdx;
    public ColumnGenerateFormat fColumnGenerateFormat;
    private ConnectionProperties connectionProperties;

    public RDHCustomizedWizard(DBTableValue tbl, ConnectionProperties p) {
        this.connectionProperties = p;
        this.setNeedsProgressMonitor(true);
        this.tbl = tbl;
        this.pageOneFlg = false;
        this.doTableSelectFlg = false;
        DBColumnValue[] columns = tbl.getColumns();
        int i = 0;
        while (i < columns.length) {
            ColumnGenerateFormat data = new ColumnGenerateFormat(columns[i]);
            this.list.add(data);
            ++i;
        }
    }

    public RDHCustomizedWizard(DBTableValue tbl, ColumnGenerateFormat columnGenerateFormat) {
        this.doTableSelectFlg = false;
        this.setNeedsProgressMonitor(true);
        this.tbl = tbl;
        this.fColumnGenerateFormat = columnGenerateFormat;
        this.pageOneFlg = true;
    }

    public ColumnGenerateFormat[] getFormats() {
        return this.list.toArray(new ColumnGenerateFormat[this.list.size()]);
    }

    public boolean performFinish() {
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        try {
            if (nextPage instanceof TableDefPage) {
                TableDefPage npage = (TableDefPage)nextPage;
                if (this.doTableSelectFlg) {
                    npage.resetRdh();
                } else {
                    npage.resetPages();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nextPage;
    }

    public void addPages() {
        try {
            if (this.pageOneFlg) {
                this.page2 = new ColumnDefPage(this.fColumnGenerateFormat);
                this.addPage((IWizardPage)this.page2);
            } else {
                this.page0 = new ChoiceRowsPage(this.tbl);
                this.addPage((IWizardPage)this.page0);
                this.page1 = new TableDefPage(this.tbl);
                this.addPage((IWizardPage)this.page1);
                int i = 0;
                while (i < this.list.size()) {
                    this.page2 = new ColumnDefPage(this.list.get(i));
                    this.addPage((IWizardPage)this.page2);
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    class ChoiceRowsPage
    extends WizardPage
    implements SelectionListener {
        private static final String MSG_TITLE = "Choice ResultSetData";
        private static final String MSG_WELCOME_MESSAGE = "Which one?";
        private static final String MSG_USING_RST = "Using file";
        private static final String MSG_OPEN_FILE = "Open...";
        private static final String MSG_SELECTION_RST = "Selection table";
        private static final String MSG_DISCONNECED = "_[Now Disconnected on DB]";
        private DBTableValue tbl;
        private Button btSelect;
        private Button btFile;
        private Button btOpenFile;
        RDHTableViewer table;

        protected ChoiceRowsPage(DBTableValue tbl) {
            super(MSG_TITLE);
            this.tbl = tbl;
            this.setMessage(MSG_WELCOME_MESSAGE);
        }

        public void createControl(Composite parent) {
            Composite c = new Composite(parent, 0);
            c.setLayout((Layout)new GridLayout(2, false));
            this.btFile = new Button(c, 16);
            this.btFile.setText(MSG_USING_RST);
            this.btFile.addSelectionListener((SelectionListener)this);
            this.btOpenFile = new Button(c, 8);
            this.btOpenFile.setText(MSG_OPEN_FILE);
            this.btOpenFile.addSelectionListener((SelectionListener)this);
            this.btSelect = new Button(c, 16);
            this.btSelect.addSelectionListener((SelectionListener)this);
            if (RDHCustomizedWizard.this.connectionProperties == null || !RDHCustomizedWizard.this.connectionProperties.isConnected()) {
                this.btSelect.setEnabled(false);
                this.btSelect.setText("Selection table_[Now Disconnected on DB]");
            } else {
                this.btSelect.setText(MSG_SELECTION_RST);
            }
            this.setControl((Control)c);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button bt;
            this.btOpenFile.setEnabled(this.btFile.getSelection());
            RDHCustomizedWizard wiz = (RDHCustomizedWizard)this.getWizard();
            wiz.doTableSelectFlg = false;
            this.setPageComplete(false);
            if (this.btSelect.getSelection()) {
                wiz.doTableSelectFlg = true;
                this.setPageComplete(true);
            }
            if ((bt = (Button)e.widget).getText().equals(MSG_OPEN_FILE)) {
                FileDialog openDialog = new FileDialog(this.getShell(), 4096);
                IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.rstFolder);
                openDialog.setFilterPath(ResourceMarker.cnvFile(folder).getAbsolutePath());
                openDialog.setFilterExtensions(new String[]{"*." + ResourceMarker.rstFolder, "*.*"});
                String filePath = openDialog.open();
                this.setErrorMessage(null);
                if (!StringUtil.isEmpty((Object)filePath)) {
                    String[] keys;
                    ResultSetDataHolder2 rdh = (ResultSetDataHolder2)PreferenceUtil.readObject(new File(filePath));
                    if (rdh == null) {
                        this.setErrorMessage("Read Error [" + filePath + "]");
                        this.setPageComplete(false);
                        return;
                    }
                    if (!this.tbl.getName().equalsIgnoreCase(rdh.getTableNameE())) {
                        this.setErrorMessage("Different Table [" + this.tbl.getName() + "/" + rdh.getTableNameE() + "]");
                        this.setPageComplete(false);
                        return;
                    }
                    DBColumnValue[] columns = this.tbl.getColumns();
                    if (columns.length != (keys = rdh.getKey()).length - 1) {
                        this.setErrorMessage("Different column count [" + columns.length + "/" + (keys.length - 1) + "]");
                        this.setPageComplete(false);
                        return;
                    }
                    int i = 0;
                    while (i < columns.length) {
                        if (!columns[i].getName().equalsIgnoreCase(keys[i + 1])) {
                            this.setErrorMessage("Different column [" + columns[i].getName() + "/" + keys[i + 1] + "]");
                            this.setPageComplete(false);
                            return;
                        }
                        ++i;
                    }
                    wiz.rdh = rdh;
                    this.btOpenFile.setEnabled(false);
                    this.setMessage("Read Complete...");
                    this.setPageComplete(true);
                }
            }
        }
    }

    class TableDefPage
    extends WizardPage {
        private Spinner fSpinner;
        private DBTableValue tbl;
        RDHTableViewer table;

        protected TableDefPage(DBTableValue tbl) {
            super(Messages.getString("RDHCustomizedWizard.SamplingRecords"));
            this.tbl = tbl;
            this.setTitle(Messages.getString("RDHCustomizedWizard.SamplingRecords"));
            this.setMessage(Messages.getString("RDHCustomizedWizard.HowManyRecords"));
        }

        void resetPages() {
            RDHCustomizedWizard wiz = (RDHCustomizedWizard)this.getWizard();
            if (wiz.rdh == null) {
                return;
            }
            if (this.table != null) {
                this.table.setInputAdjustDatum((ResultSetDataHolder)wiz.rdh);
            }
            this.fSpinner.setEnabled(wiz.doTableSelectFlg);
            if (wiz.rdh.getRowCount() == 0) {
                this.setErrorMessage(Messages.getString("RDHCustomizedWizard.ErrorNoRecord"));
            } else {
                ColumnDefPage nextPage = (ColumnDefPage)wiz.getNextPage((IWizardPage)this);
                while (nextPage != null) {
                    nextPage.refreshTable(true);
                    nextPage = (ColumnDefPage)nextPage.getNextPage();
                }
            }
        }

        void resetRdh() {
            RDHCustomizedWizard wiz = (RDHCustomizedWizard)this.getWizard();
            if (RDHCustomizedWizard.this.connectionProperties == null || !RDHCustomizedWizard.this.connectionProperties.isConnected()) {
                wiz.rdh = null;
                this.setErrorMessage(Messages.getString("RDHCustomizedWizard.ClosingDBConnection"));
                this.setPageComplete(false);
                return;
            }
            try {
                SQLServerThread.getSQLServer().getTransactionSQL(RDHCustomizedWizard.this.connectionProperties);
                TransactionRequest request = new TransactionRequest(SQLOperationType.SELECT_ALL, RDHCustomizedWizard.this.connectionProperties, (INameFamily)this.tbl);
                request.setMaxRownum(this.fSpinner.getSelection());
                request.execute();
                wiz.rdh = request.getRdh();
                this.resetPages();
            }
            catch (Throwable e) {
                wiz.rdh = null;
                this.setPageComplete(false);
                this.setErrorMessage(String.valueOf(Messages.getString("RDHCustomizedWizard.7")) + e.getLocalizedMessage() + Messages.getString("RDHCustomizedWizard.8"));
                e.printStackTrace();
            }
        }

        public void createControl(Composite parent) {
            RDHCustomizedWizard cfr_ignored_0 = (RDHCustomizedWizard)this.getWizard();
            Composite c = new Composite(parent, 0);
            c.setLayout((Layout)new GridLayout(2, false));
            new Label(c, 0).setText(Messages.getString("RDHCustomizedWizard.SelectionRecordsLabel"));
            this.fSpinner = new Spinner(c, 2048);
            GridData gd = new GridData(768);
            this.fSpinner.setLayoutData((Object)gd);
            this.fSpinner.setValues(5, 1, 100, 0, 1, 5);
            this.fSpinner.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TableDefPage.this.resetRdh();
                }
            });
            this.table = new RDHTableViewer(c);
            this.table.getTable().setHeaderVisible(true);
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            this.table.getTable().setLayoutData((Object)gd);
            this.setControl((Control)c);
        }

        private void updateStatus(String str) {
            this.setErrorMessage(str);
        }
    }
}

