/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.generator.bean;

import hiro.yoshioka.generator.CustomizedFormatter;
import hiro.yoshioka.generator.MyFormatter;
import hiro.yoshioka.generator.bean.GenerateManagerBean;
import hiro.yoshioka.generator.bean.GeneratorBean;
import hiro.yoshioka.generator.formatter.ColumnGenerateFormat;
import hiro.yoshioka.generator.formatter.GenerateFormatDef;
import hiro.yoshioka.preferences.GenerateType;
import hiro.yoshioka.sql.resource.xml.DBColumnValue;

public class GroupGeneratorBean {
    private GenerateManagerBean parent;
    private DBColumnValue column;
    private GenerateType generateType;
    private int startValue;
    private int groupIdx;
    private GeneratorBean gb;

    public GroupGeneratorBean() {
    }

    public GroupGeneratorBean(GenerateManagerBean parent, DBColumnValue column) {
        this.parent = parent;
        this.column = column;
    }

    public GenerateManagerBean getGenerateManager() {
        return this.parent;
    }

    public GeneratorBean getGeneratorBean() {
        return this.gb;
    }

    public GeneratorBean resetGenerator() {
        GeneratorBean gen;
        this.gb = gen = new GeneratorBean(this);
        return gen;
    }

    public String getColumnName() {
        return this.column.getName();
    }

    public String toString() {
        if (this.gb == null) {
            return "";
        }
        return this.gb.toString();
    }

    public boolean validate() {
        if (this.gb == null) {
            return true;
        }
        return this.gb.validate();
    }

    public GenerateManagerBean getParent() {
        return this.parent;
    }

    public void setParent(GenerateManagerBean parent) {
        this.parent = parent;
    }

    public DBColumnValue getColumn() {
        return this.column;
    }

    public void setColumn(DBColumnValue column) {
        this.column = column;
    }

    public int getStartValue() {
        return this.startValue;
    }

    public void setStartValue(int startValue) {
        this.startValue = startValue;
    }

    public MyFormatter resetGenerateType(GenerateType type) {
        GeneratorBean gen = this.resetGenerator();
        MyFormatter formatter = null;
        switch (type) {
            case RANDOM: {
                formatter = gen.setRandomFormat();
                break;
            }
            case SEQUENCE: {
                formatter = gen.setDefaultFormat();
                break;
            }
            case XXX: {
                formatter = gen.setXxxFormat();
                break;
            }
            case TEXT_FILE: {
                formatter = gen.setTextFormat();
            }
        }
        this.generateType = type;
        return formatter;
    }

    public ColumnGenerateFormat getColumnGenerateFormat() {
        ColumnGenerateFormat fmt = new ColumnGenerateFormat(this.column);
        if (this.gb != null) {
            int j = 0;
            while (j < this.gb.getFormatterList().size()) {
                CustomizedFormatter cus = (CustomizedFormatter)this.gb.getFormatterList().get(j);
                GenerateFormatDef defs = new GenerateFormatDef(cus.getDef().getFormat());
                fmt.addDef(defs);
                ++j;
            }
        }
        return fmt;
    }

    public void resetGenerateType(GenerateType type, ColumnGenerateFormat columnGenerateFormat) {
        GenerateFormatDef[] groups = columnGenerateFormat.getGenerateFormatDefs();
        int i = 0;
        while (i < groups.length) {
            GeneratorBean gen = this.resetGenerator();
            gen.setCustomizedFormat(groups);
            ++i;
        }
        this.generateType = type;
    }

    public void setGenerateType(GenerateType generateType) {
        this.generateType = generateType;
    }

    public GenerateType getGenerateType() {
        return this.generateType;
    }

    public String getFormatDefinition() {
        return this.gb.getFormatDefinition();
    }

    public String getExtraFormatDefinition() {
        return this.gb.getExtraFormatDefinition();
    }
}

