/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.model;

import hiro.yoshioka.gef.model.AbstractConnectionModel;
import hiro.yoshioka.gef.model.ArrowConnectionModel;
import hiro.yoshioka.gef.model.AssistTextPropertyDescriptor;
import hiro.yoshioka.gef.model.Column;
import hiro.yoshioka.gef.model.Messages;
import hiro.yoshioka.gef.model.MyRectangle;
import hiro.yoshioka.gef.model.PropertyAwareObject;
import hiro.yoshioka.gef.model.Schema;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sql.DataBaseFactory;
import hiro.yoshioka.sql.resource.xml.DBColumnValue;
import hiro.yoshioka.sql.resource.xml.DBCrossRefferenceValue;
import hiro.yoshioka.sql.resource.xml.DBTableValue;
import hiro.yoshioka.util.SQLDataType;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class Table
extends PropertyAwareObject {
    public static final String P_TABLE_NAME = "_text";
    public static final String P_CONDITION_VALUE = "_condition";
    public static final String P_ORDER_BY_VALUE = "_orderby";
    public static final String P_SQL_VALUE = "_sql";
    public static final String P_DIFF_VALUE = "_diff";
    public static final String P_DO_SELECT = "_do_select";
    public static final String P_DO_DISTINCT = "_do_select_distinct";
    public static final String P_DO_AS_COMMENT = "_do_as_COMMENT";
    public static final String[] P_BOOLEAN_VALUE = new String[]{Messages.getString("Table.Maru"), Messages.getString("Table.Batsu")};
    private String conditionValue = "";
    private String orderByValue = "";
    private String diffKeys = "";
    boolean execute_select = true;
    private boolean execute_distinct;
    private boolean as_comment;
    Pattern ColumPattern;
    private Schema schema;
    private DBTableValue dBTable;
    private DBCrossRefferenceValue[] crossRefference;
    public ArrayList<Column> columns = new ArrayList();
    private MyRectangle bounds;
    private boolean editablePK = true;

    public Table() {
        System.out.println("here Table()");
    }

    public Table(DBTableValue table, Schema schema) {
        System.out.println("here Table()" + table);
        try {
            if (table == null) {
                throw new NullPointerException("table cannot be null");
            }
            if (schema == null) {
                throw new NullPointerException("Schema cannot be null");
            }
            this.fLogger.warn((Object)("Table:" + table));
            this.dBTable = table;
            this.schema = schema;
            this.init();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void init() {
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("([, =<>]+)");
            buf.append("(");
            DBColumnValue[] cols = this.getDBColumns();
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < cols.length) {
                if (i > 0) {
                    buf.append("|");
                }
                buf.append(cols[i].getUName());
                if (cols[i].isPkey()) {
                    this.editablePK = false;
                    if (buff.length() > 0) {
                        buff.append(",");
                    }
                    buff.append(cols[i].getName());
                }
                ++i;
            }
            buf.append(")");
            if (!this.editablePK) {
                this.diffKeys = buff.toString();
            }
            this.ColumPattern = Pattern.compile(buf.toString(), 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DBColumnValue[] getDBColumns() {
        return this.dBTable.getColumns();
    }

    public void addColumn(Column column) {
        if (this.columns.contains(column)) {
            throw new IllegalArgumentException("Column already present");
        }
        this.columns.add(column);
        column.setParent(this);
        this.firePropertyChange("CHILD", null, column);
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = new MyRectangle(bounds);
    }

    public void modifyBounds(Rectangle bounds) {
        MyRectangle oldBounds = this.bounds;
        if (!bounds.equals((Object)oldBounds)) {
            this.bounds = new MyRectangle(bounds);
            this.firePropertyChange("BOUNDS", null, bounds);
        }
    }

    public String getNameWithComment() {
        return this.dBTable.getNameWithComment(25);
    }

    public String getName() {
        return this.dBTable.getName();
    }

    public String getComment() {
        return this.dBTable.getComment();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public String toString() {
        return this.dBTable.toString();
    }

    public DBTableValue getDBTable() {
        return this.dBTable;
    }

    public void setDBTable(DBTableValue table) {
        this.dBTable = table;
    }

    public void setBounds(MyRectangle bounds) {
        this.bounds = bounds;
    }

    public ArrayList<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(ArrayList<Column> columns) {
        this.columns = columns;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        String[] cols = new String[this.columns.size()];
        int i = 0;
        while (i < cols.length) {
            cols[i] = this.columns.get(i).getColumn().getName();
            ++i;
        }
        AssistTextPropertyDescriptor pk = null;
        pk = this.getDBTable().isHasPk() ? new AssistTextPropertyDescriptor(this, P_DIFF_VALUE, Messages.getString("Table.3CompKey"), cols) : new AssistTextPropertyDescriptor(this, P_DIFF_VALUE, Messages.getString("Table.3CompKey2"), cols);
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)P_TABLE_NAME, Messages.getString("Table.0TbaleName")), new AssistTextPropertyDescriptor(this, P_CONDITION_VALUE, Messages.getString("Table.1Where"), cols), new AssistTextPropertyDescriptor(this, P_ORDER_BY_VALUE, Messages.getString("Table.2Order"), cols), pk, new TextPropertyDescriptor((Object)P_SQL_VALUE, Messages.getString("Table.4Dump")), new ComboBoxPropertyDescriptor((Object)P_DO_SELECT, Messages.getString("Table.5SelectionTarget"), P_BOOLEAN_VALUE), new ComboBoxPropertyDescriptor((Object)P_DO_AS_COMMENT, Messages.getString("Table.6ASComment"), P_BOOLEAN_VALUE), new ComboBoxPropertyDescriptor((Object)P_DO_DISTINCT, Messages.getString("Table.7Distinct"), P_BOOLEAN_VALUE)};
        return descriptors;
    }

    @Override
    public Object getPropertyValue(Object id) {
        try {
            if (id.equals(P_TABLE_NAME)) {
                return this.getDBTable().getNameWithComment();
            }
            if (P_CONDITION_VALUE.equals(id)) {
                return this.conditionValue;
            }
            if (P_DIFF_VALUE.equals(id)) {
                return this.diffKeys;
            }
            if (P_ORDER_BY_VALUE.equals(id)) {
                return this.orderByValue;
            }
            if (P_SQL_VALUE.equals(id)) {
                return this.getSelectStatement(Application.getActiveSchemaDiagramDatabaseType());
            }
            if (P_DO_SELECT.equals(id)) {
                return this.execute_select ? new Integer(0) : new Integer(1);
            }
            if (P_DO_AS_COMMENT.equals(id)) {
                return this.as_comment ? new Integer(0) : new Integer(1);
            }
            if (P_DO_DISTINCT.equals(id)) {
                return this.execute_distinct ? new Integer(0) : new Integer(1);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean isPropertySet(Object id) {
        if (id.equals(P_TABLE_NAME)) {
            return false;
        }
        if (P_CONDITION_VALUE.equals(id)) {
            return false;
        }
        if (P_ORDER_BY_VALUE.equals(id)) {
            return false;
        }
        if (P_SQL_VALUE.equals(id)) {
            return false;
        }
        if (P_DO_SELECT.equals(id)) {
            return false;
        }
        if (P_DO_AS_COMMENT.equals(id)) {
            return false;
        }
        if (P_DO_DISTINCT.equals(id)) {
            return false;
        }
        return false;
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (id.equals(P_CONDITION_VALUE)) {
            this.setConditionValue((String)value);
        } else if (P_ORDER_BY_VALUE.equals(id)) {
            this.setOrderByValue((String)value);
        } else if (P_DIFF_VALUE.equals(id)) {
            if (this.editablePK) {
                this.diffKeys = (String)value;
            }
        } else if (P_DO_SELECT.equals(id)) {
            Integer in = (Integer)value;
            if (in == 0) {
                this.setExecute_select(true);
            } else {
                this.setExecute_select(false);
            }
        } else if (P_DO_AS_COMMENT.equals(id)) {
            Integer in = (Integer)value;
            if (in == 0) {
                this.setAs_comment(true);
            } else {
                this.setAs_comment(false);
            }
        } else if (P_DO_DISTINCT.equals(id)) {
            Integer in = (Integer)value;
            if (in == 0) {
                this.setExecute_distinct(true);
            } else {
                this.setExecute_distinct(false);
            }
        }
    }

    public String getFlashBackStatement(int minute) {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT \n");
        buf.append(" TO_CHAR(VERSIONS_STARTTIME,'HH24:MI:SS') \"STRTTIME\",  VERSIONS_OPERATION \"Operation\", '' || VERSIONS_XID XID, ");
        buf.append(this.getDBTable().getName());
        buf.append(".* \nFROM ");
        String scm = this.getDBTable().getParent().getName();
        String thisTable = "";
        thisTable = scm.trim().length() > 0 ? String.valueOf(scm.trim()) + "." + this.getDBTable().getName() : this.getDBTable().getName();
        buf.append(thisTable);
        buf.append("\n  VERSIONS BETWEEN TIMESTAMP SYSTIMESTAMP - INTERVAL '");
        buf.append(minute).append("' MINUTE AND SYSTIMESTAMP\n");
        buf.append("  WHERE VERSIONS_XID IS NOT NULL \n");
        buf.append("  ORDER BY VERSIONS_STARTTIME DESC NULLS LAST\t \n");
        return buf.toString();
    }

    public String getSelectStatement(DatabaseType databaseType) {
        int i;
        DBColumnValue[] cols;
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        if (this.isExecute_distinct()) {
            buf.append("DISTINCT ");
        }
        if ((cols = this.getDBColumns()).length == 0) {
            buf.append("* ");
        } else {
            int i2 = 0;
            while (i2 < cols.length) {
                if (i2 > 0) {
                    buf.append(",");
                }
                if (this.as_comment) {
                    buf.append("T0.").append(cols[i2].getNameWithAsCommentLimLen());
                } else if (databaseType.needsColumnNameQuote(cols[i2].getName())) {
                    buf.append(String.format("T0.\"%s\"", cols[i2].getName()));
                } else {
                    buf.append("T0.").append(cols[i2].getName());
                }
                ++i2;
            }
        }
        JoinStatementInfo[] joins = this.getTableReferenceJoin(0, true);
        int j = 0;
        while (j < joins.length) {
            if (joins[j].withSelect()) {
                cols = joins[j].tableVale.getColumns();
                i = 0;
                while (i < cols.length) {
                    buf.append(",");
                    if (this.as_comment) {
                        buf.append(joins[j].alias).append(".").append(cols[i].getNameWithAsComment());
                    } else if (databaseType.needsColumnNameQuote(cols[i].getName())) {
                        buf.append(String.format("%s.\"%s\"", joins[j].alias, cols[i].getName()));
                    } else {
                        buf.append(joins[j].alias).append(".").append(cols[i].getName());
                    }
                    ++i;
                }
            }
            ++j;
        }
        buf.append("\r\nFROM ");
        String scm = this.getDBTable().getParent().getName();
        if (scm.trim().length() > 0) {
            if (databaseType.needsTableNameQuote()) {
                buf.append(String.format("%s.\"%s\" T0 %n", scm.trim(), this.getDBTable().getName()));
            } else {
                buf.append(String.format("%s.%s T0 %n", scm.trim(), this.getDBTable().getName()));
            }
        } else if (databaseType.needsTableNameQuote()) {
            buf.append(String.format("\"%s\" T0 %n", this.getDBTable().getName()));
        } else {
            buf.append(String.format("%s T0 %n", this.getDBTable().getName()));
        }
        i = 0;
        while (i < joins.length) {
            buf.append(joins[i].sql);
            ++i;
        }
        String cc = this.schema.getCommonConditionString(this);
        if (this.conditionValue.trim().length() > 0) {
            buf.append("\r\nWHERE ");
            buf.append(this.getFormattedCondition(0));
            if (cc.length() > 0) {
                buf.append("\r\n AND ( ");
                buf.append(cc);
                buf.append(") ");
            }
        } else if (cc.length() > 0) {
            buf.append("\r\nWHERE ");
            buf.append(cc);
        }
        if (this.orderByValue.trim().length() > 0) {
            buf.append("\r\nORDER BY ");
            buf.append(this.getFormattedOrderBy());
        }
        return buf.toString();
    }

    public String getCSVSelectStatement(DatabaseType databaseType) {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT  ");
        DBColumnValue[] cols = this.getDBColumns();
        if (cols.length == 0) {
            buf.append(" * ");
        } else {
            if (this.isExecute_distinct()) {
                buf.append("DISTINCT  ");
            }
            int i2 = 0;
            while (i2 < cols.length) {
                switch (cols[i2].getType()) {
                    case DATE: 
                    case TIMESTAMP: {
                        buf.append(DataBaseFactory.getStringFormat((SQLDataType)cols[i2].getType(), (DatabaseType)databaseType, (String)cols[i2].getUName())).append(" AS ");
                        buf.append(cols[i2].getUName()).append(",");
                        break;
                    }
                    case TIME: {
                        buf.append(DataBaseFactory.getStringFormatHH24MI((DatabaseType)databaseType, (String)cols[i2].getUName())).append(" AS ");
                        buf.append(cols[i2].getUName()).append(",");
                        break;
                    }
                    case NUMERIC: 
                    case DECIMAL: {
                        buf.append(cols[i2].getUName()).append(",");
                        break;
                    }
                    default: {
                        buf.append(cols[i2].getUName()).append(",");
                    }
                }
                ++i2;
            }
            buf.setLength(buf.length() - 1);
        }
        JoinStatementInfo[] joins = this.getTableReferenceJoin(0, true);
        int j = 0;
        while (j < joins.length) {
            if (joins[j].withSelect()) {
                cols = joins[j].tableVale.getColumns();
                i = 0;
                while (i < cols.length) {
                    buf.append(",");
                    if (this.as_comment) {
                        buf.append(joins[j].alias).append(".").append(cols[i].getNameWithAsComment());
                    } else {
                        buf.append(joins[j].alias).append(".").append(cols[i].getName());
                    }
                    ++i;
                }
            }
            ++j;
        }
        buf.append("\r\nFROM ");
        String scm = this.getDBTable().getParent().getName();
        if (scm.trim().length() > 0) {
            buf.append(String.valueOf(scm.trim()) + "." + this.getDBTable().getName()).append(" T0\r\n");
        } else {
            buf.append(this.getDBTable().getName()).append(" T0\r\n");
        }
        i = 0;
        while (i < joins.length) {
            buf.append(joins[i].sql);
            ++i;
        }
        if (this.conditionValue.trim().length() > 0) {
            buf.append("\r\nWHERE ");
            buf.append(this.getFormattedCondition(0));
        }
        if (this.orderByValue.trim().length() > 0) {
            buf.append("\r\nORDER BY ");
            buf.append(this.orderByValue.trim());
        }
        return buf.toString();
    }

    private JoinStatementInfo[] getTableReferenceJoin(int soeji, boolean firstCall) {
        int initSoeji = soeji++;
        ArrayList<JoinStatementInfo> retStringList = new ArrayList<JoinStatementInfo>();
        LinkedHashMap<Table, ArrayList<DBColumnValue[]>> map = new LinkedHashMap<Table, ArrayList<DBColumnValue[]>>();
        HashMap<Table, String> joinTypeMap = new HashMap<Table, String>();
        int i = 0;
        while (i < this.columns.size()) {
            Column columnModel = this.columns.get(i).getSConnectedResource();
            if (columnModel != null) {
                ArrayList<DBColumnValue[]> columnList = (ArrayList<DBColumnValue[]>)map.get(columnModel.getParent());
                if (columnList == null) {
                    columnList = new ArrayList<DBColumnValue[]>();
                    map.put(columnModel.getParent(), columnList);
                    AbstractConnectionModel cm = this.columns.get(i).getSourceConnectionList().get(0);
                    if (cm instanceof ArrowConnectionModel) {
                        joinTypeMap.put(columnModel.getParent(), "INNER JOIN ");
                    } else {
                        joinTypeMap.put(columnModel.getParent(), "LEFT JOIN ");
                    }
                }
                columnList.add(new DBColumnValue[]{this.columns.get(i).getColumn(), columnModel.getColumn()});
            }
            ++i;
        }
        Iterator ite = map.keySet().iterator();
        while (ite.hasNext()) {
            StringBuffer buf = new StringBuffer();
            Table tableModel = (Table)ite.next();
            String talias = "T" + soeji;
            String scm = tableModel.getDBTable().getParent().getName();
            if (scm.trim().length() > 0) {
                buf.append("  ").append((String)joinTypeMap.get(tableModel)).append(String.valueOf(scm) + ".").append(tableModel.getDBTable().getName()).append(" ").append(talias).append(" ON (");
            } else {
                buf.append("  ").append((String)joinTypeMap.get(tableModel)).append(tableModel.getDBTable().getName()).append(" ").append(talias).append(" ON (");
            }
            List cl = (List)map.get(tableModel);
            int i2 = 0;
            while (i2 < cl.size()) {
                if (i2 > 0) {
                    buf.append(" AND ");
                }
                buf.append("T" + initSoeji + ".");
                buf.append(((DBColumnValue[])cl.get(i2))[0].getUName());
                buf.append("=");
                buf.append(talias);
                buf.append(".");
                buf.append(((DBColumnValue[])cl.get(i2))[1].getUName());
                ++i2;
            }
            if (tableModel.conditionValue.trim().length() > 0) {
                buf.append(" AND (").append(tableModel.getFormattedCondition(soeji)).append(")");
            }
            buf.append(")\r\n");
            JoinStatementInfo jsInfo = null;
            jsInfo = firstCall ? new JoinStatementInfo(tableModel.getDBTable(), ((String)joinTypeMap.get(tableModel)).trim().startsWith("LEFT"), buf.toString(), talias) : new JoinStatementInfo(buf.toString());
            retStringList.add(jsInfo);
            JoinStatementInfo[] refJoinInfo = tableModel.getTableReferenceJoin(soeji, true);
            int ri = 0;
            while (ri < refJoinInfo.length) {
                retStringList.add(refJoinInfo[ri]);
                ++ri;
                ++soeji;
            }
            ++soeji;
        }
        return retStringList.toArray(new JoinStatementInfo[retStringList.size()]);
    }

    public String getFormattedOrderBy() {
        if (this.orderByValue.trim().length() == 0) {
            return "";
        }
        if (this.ColumPattern == null) {
            this.init();
        }
        StringBuffer buf = new StringBuffer();
        Matcher m = this.ColumPattern.matcher(" " + this.orderByValue.trim());
        String alias = " T0.";
        while (m.find()) {
            m.appendReplacement(buf, String.valueOf(m.group(1)) + alias + m.group(2));
        }
        m.appendTail(buf);
        return buf.toString();
    }

    public String getFormattedCondition(int soeji) {
        if (this.conditionValue.trim().length() == 0) {
            return "";
        }
        if (this.ColumPattern == null) {
            this.init();
        }
        StringBuffer buf = new StringBuffer();
        Matcher m = this.ColumPattern.matcher(" " + this.conditionValue.trim());
        String alias = " T" + soeji + ".";
        while (m.find()) {
            m.appendReplacement(buf, String.valueOf(alias) + m.group(2));
        }
        m.appendTail(buf);
        return buf.toString();
    }

    public boolean isAs_comment() {
        return this.as_comment;
    }

    public void setAs_comment(boolean as_comment) {
        this.as_comment = as_comment;
    }

    public String getConditionValue() {
        return this.conditionValue;
    }

    public void setConditionValue(String conditionValue) {
        this.conditionValue = conditionValue;
        this.firePropertyChange(P_CONDITION_VALUE, null, conditionValue);
    }

    public boolean isExecute_distinct() {
        return this.execute_distinct;
    }

    public void setExecute_distinct(boolean execute_distinct) {
        this.execute_distinct = execute_distinct;
        this.firePropertyChange(P_DO_DISTINCT, null, execute_distinct);
    }

    public boolean isExecute_select() {
        return this.execute_select;
    }

    public void setExecute_select(boolean execute_select) {
        this.execute_select = execute_select;
        this.firePropertyChange(P_DO_SELECT, null, execute_select);
    }

    public String getOrderByValue() {
        return this.orderByValue;
    }

    public void setOrderByValue(String orderByValue) {
        this.orderByValue = orderByValue;
        this.firePropertyChange(P_ORDER_BY_VALUE, null, orderByValue);
    }

    public int[] getMatchingColumnIndex() {
        String[] cols = this.getDiffKeys().split(",", -1);
        ArrayList<Integer> list = new ArrayList<Integer>();
        DBColumnValue[] allCol = this.getDBColumns();
        int i = 0;
        while (i < cols.length) {
            int j = 0;
            while (j < allCol.length) {
                if (cols[i].trim().equalsIgnoreCase(allCol[j].getName())) {
                    list.add(j + 1);
                    break;
                }
                ++j;
            }
            ++i;
        }
        int[] retList = new int[list.size()];
        int i2 = 0;
        while (i2 < retList.length) {
            retList[i2] = (Integer)list.get(i2);
            ++i2;
        }
        return retList;
    }

    public String getDiffKeys() {
        return this.diffKeys;
    }

    public void setDiffKeys(String diffKeys) {
        this.diffKeys = diffKeys;
    }

    public void setCrossRefference(DBCrossRefferenceValue[] cross) {
        this.crossRefference = cross;
    }

    public DBCrossRefferenceValue[] getCrossRefference() {
        return this.crossRefference;
    }

    class JoinStatementInfo {
        String sql;
        String alias;
        boolean leftJoin;
        DBTableValue tableVale;

        public JoinStatementInfo(DBTableValue table2, boolean isLeftJoin, String sql, String alias) {
            this.tableVale = table2;
            this.leftJoin = isLeftJoin;
            this.sql = sql;
            this.alias = alias;
        }

        public JoinStatementInfo(String sql) {
            this.sql = sql;
        }

        public boolean withSelect() {
            return this.tableVale != null && this.leftJoin;
        }
    }
}

