/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.editor;

import hiro.yoshioka.gef.action.GefCommonAction;
import hiro.yoshioka.gef.action.SchemaContextMenuProvider;
import hiro.yoshioka.gef.dnd.DataEditDropTargetListener;
import hiro.yoshioka.gef.editor.Messages;
import hiro.yoshioka.gef.editor.OverviewOutlinePage;
import hiro.yoshioka.gef.editor.PaletteViewerCreator;
import hiro.yoshioka.gef.editor.SchemaPaletteViewerProvider;
import hiro.yoshioka.gef.model.Schema;
import hiro.yoshioka.gef.part.factory.SchemaEditPartFactory;
import hiro.yoshioka.gef.part.factory.TreeEditPartFactory;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.ConnectionSettingBean;
import hiro.yoshioka.sql.params.IConnectionPropertiesChangeListener;
import hiro.yoshioka.sql.params.PropetiesChangeType;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ImageManager;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GEFPlugin;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SchemaDiagramEditor
extends GraphicalEditorWithFlyoutPalette
implements CommandStackListener,
ISelectionListener,
ITabbedPropertySheetPageContributor,
IConnectionPropertiesChangeListener {
    private Combo connectionCombo;
    private ConnectionProperties myConnectionPropeteis;
    private Spinner maxRowSpinner;
    private int maxRow;
    public static final String ID = Messages.SchemaDiagramEditor_0;
    Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Schema schema;
    private PropertySheetPage undoablePropertySheetPage;
    private List editPartActionIDs = new ArrayList();
    private List stackActionIDs = new ArrayList();
    private List editorActionIDs = new ArrayList();
    private OverviewOutlinePage overviewOutlinePage;
    private ActionRegistry actionRegistry;
    private DefaultEditDomain editDomain = new DefaultEditDomain((IEditorPart)this);
    private boolean isDirty;
    File file;

    public SchemaDiagramEditor() {
        this.setEditDomain(this.editDomain);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.createActions();
        this.setTitleImage(ImageManager.getImageDescriptor("action/table_analysis.png").createImage());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.updateActions(this.editPartActionIDs);
    }

    public void commandStackChanged(EventObject event) {
        this.updateActions(this.stackActionIDs);
        this.setDirty(this.getCommandStack().isDirty());
    }

    public void dispose() {
        IWorkbenchWindow w;
        this.getCommandStack().removeCommandStackListener((CommandStackListener)this);
        IWorkbenchPartSite site = this.getSite();
        if (site != null && (w = site.getWorkbenchWindow()) != null) {
            w.getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
        this.getActionRegistry().dispose();
        super.dispose();
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == GraphicalViewer.class || adapter == EditPartViewer.class) {
            return this.getGraphicalViewer();
        }
        if (adapter == CommandStack.class) {
            return this.getCommandStack();
        }
        if (adapter == EditDomain.class) {
            return this.getEditDomain();
        }
        if (adapter == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        if (adapter == ZoomManager.class) {
            return ((ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (adapter == IContentOutlinePage.class) {
            return new MyContentOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.file.getName().toLowerCase().startsWith("s__")) {
                InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.SchemaDiagramEditor_InputFileName, "Input File Name", "", new IInputValidator(){

                    public String isValid(String arg0) {
                        if (arg0.length() == 0) {
                            return Messages.SchemaDiagramEditor_NameMustNotNull;
                        }
                        File[] children = SchemaDiagramEditor.this.file.getParentFile().listFiles();
                        int i = 0;
                        while (i < children.length) {
                            if (children[i].getName().equalsIgnoreCase(String.valueOf(arg0) + "." + ResourceMarker.lstFolder)) {
                                return Messages.SchemaDiagramEditor_AlreadyExists;
                            }
                            ++i;
                        }
                        return null;
                    }
                });
                if (dlg.open() == 0) {
                    PreferenceUtil.saveXML(this.file, this.getSchema());
                    IFile inputFile = ((FileEditorInput)this.getEditorInput()).getFile();
                    IFolder folder = ResourceMarker.getMyProject().getFolder(ResourceMarker.lstFolder);
                    String fileName = String.valueOf(dlg.getValue()) + "." + ResourceMarker.lstFolder;
                    IFile copiedFile = folder.getFile(fileName);
                    inputFile.copy(copiedFile.getFullPath(), true, monitor);
                    Application.exec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage page = Application.getWorkbenchPage();
                            String dispName = SchemaDiagramEditor.this.getConnectionDisplayString();
                            page.closeEditor((IEditorPart)SchemaDiagramEditor.this, true);
                            SchemaDiagramEditor editor = (SchemaDiagramEditor)Application.openNewEditor(copiedFile);
                            editor.setConnectionCombo(SQLServerThread.getSQLServer().getConnectionSettingBean().getDisplayStrings(), dispName);
                        }
                    });
                }
            } else {
                PreferenceUtil.saveXML(this.file, this.getSchema());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getCommandStack().markSaveLocation();
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        if (this.getTitle().startsWith("s__")) {
            return false;
        }
        return this.isDirty;
    }

    public CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    public Schema getSchema() {
        return this.schema;
    }

    protected void setInput(IEditorInput input) {
        this.fLogger.warn((Object)("IEditorInput:" + input));
        if (input instanceof FileEditorInput) {
            this.file = ((FileEditorInput)input).getPath().toFile();
            this.setPartName(this.file.getName());
            this.schema = this.file.length() == 0L ? new Schema("hiro") : (Schema)PreferenceUtil.readObjectXML(this.file);
        } else {
            this.schema = new Schema("hiro");
        }
        super.setInput(input);
    }

    public void setDBTables(IDBTable[] tables) {
        try {
            this.schema = new Schema("hiro");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private GridLayout createGridLayout(int num) {
        GridLayout gl = new GridLayout(num, false);
        gl.horizontalSpacing = 0;
        gl.marginBottom = 0;
        gl.marginHeight = 0;
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginTop = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        return gl;
    }

    private Composite createToolBar(Composite parent) {
        Composite toolBar = new Composite(parent, 0);
        GridLayout gl2 = this.createGridLayout(6);
        gl2.marginLeft = 8;
        gl2.horizontalSpacing = 1;
        toolBar.setLayout((Layout)gl2);
        toolBar.setLayoutData((Object)new GridData(768));
        new Label(toolBar, 2048).setText(Messages.SchemaDiagramEditor_Connection);
        this.connectionCombo = new Combo(toolBar, 8);
        GridData gd = new GridData();
        gd.widthHint = 150;
        this.connectionCombo.setLayoutData((Object)gd);
        this.connectionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SchemaDiagramEditor.this.myConnectionPropeteis = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionPropertiesByDisplay(SchemaDiagramEditor.this.connectionCombo.getText());
                SchemaDiagramEditor.this.updateConnectionCommand();
            }
        });
        new Label(toolBar, 2048).setText(Messages.SchemaDiagramEditor_MaxRow);
        this.maxRowSpinner = new Spinner(toolBar, 0);
        this.maxRowSpinner.setMaximum(1000000);
        this.maxRowSpinner.setSelection(1000);
        this.maxRowSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SchemaDiagramEditor.this.maxRow = SchemaDiagramEditor.this.maxRowSpinner.getSelection();
            }
        });
        new Label(toolBar, 2048).setText("        ");
        return toolBar;
    }

    public void createPartControl(Composite parent) {
        GridLayout g = this.createGridLayout(1);
        parent.setLayout((Layout)g);
        Composite c = this.createToolBar(parent);
        GridData gd = new GridData(768);
        gd.heightHint = 23;
        c.setLayoutData((Object)gd);
        super.createPartControl(parent);
        try {
            Field f = GraphicalEditorWithFlyoutPalette.class.getDeclaredField("splitter");
            f.setAccessible(true);
            FlyoutPaletteComposite fp = (FlyoutPaletteComposite)f.get((Object)this);
            fp.setLayoutData((Object)new GridData(1808));
        }
        catch (Exception e) {
            this.fLogger.trace((Object)"", (Throwable)e);
        }
        try {
            ConnectionSettingBean bean = SQLServerThread.getSQLServer().getConnectionSettingBean();
            this.connectionCombo.setItems(bean.getDisplayStrings());
            if (this.connectionCombo.getItemCount() > 0) {
                this.connectionCombo.select(0);
                this.myConnectionPropeteis = bean.getConnectionPropertiesByDisplay(this.connectionCombo.getText());
            }
        }
        catch (Exception e) {
            this.fLogger.trace((Object)"", (Throwable)e);
        }
    }

    public String getConnectionDisplayString() {
        return this.connectionCombo.getText();
    }

    public ConnectionProperties getConnectionPropeteis() {
        return this.myConnectionPropeteis;
    }

    public void setConnectionCombo(String[] displays, String select) {
        this.connectionCombo.setItems(displays);
        if (!StringUtil.isEmpty((Object)select)) {
            this.connectionCombo.setText(select);
        }
        this.myConnectionPropeteis = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionPropertiesByDisplay(select);
        this.updateConnectionCommand();
    }

    private void updateConnectionCommand() {
        IContributionItem[] iContributionItemArray = this.getEditorSite().getActionBars().getToolBarManager().getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionContributionItem ai;
            IAction action;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && (action = (ai = (ActionContributionItem)item).getAction()) instanceof GefCommonAction) {
                ((GefCommonAction)action).update();
            }
            ++n2;
        }
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new SchemaPaletteViewerProvider((EditDomain)this.editDomain);
    }

    public Point getViewerSize() {
        return this.getGraphicalViewer().getControl().getSize();
    }

    protected void configureGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        ScalableRootEditPart rootEditPart = new ScalableRootEditPart();
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        ZoomManager manager = rootEditPart.getZoomManager();
        double[] zoomLevels = new double[]{0.25, 0.5, 0.75, 0.85, 1.0, 1.25, 1.5, 2.0, 3.0, 5.0};
        manager.setZoomLevels(zoomLevels);
        viewer.getControl().addListener(37, new Listener(){

            public void handleEvent(Event event) {
                if (event.stateMask == 262144) {
                    if (event.count > 0) {
                        if (manager.canZoomIn()) {
                            manager.zoomIn();
                        }
                    } else if (manager.canZoomOut()) {
                        manager.zoomOut();
                    }
                }
            }
        });
        ArrayList<String> zoomContributions = new ArrayList<String>();
        zoomContributions.add(ZoomManager.FIT_ALL);
        zoomContributions.add(ZoomManager.FIT_HEIGHT);
        zoomContributions.add(ZoomManager.FIT_WIDTH);
        manager.setZoomLevelContributions(zoomContributions);
        ZoomInAction action = new ZoomInAction(manager);
        this.getActionRegistry().registerAction((IAction)action);
        action = new ZoomOutAction(manager);
        this.getActionRegistry().registerAction((IAction)action);
        viewer.setEditPartFactory((EditPartFactory)new SchemaEditPartFactory());
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.getControl().setBackground(ColorConstants.white);
        GraphicalViewerKeyHandler graphicalViewerKeyHandler = new GraphicalViewerKeyHandler(viewer);
        KeyHandler parentKeyHandler = graphicalViewerKeyHandler.setParent(this.getCommonKeyHandler());
        viewer.setKeyHandler(parentKeyHandler);
        this.getEditDomain().addViewer((EditPartViewer)viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        viewer.setContents((Object)this.schema);
        SchemaContextMenuProvider provider = new SchemaContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("com.realpersist.gef.editor.contextmenu", (MenuManager)provider, (ISelectionProvider)viewer);
        DataEditDropTargetListener listener = new DataEditDropTargetListener((EditPartViewer)viewer);
        viewer.addDropTargetListener((TransferDropTargetListener)listener);
    }

    protected KeyHandler getCommonKeyHandler() {
        KeyHandler sharedKeyHandler = new KeyHandler();
        sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)"delete"));
        return sharedKeyHandler;
    }

    protected void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    protected void createActions() {
        this.addStackAction((StackAction)new UndoAction((IEditorPart)this));
        this.addStackAction((StackAction)new RedoAction((IEditorPart)this));
        this.addEditPartAction((SelectionAction)new DeleteAction((IWorkbenchPart)this));
        this.addEditorAction((WorkbenchPartAction)new SaveAction((IEditorPart)this));
        this.addEditorAction((WorkbenchPartAction)new PrintAction((IWorkbenchPart)this));
        this.addAlignmentAction(new AlignmentAction((IWorkbenchPart)this, 1));
        this.addAlignmentAction(new AlignmentAction((IWorkbenchPart)this, 2));
        this.addAlignmentAction(new AlignmentAction((IWorkbenchPart)this, 4));
        this.addAlignmentAction(new AlignmentAction((IWorkbenchPart)this, 8));
        this.addAlignmentAction(new AlignmentAction((IWorkbenchPart)this, 16));
        this.addAlignmentAction(new AlignmentAction((IWorkbenchPart)this, 32));
    }

    protected void addEditPartAction(SelectionAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editPartActionIDs.add(action.getId());
    }

    protected void addStackAction(StackAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.stackActionIDs.add(action.getId());
    }

    protected void addAlignmentAction(AlignmentAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.editPartActionIDs.add(action.getId());
    }

    public void addEditorAction(WorkbenchPartAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editorActionIDs.add(action.getId());
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    protected void updateActions(List actionIds) {
        System.out.println("updateActions  actionIds=" + actionIds);
        Iterator ids = actionIds.iterator();
        while (ids.hasNext()) {
            IAction action = this.getActionRegistry().getAction(ids.next());
            if (action == null || !(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    protected PropertySheetPage getPropertySheetPage() {
        if (this.undoablePropertySheetPage == null) {
            this.undoablePropertySheetPage = new PropertySheetPage();
            this.undoablePropertySheetPage.setRootEntry(GEFPlugin.createUndoablePropertySheetEntry((CommandStack)this.getCommandStack()));
        }
        return this.undoablePropertySheetPage;
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
        this.updateActions(this.editorActionIDs);
    }

    protected PaletteRoot getPaletteRoot() {
        return new PaletteViewerCreator().createPaletteRoot(this.getConnectionPropeteis());
    }

    public void changed(PropetiesChangeType type, ConnectionSettingBean bean) {
        this.setConnectionCombo(bean.getDisplayStrings(), this.connectionCombo.getText());
    }

    public int getMaxRowNum() {
        return this.maxRow;
    }

    class MyContentOutlinePage
    extends ContentOutlinePage {
        private SashForm sash;
        private ScrollableThumbnail thumbnail;
        private DisposeListener disposeListener;

        protected MyContentOutlinePage() {
            super((EditPartViewer)new TreeViewer());
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            ActionRegistry registry = SchemaDiagramEditor.this.getActionRegistry();
            IActionBars bars = pageSite.getActionBars();
            String id = ActionFactory.UNDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.REDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.DELETE.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            bars.updateActionBars();
        }

        public void createControl(Composite parent) {
            this.sash = new SashForm(parent, 256);
            this.getViewer().createControl((Composite)this.sash);
            this.getViewer().setEditDomain((EditDomain)SchemaDiagramEditor.this.getEditDomain());
            this.getViewer().setEditPartFactory((EditPartFactory)new TreeEditPartFactory());
            this.getViewer().setContents((Object)SchemaDiagramEditor.this.schema);
            SchemaDiagramEditor.this.getSelectionSynchronizer().addViewer(this.getViewer());
            Canvas canvas = new Canvas((Composite)this.sash, 2048);
            LightweightSystem lws = new LightweightSystem(canvas);
            this.thumbnail = new ScrollableThumbnail((Viewport)((ScalableRootEditPart)SchemaDiagramEditor.this.getGraphicalViewer().getRootEditPart()).getFigure());
            this.thumbnail.setSource(((ScalableRootEditPart)SchemaDiagramEditor.this.getGraphicalViewer().getRootEditPart()).getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (MyContentOutlinePage.this.thumbnail != null) {
                        MyContentOutlinePage.this.thumbnail.deactivate();
                        MyContentOutlinePage.this.thumbnail = null;
                    }
                }
            };
            SchemaDiagramEditor.this.getGraphicalViewer().getControl().addDisposeListener(this.disposeListener);
        }

        public Control getControl() {
            return this.sash;
        }

        public void dispose() {
            SchemaDiagramEditor.this.getSelectionSynchronizer().removeViewer(this.getViewer());
            if (SchemaDiagramEditor.this.getGraphicalViewer().getControl() != null && !SchemaDiagramEditor.this.getGraphicalViewer().getControl().isDisposed()) {
                SchemaDiagramEditor.this.getGraphicalViewer().getControl().removeDisposeListener(this.disposeListener);
            }
            super.dispose();
        }
    }
}

