/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.command;

import hiro.yoshioka.gef.model.AbstractConnectionModel;
import hiro.yoshioka.gef.model.Column;
import org.eclipse.gef.commands.Command;

public class ReconnectConnectionCommand
extends Command {
    private AbstractConnectionModel connection;
    private Column newSource = null;
    private Column newTarget = null;
    private Column oldSource = null;
    private Column oldTarget = null;

    public void execute() {
        if (this.newSource != null) {
            this.oldSource = this.connection.getSource();
            this.reconnectSource(this.newSource);
        }
        if (this.newTarget != null) {
            this.oldTarget = this.connection.getTarget();
            this.reconnectTarget(this.newTarget);
        }
    }

    private void reconnectSource(Column source) {
        this.connection.detachSource();
        this.connection.setSource(source);
        this.connection.attachSource();
    }

    private void reconnectTarget(Column target) {
        this.connection.detachTarget();
        this.connection.setTarget(target);
        this.connection.attachTarget();
    }

    public void setConnectionModel(Object model) {
        this.connection = (AbstractConnectionModel)model;
    }

    public void setNewSource(Object model) {
        this.newSource = (Column)model;
    }

    public void setNewTarget(Object model) {
        this.newTarget = (Column)model;
    }

    public void undo() {
        if (this.oldSource != null) {
            this.reconnectSource(this.oldSource);
        }
        if (this.oldTarget != null) {
            this.reconnectTarget(this.oldTarget);
        }
        this.oldSource = null;
        this.oldTarget = null;
    }
}

