/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.action;

import hiro.yoshioka.gef.editor.SchemaDiagramEditor;
import hiro.yoshioka.gef.model.Table;
import hiro.yoshioka.job.ERWriter;
import hiro.yoshioka.job.ExERDWriter;
import hiro.yoshioka.job.ExcelERDiagramDialog;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;

public class GEFERExcelAction
extends Action {
    protected Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    SchemaDiagramEditor fTableSelectionEditor;
    Table[] fTableModels;

    public GEFERExcelAction() {
        super("", 1);
    }

    public void configureAction(String text, String toolTipText, ImageDescriptor image) {
        this.setText(text);
        this.setToolTipText(toolTipText);
        this.setImageDescriptor(image);
    }

    public void run() {
        try {
            ExcelERDiagramDialog dialog = new ExcelERDiagramDialog(Display.getCurrent().getActiveShell());
            if (dialog.open() == 0) {
                List<Table> mc = this.fTableSelectionEditor.getSchema().getTables();
                this.fTableModels = mc.toArray(new Table[mc.size()]);
                IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.xlsFolder);
                IFile file = ResourceMarker.createFile(folder, "ERDiagram.xls");
                File f = ResourceMarker.cnvFile(file);
                if (dialog.useExternal) {
                    ExERDWriter writer = new ExERDWriter(f);
                    writer.doWork(this.fTableModels);
                } else {
                    ERWriter writer = new ERWriter(f);
                    writer.doWork(this.fTableModels);
                }
                if (!Program.launch((String)f.getAbsolutePath())) {
                    Program.launch((String)("/usr/lib/openoffice.org/program/scalc " + f.getAbsolutePath()));
                }
            }
        }
        catch (Throwable e) {
            this.fLogger.error((Object)"", e);
        }
    }

    public void setEditor(SchemaDiagramEditor editor) {
        this.fTableSelectionEditor = editor;
    }
}

