/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.eclipse.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CoreUtil {
    protected static Log fLogger = LogFactory.getLog(CoreUtil.class.getClass());

    public static final IFolder getFolder(IProject iProject, String folderName, boolean force) {
        IFolder folder = iProject.getFolder(folderName);
        if (!folder.isAccessible() && force) {
            try {
                folder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
        return folder;
    }

    public static final IFolder getFolder(IFolder ifolder, String folderName, boolean force) {
        IFolder folder = ifolder.getFolder(folderName);
        if (!folder.isAccessible() && force) {
            try {
                folder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }
        return folder;
    }

    public static File cnvFile(IFolder folder) {
        File storeAsFile = null;
        try {
            IFileStore testLocationStore = EFS.getStore((URI)folder.getLocationURI());
            storeAsFile = testLocationStore.toLocalFile(0, null);
        }
        catch (CoreException coreException) {}
        return storeAsFile;
    }

    public static final File cnvFile(IFile file) {
        File storeAsFile = null;
        try {
            IFileStore testLocationStore = EFS.getStore((URI)file.getLocationURI());
            storeAsFile = testLocationStore.toLocalFile(0, null);
        }
        catch (CoreException coreException) {}
        return storeAsFile;
    }

    public static IFile createRandomFile(IFolder folder, String postfix) {
        return CoreUtil.createRandomFile(folder, postfix, "scrap");
    }

    public static IFile createRandomFile(IFolder folder, String postfix, String prefix) {
        Random random = new Random(System.currentTimeMillis());
        String numbers = String.format("%s_%04d.%s", prefix, random.nextInt(10000), postfix);
        return CoreUtil.createFile(folder, numbers);
    }

    public static final IFile createFile(IFolder folder, String name) {
        IFile file = folder.getFile(name);
        try {
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static final IFile createFile(IFolder folder, String name, boolean retry) {
        IFile file = folder.getFile(name);
        if (!file.exists()) {
            try {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ResourceException e) {
                if (retry) {
                    String newName = name.substring(0, name.lastIndexOf(46));
                    file = folder.getFile(String.valueOf(newName) + "_1." + file.getFileExtension());
                    try {
                        file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        fLogger.error((Object)e);
                    }
                }
            }
            catch (CoreException e) {
                fLogger.error((Object)e);
            }
        }
        return file;
    }
}

