/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.series;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.datafeed.IDataPointDefinition;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.DataPointComponentImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartInsets;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;

public class SeriesLabelSheet
extends AbstractPopupSheet
implements SelectionListener,
Listener {
    protected Composite cmpContent = null;
    private Group grpDataPoint = null;
    protected List lstComponents = null;
    private Combo cmbComponentTypes = null;
    private Button btnAddComponent = null;
    private Button btnRemoveComponent = null;
    private Button btnFormatSpecifier = null;
    private TextEditorComposite txtPrefix = null;
    private TextEditorComposite txtSuffix = null;
    private TextEditorComposite txtSeparator = null;
    private LineAttributesComposite liacOutline = null;
    private AbstractChartInsets icInsets = null;
    protected Label lblPosition;
    protected ChartCombo cmbPosition;
    private Label lblFont;
    private FontDefinitionComposite fdcFont;
    protected Label lblFill;
    protected FillChooserComposite fccBackground;
    protected Label lblShadow;
    protected FillChooserComposite fccShadow;
    private Group grpAttributes;
    private Label lblPrefix;
    private Label lblSuffix;
    private Label lblSeparator;
    private Group grpOutline;
    private ChartWizardContext context;
    protected Map<String, String> mapDataPointNames;
    private ArrayList<Integer> dataPointIndex;
    protected IDataPointDefinition foDataPointDefinition;
    private Series series;
    private Series defSeries = null;

    public SeriesLabelSheet(String title, ChartWizardContext context, Series series) {
        super(title, context, true);
        this.series = series;
        this.defSeries = ChartDefaultValueUtil.getDefaultSeries((Series)this.series);
        this.context = context;
        this.mapDataPointNames = new HashMap<String, String>();
        this.dataPointIndex = new ArrayList();
    }

    protected void bindHelp(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.DataPointLabels_ID");
    }

    public Composite getComponent(Composite parent) {
        boolean bEnableUI = !this.getContext().getUIFactory().isSetInvisible((EObject)this.getSeriesForProcessing().getLabel());
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        this.cmpContent.setLayout((Layout)glContent);
        Composite cmpTop = new Composite(this.cmpContent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        cmpTop.setLayout((Layout)layout);
        cmpTop.setLayoutData((Object)new GridData(1808));
        Composite cmpLeft = new Composite(cmpTop, 0);
        cmpLeft.setLayout((Layout)new GridLayout());
        cmpLeft.setLayoutData((Object)new GridData(1808));
        Composite cmpRight = new Composite(cmpTop, 0);
        cmpRight.setLayout((Layout)new GridLayout());
        cmpRight.setLayoutData((Object)new GridData(1808));
        this.createAttributeArea(cmpLeft, bEnableUI);
        this.createOutline(cmpLeft, bEnableUI);
        this.createDataPointArea(cmpRight);
        this.createInsets(cmpRight, bEnableUI);
        this.populateLists(this.getSeriesForProcessing());
        this.refreshDataPointButtons();
        return this.cmpContent;
    }

    protected void createOutline(Composite cmpLeft, boolean bEnableUI) {
        this.grpOutline = new Group(cmpLeft, 0);
        GridData gdGOutline = new GridData(768);
        this.grpOutline.setLayoutData((Object)gdGOutline);
        this.grpOutline.setText(Messages.getString("LabelAttributesComposite.Lbl.Outline"));
        this.grpOutline.setLayout((Layout)new FillLayout());
        this.grpOutline.setEnabled(bEnableUI);
        int iStyles = 15;
        this.liacOutline = new LineAttributesComposite((Composite)this.grpOutline, 0, iStyles |= this.getContext().getUIFactory().supportAutoUI() ? 16 : iStyles, this.getContext(), this.getSeriesForProcessing().getLabel().getOutline(), this.defSeries.getLabel().getOutline());
        this.liacOutline.addListener(this);
        this.liacOutline.setAttributesEnabled(bEnableUI);
    }

    protected void createInsets(Composite cmpRight, boolean bEnableUI) {
        this.icInsets = this.getContext().getUIFactory().createChartInsetsComposite(cmpRight, 0, 2, this.getSeriesForProcessing().getLabel().getInsets(), this.getChart().getUnits(), this.getContext().getUIServiceProvider(), this.getContext(), this.defSeries.getLabel().getInsets());
        GridData gdICInsets = new GridData(768);
        gdICInsets.grabExcessVerticalSpace = false;
        this.icInsets.setLayoutData((Object)gdICInsets);
        this.icInsets.setEnabled(bEnableUI);
    }

    private void populateLists(Series series) {
        String[] componentsDisplayName = LiteralHelper.dataPointComponentTypeSet.getDisplayNames();
        try {
            this.mapDataPointNames.clear();
            this.foDataPointDefinition = PluginSettings.instance().getDataPointDefinition(this.getSeriesForProcessing().getClass());
            if (this.foDataPointDefinition != null) {
                String[] dpType = this.foDataPointDefinition.getDataPointTypes();
                String[] dpTypeDisplay = new String[dpType.length];
                int i = 0;
                while (i < dpType.length) {
                    dpTypeDisplay[i] = this.foDataPointDefinition.getDisplayText(dpType[i]);
                    this.mapDataPointNames.put(dpType[i], dpTypeDisplay[i]);
                    this.mapDataPointNames.put(dpTypeDisplay[i], dpType[i]);
                    ++i;
                }
                componentsDisplayName = this.concatenateArrays(dpTypeDisplay, componentsDisplayName);
            }
            ChartWizard.removeException((String)"PluginSettings.getDataPointDefinition");
        }
        catch (ChartException e) {
            ChartWizard.showException((String)"PluginSettings.getDataPointDefinition", (String)e.getLocalizedMessage());
        }
        this.cmbComponentTypes.setItems(componentsDisplayName);
        this.cmbComponentTypes.select(0);
        this.lstComponents.setItems(this.getDataPointComponents(series.getDataPoint()));
        String str = series.getDataPoint().getPrefix();
        this.txtPrefix.setText(str == null ? "" : str);
        str = series.getDataPoint().getSuffix();
        this.txtSuffix.setText(str == null ? "" : str);
        str = series.getDataPoint().getSeparator();
        this.txtSeparator.setText(str == null ? "" : str);
        NameSet lpNameSet = this.getSeriesForProcessing().getLabelPositionScope(this.getContext().getModel().getDimension());
        ArrayList<String> posItems = new ArrayList<String>(Arrays.asList(lpNameSet.getDisplayNames()));
        this.cmbPosition.setItems(posItems.toArray(new String[0]));
        this.cmbPosition.setItemData(lpNameSet.getNames());
        Position lpCurrent = this.getSeriesForProcessing().getLabelPosition();
        if (lpCurrent != null) {
            String positionName = ChartUIUtil.getFlippedPosition((Position)lpCurrent, (boolean)this.isFlippedAxes()).getName();
            this.cmbPosition.setSelection(positionName);
        }
        if (this.cmbPosition.getSelectionIndex() < 0) {
            this.cmbPosition.select(0);
            this.cmbPosition.notifyListeners(13, new Event());
        }
    }

    private String[] getDataPointComponents(DataPoint datapoint) {
        EList oArr = datapoint.getComponents();
        ArrayList<String> sArr = new ArrayList<String>(oArr.size());
        int i = 0;
        while (i < oArr.size()) {
            DataPointComponent dpc = (DataPointComponent)oArr.get(i);
            if (dpc.getOrthogonalType().length() == 0) {
                sArr.add(LiteralHelper.dataPointComponentTypeSet.getDisplayNameByName(dpc.getType().getName()));
                this.dataPointIndex.add(i);
            } else if (this.mapDataPointNames.containsKey(dpc.getOrthogonalType())) {
                sArr.add(this.mapDataPointNames.get(dpc.getOrthogonalType()));
                this.dataPointIndex.add(i);
            }
            ++i;
        }
        return sArr.toArray(new String[0]);
    }

    protected void createAttributeArea(Composite parent, boolean bEnableUI) {
        this.grpAttributes = new Group(parent, 0);
        this.grpAttributes.setLayoutData((Object)new GridData(768));
        this.grpAttributes.setLayout((Layout)new GridLayout(2, false));
        this.grpAttributes.setText(Messages.getString("SeriesLabelSheet.Label.Format"));
        this.lblPosition = new Label((Composite)this.grpAttributes, 0);
        GridData gdLBLPosition = new GridData();
        this.lblPosition.setLayoutData((Object)gdLBLPosition);
        this.lblPosition.setText(Messages.getString("LabelAttributesComposite.Lbl.Position"));
        this.cmbPosition = this.getContext().getUIFactory().createChartCombo((Composite)this.grpAttributes, 12, (EObject)this.series, "labelPosition", ChartUIUtil.getFlippedPosition((Position)this.defSeries.getLabelPosition(), (boolean)this.isFlippedAxes()).getName());
        GridData gdCMBPosition = new GridData(1808);
        gdCMBPosition.verticalAlignment = 0x1000000;
        this.cmbPosition.setLayoutData((Object)gdCMBPosition);
        this.cmbPosition.addSelectionListener((SelectionListener)this);
        this.lblFont = new Label((Composite)this.grpAttributes, 0);
        GridData gdLFont = new GridData();
        this.lblFont.setLayoutData((Object)gdLFont);
        this.lblFont.setText(Messages.getString("LabelAttributesComposite.Lbl.Font"));
        this.fdcFont = new FontDefinitionComposite((Composite)this.grpAttributes, 0, this.getContext(), this.getSeriesForProcessing().getLabel().getCaption().getFont(), this.getSeriesForProcessing().getLabel().getCaption().getColor(), false);
        GridData gdFDCFont = new GridData(1808);
        gdFDCFont.widthHint = this.fdcFont.getPreferredSize().x;
        gdFDCFont.grabExcessVerticalSpace = false;
        this.fdcFont.setLayoutData(gdFDCFont);
        this.fdcFont.addListener(this);
        this.lblFill = new Label((Composite)this.grpAttributes, 0);
        GridData gdLFill = new GridData();
        this.lblFill.setLayoutData((Object)gdLFill);
        this.lblFill.setText(Messages.getString("LabelAttributesComposite.Lbl.Background"));
        int iFillOption = 152;
        this.fccBackground = new FillChooserComposite((Composite)this.grpAttributes, 0, iFillOption |= this.getContext().getUIFactory().supportAutoUI() ? 4 : iFillOption, this.getContext(), this.getSeriesForProcessing().getLabel().getBackground());
        GridData gdFCCBackground = new GridData(1808);
        gdFCCBackground.verticalAlignment = 0x1000000;
        this.fccBackground.setLayoutData(gdFCCBackground);
        this.fccBackground.addListener(this);
        this.lblShadow = new Label((Composite)this.grpAttributes, 0);
        GridData gdLBLShadow = new GridData();
        this.lblShadow.setLayoutData((Object)gdLBLShadow);
        this.lblShadow.setText(Messages.getString("LabelAttributesComposite.Lbl.Shadow"));
        this.fccShadow = new FillChooserComposite((Composite)this.grpAttributes, 12, iFillOption, this.getContext(), (Fill)this.getSeriesForProcessing().getLabel().getShadowColor());
        GridData gdFCCShadow = new GridData(1808);
        gdFCCShadow.verticalAlignment = 0x1000000;
        this.fccShadow.setLayoutData(gdFCCShadow);
        this.fccShadow.addListener(this);
        this.grpAttributes.setEnabled(bEnableUI);
        this.lblPosition.setEnabled(bEnableUI);
        this.cmbPosition.setEnabled(bEnableUI);
        this.lblFont.setEnabled(bEnableUI);
        this.fdcFont.setEnabled(bEnableUI);
        this.lblFill.setEnabled(bEnableUI);
        this.fccBackground.setEnabled(bEnableUI);
        this.lblShadow.setEnabled(bEnableUI);
        this.fccShadow.setEnabled(bEnableUI);
    }

    private void createDataPointArea(Composite parent) {
        this.grpDataPoint = new Group(parent, 0);
        GridData gdCMPDataPoint = new GridData(1808);
        this.grpDataPoint.setLayoutData((Object)gdCMPDataPoint);
        GridLayout glCMPDataPoint = new GridLayout();
        glCMPDataPoint.numColumns = 4;
        glCMPDataPoint.horizontalSpacing = 4;
        glCMPDataPoint.marginHeight = 2;
        glCMPDataPoint.marginWidth = 2;
        this.grpDataPoint.setLayout((Layout)glCMPDataPoint);
        this.grpDataPoint.setText(Messages.getString("SeriesLabelSheet.Label.Values"));
        this.lstComponents = new List((Composite)this.grpDataPoint, 2564);
        GridData gdLSTComponents = new GridData(1808);
        gdLSTComponents.horizontalSpan = 4;
        gdLSTComponents.heightHint = 100;
        this.lstComponents.setLayoutData((Object)gdLSTComponents);
        this.lstComponents.addSelectionListener((SelectionListener)this);
        this.btnFormatSpecifier = new Button((Composite)this.grpDataPoint, 8);
        GridData gdBTNFormatSpecifier = new GridData();
        this.btnFormatSpecifier.setLayoutData((Object)gdBTNFormatSpecifier);
        this.btnFormatSpecifier.setToolTipText(Messages.getString("Shared.Tooltip.FormatSpecifier"));
        this.btnFormatSpecifier.setText(Messages.getString("Format.Button.Lbl&"));
        this.btnFormatSpecifier.addSelectionListener((SelectionListener)this);
        this.btnRemoveComponent = new Button((Composite)this.grpDataPoint, 8);
        GridData gdBTNRemoveComponent = new GridData();
        this.btnRemoveComponent.setLayoutData((Object)gdBTNRemoveComponent);
        this.btnRemoveComponent.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Remove"));
        this.btnRemoveComponent.addSelectionListener((SelectionListener)this);
        this.btnAddComponent = new Button((Composite)this.grpDataPoint, 8);
        GridData gdBTNAddComponent = new GridData();
        this.btnAddComponent.setLayoutData((Object)gdBTNAddComponent);
        this.btnAddComponent.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Add"));
        this.btnAddComponent.addSelectionListener((SelectionListener)this);
        this.cmbComponentTypes = new Combo((Composite)this.grpDataPoint, 12);
        GridData gdCMBComponentTypes = new GridData(768);
        gdCMBComponentTypes.grabExcessHorizontalSpace = true;
        this.cmbComponentTypes.setLayoutData((Object)gdCMBComponentTypes);
        this.lblPrefix = new Label((Composite)this.grpDataPoint, 0);
        GridData gdLBLPrefix = new GridData();
        this.lblPrefix.setLayoutData((Object)gdLBLPrefix);
        this.lblPrefix.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Prefix"));
        this.txtPrefix = new TextEditorComposite((Composite)this.grpDataPoint, 2052);
        GridData gdTXTPrefix = new GridData(768);
        gdTXTPrefix.horizontalSpan = 3;
        this.txtPrefix.setLayoutData(gdTXTPrefix);
        this.txtPrefix.addListener(this);
        this.lblSuffix = new Label((Composite)this.grpDataPoint, 0);
        GridData gdLBLSuffix = new GridData();
        this.lblSuffix.setLayoutData((Object)gdLBLSuffix);
        this.lblSuffix.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Suffix"));
        this.txtSuffix = new TextEditorComposite((Composite)this.grpDataPoint, 2052);
        GridData gdTXTSuffix = new GridData(768);
        gdTXTSuffix.horizontalSpan = 3;
        this.txtSuffix.setLayoutData(gdTXTSuffix);
        this.txtSuffix.addListener(this);
        this.lblSeparator = new Label((Composite)this.grpDataPoint, 0);
        GridData gdLBLSeparator = new GridData();
        this.lblSeparator.setLayoutData((Object)gdLBLSeparator);
        this.lblSeparator.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Separator"));
        this.txtSeparator = new TextEditorComposite((Composite)this.grpDataPoint, 2052);
        GridData gdTXTSeparator = new GridData(768);
        gdTXTSeparator.horizontalSpan = 3;
        this.txtSeparator.setLayoutData(gdTXTSeparator);
        this.txtSeparator.addListener(this);
    }

    protected Series getSeriesForProcessing() {
        return this.series;
    }

    protected AxisType getAxisType(int type) {
        if (type == 1) {
            return AxisType.LINEAR_LITERAL;
        }
        if (type == 8) {
            return AxisType.DATE_TIME_LITERAL;
        }
        return AxisType.TEXT_LITERAL;
    }

    protected AxisType getAxisType(DataPointComponentType dpct) {
        if (dpct == DataPointComponentType.BASE_VALUE_LITERAL) {
            ChartWithAxes chart;
            if (this.context.getModel() instanceof ChartWithAxes && (chart = (ChartWithAxes)this.context.getModel()).getPrimaryBaseAxes().length > 0) {
                return chart.getPrimaryBaseAxes()[0].getType();
            }
        } else if (dpct == DataPointComponentType.ORTHOGONAL_VALUE_LITERAL) {
            Axis ax;
            ChartWithAxes chart;
            if (this.context.getModel() instanceof ChartWithAxes && (chart = (ChartWithAxes)this.context.getModel()).getPrimaryBaseAxes().length > 0 && (ax = chart.getPrimaryOrthogonalAxis(chart.getPrimaryBaseAxes()[0])) != null) {
                return ax.getType();
            }
        } else if (dpct == DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL) {
            return AxisType.LOGARITHMIC_LITERAL;
        }
        return null;
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.fdcFont)) {
            this.getSeriesForProcessing().getLabel().getCaption().setFont((FontDefinition)((Object[])event.data)[0]);
            this.getSeriesForProcessing().getLabel().getCaption().setColor((ColorDefinition)((Object[])event.data)[1]);
        } else if (event.widget.equals((Object)this.liacOutline)) {
            boolean isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
            switch (event.type) {
                case 1: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getSeriesForProcessing().getLabel().getOutline(), (String)"style", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 2: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getSeriesForProcessing().getLabel().getOutline(), (String)"thickness", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 3: {
                    this.getSeriesForProcessing().getLabel().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getSeriesForProcessing().getLabel().getOutline(), (String)"visible", (Object)event.data, (boolean)isUnset);
                }
            }
        } else if (event.widget.equals((Object)this.fccBackground)) {
            this.getSeriesForProcessing().getLabel().setBackground((Fill)event.data);
        } else if (event.widget.equals((Object)this.fccShadow)) {
            this.getSeriesForProcessing().getLabel().setShadowColor((ColorDefinition)event.data);
        } else if (event.widget.equals(this.icInsets)) {
            this.getSeriesForProcessing().getLabel().setInsets((Insets)event.data);
        } else if (event.widget.equals((Object)this.txtPrefix)) {
            this.getSeriesForProcessing().getDataPoint().setPrefix(this.txtPrefix.getText());
        } else if (event.widget.equals((Object)this.txtSuffix)) {
            this.getSeriesForProcessing().getDataPoint().setSuffix(this.txtSuffix.getText());
        } else if (event.widget.equals((Object)this.txtSeparator)) {
            this.getSeriesForProcessing().getDataPoint().setSeparator(this.txtSeparator.getText());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cmbPosition)) {
            Series s = this.getSeriesForProcessing();
            String selectedItem = this.cmbPosition.getSelectedItemData();
            if (selectedItem != null) {
                if (this.context.getModel() instanceof ChartWithAxes) {
                    s.setLabelPosition(ChartUIUtil.getFlippedPosition((Position)Position.getByName((String)selectedItem), (boolean)this.isFlippedAxes()));
                } else {
                    s.setLabelPosition(Position.getByName((String)selectedItem));
                }
            }
        } else if (e.getSource().equals(this.btnAddComponent)) {
            this.lstComponents.add(this.cmbComponentTypes.getText());
            this.addDataPointComponent(this.lstComponents.getItemCount() - 1);
            this.refreshDataPointButtons();
        } else if (e.getSource().equals(this.btnRemoveComponent)) {
            if (this.lstComponents.getSelectionCount() == 0) {
                return;
            }
            int iSelected = this.lstComponents.getSelectionIndices()[0];
            if (iSelected != -1) {
                this.removeDataPointComponent(iSelected);
                this.lstComponents.remove(iSelected);
            }
            this.refreshDataPointButtons();
        } else if (e.getSource().equals(this.btnFormatSpecifier)) {
            if (this.lstComponents.getSelectionCount() == 0) {
                return;
            }
            int iSelected = this.lstComponents.getSelectionIndices()[0];
            if (iSelected != -1) {
                this.setDataPointComponentFormatSpecifier(iSelected);
            }
        } else if (e.getSource().equals(this.lstComponents)) {
            this.refreshDataPointButtons();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void refreshDataPointButtons() {
        this.btnRemoveComponent.setEnabled(this.lstComponents.getSelectionIndex() != -1);
        this.btnFormatSpecifier.setEnabled(this.lstComponents.getSelectionIndex() != -1);
    }

    private void addDataPointComponent(int iComponentIndex) {
        DataPoint dp = this.getSeriesForProcessing().getDataPoint();
        DataPointComponent dpc = null;
        String dpDisplayName = this.lstComponents.getItem(iComponentIndex);
        if (this.mapDataPointNames.containsKey(dpDisplayName)) {
            dpc = DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.ORTHOGONAL_VALUE_LITERAL, null);
            dpc.setOrthogonalType(this.mapDataPointNames.get(dpDisplayName));
        } else {
            DataPointComponentType dpct = DataPointComponentType.getByName((String)LiteralHelper.dataPointComponentTypeSet.getNameByDisplayName(this.lstComponents.getItem(iComponentIndex)));
            dpc = DataPointComponentImpl.create((DataPointComponentType)dpct, null);
            if (dpct == DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL) {
                JavaNumberFormatSpecifier fs = JavaNumberFormatSpecifierImpl.create((String)"##.##%");
                dpc.setFormatSpecifier((FormatSpecifier)fs);
            }
        }
        dpc.eAdapters().addAll((Collection)dp.eAdapters());
        dp.getComponents().add((Object)dpc);
        this.dataPointIndex.add(iComponentIndex, dp.getComponents().size() - 1);
    }

    protected void setDataPointComponentFormatSpecifier(int iComponentIndex) {
        int iType;
        AxisType axisType;
        DataPointComponent dpc = (DataPointComponent)this.getSeriesForProcessing().getDataPoint().getComponents().get(this.getIndexOfListItem(iComponentIndex));
        FormatSpecifier formatspecifier = dpc.getFormatSpecifier();
        String sContext = new MessageFormat(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.SeriesDataPointComponent")).format(new Object[]{dpc.getType().getName()});
        if (sContext == null) {
            sContext = Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.SeriesDataPoint");
        }
        if ((axisType = this.getAxisType(dpc.getType())) != null && this.mapDataPointNames != null && this.mapDataPointNames.size() > 0 && (iType = this.foDataPointDefinition.getCompatibleDataType(this.mapDataPointNames.get(this.lstComponents.getItem(iComponentIndex)))) > 0) {
            axisType = this.getAxisType(iType);
        }
        this.getContext().getUIServiceProvider().getFormatSpecifierHandler().handleFormatSpecifier(this.cmpContent.getShell(), sContext, new AxisType[]{axisType}, formatspecifier, (EObject)dpc, "formatSpecifier", this.getContext());
    }

    protected int getIndexOfListItem(int indexOfListItem) {
        return this.dataPointIndex.get(indexOfListItem);
    }

    private void removeDataPointComponent(int iComponentIndex) {
        this.getSeriesForProcessing().getDataPoint().getComponents().remove(this.getIndexOfListItem(iComponentIndex));
        this.dataPointIndex.remove(iComponentIndex);
        if (this.dataPointIndex.size() != 0) {
            int i = iComponentIndex;
            while (i < this.dataPointIndex.size()) {
                this.dataPointIndex.set(i, this.dataPointIndex.get(i) - 1);
                ++i;
            }
        }
    }

    private boolean isFlippedAxes() {
        return this.context.getModel() instanceof ChartWithAxes && ((ChartWithAxes)this.context.getModel()).getOrientation().equals((Object)Orientation.HORIZONTAL_LITERAL);
    }

    private String[] concatenateArrays(String[] array1, String[] array2) {
        if (array1 == null || array2 == null) {
            return null;
        }
        String[] array = new String[array1.length + array2.length];
        int i = 0;
        while (i < array.length) {
            array[i] = i < array1.length ? array1[i] : array2[i - array1.length];
            ++i;
        }
        return array;
    }
}

