/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import com.ibm.icu.text.NumberFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import org.eclipse.birt.chart.model.data.BigNumberDataElement;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.impl.BigNumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataElementComposite;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class NumberDataElementComposite
extends TextEditorComposite
implements IDataElementComposite {
    protected EObject eParent;

    public NumberDataElementComposite(Composite parent, DataElement data) {
        super(parent, 2052, 1);
        GridData gd = new GridData();
        gd.widthHint = 80;
        this.setLayoutData(gd);
        this.setDefaultValue("");
        this.setDataElement(data);
    }

    public DataElement getDataElement() {
        NumberFormat nf = ChartUIUtil.getDefaultNumberFormatInstance();
        try {
            Number number = nf.parse(this.getText());
            if (number instanceof BigInteger) {
                BigInteger biNumber = (BigInteger)number;
                return BigNumberDataElementImpl.create((BigDecimal)new BigDecimal(biNumber).stripTrailingZeros());
            }
            return NumberDataElementImpl.create((double)number.doubleValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void notifyListeners(int eventType, Event event) {
        if (eventType == 0 || eventType == 1) {
            super.notifyListeners(eventType, event);
        }
    }

    public void setDataElement(DataElement data) {
        if (data instanceof BigNumberDataElement) {
            this.setText(((BigNumberDataElement)data).getValue().stripTrailingZeros().toString());
        }
        if (data == null || data instanceof NumberDataElement) {
            this.setText(data == null ? "" : ChartUIUtil.getDefaultNumberFormatInstance().format(((NumberDataElement)data).getValue()));
        }
    }

    public void setEObjectParent(EObject eParent) {
        this.eParent = eParent;
    }
}

