/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BindingGroupDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BindingGroupDescriptor
extends PropertyDescriptor {
    protected Composite container;
    private Button datasetRadio;
    private Button reportItemRadio;
    private CCombo datasetCombo;
    private CCombo reportItemCombo;
    private Button bindingButton;
    private BindingGroupDescriptorProvider.BindingInfo oldInfo;
    private BindingGroupDescriptorProvider provider;

    public BindingGroupDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public Control createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.container.setLayout((Layout)layout);
        this.container.setLayoutData((Object)new GridData(768));
        this.datasetRadio = FormWidgetFactory.getInstance().createButton(this.container, 16, this.isFormStyle());
        this.datasetRadio.setText(this.getProvider().getText(0));
        this.datasetRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingGroupDescriptor.this.refreshBinding();
                if (BindingGroupDescriptor.this.datasetRadio.getSelection() && BindingGroupDescriptor.this.getProvider().isBindingReference() && (DEUtil.getBindingHolder((DesignElementHandle)BindingGroupDescriptor.this.getProvider().getReportItemHandle(), (boolean)true) == null || DEUtil.getBindingHolder((DesignElementHandle)BindingGroupDescriptor.this.getProvider().getReportItemHandle(), (boolean)true).getDataBindingType() != 2)) {
                    BindingGroupDescriptor.this.saveBinding();
                }
            }
        });
        this.datasetCombo = this.isFormStyle() ? FormWidgetFactory.getInstance().createCCombo(this.container, true) : new CCombo(this.container, 8);
        this.datasetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingGroupDescriptor.this.saveBinding();
            }
        });
        GridData gd = new GridData();
        gd.widthHint = 300;
        this.datasetCombo.setLayoutData((Object)gd);
        this.datasetCombo.setVisibleItemCount(30);
        this.bindingButton = FormWidgetFactory.getInstance().createButton(this.container, 8, this.isFormStyle());
        this.bindingButton.setText(this.getProvider().getText(1));
        this.bindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingGroupDescriptor.this.getProvider().bindingDialog();
            }
        });
        this.reportItemRadio = FormWidgetFactory.getInstance().createButton(this.container, 16, this.isFormStyle());
        this.reportItemRadio.setText(this.getProvider().getText(2));
        this.reportItemRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingGroupDescriptor.this.refreshBinding();
                if (BindingGroupDescriptor.this.reportItemRadio.getSelection() && BindingGroupDescriptor.this.getProvider().getReportItemHandle().getDataBindingType() == 1 && (DEUtil.getBindingHolder((DesignElementHandle)BindingGroupDescriptor.this.getProvider().getReportItemHandle(), (boolean)true) == null || DEUtil.getBindingHolder((DesignElementHandle)BindingGroupDescriptor.this.getProvider().getReportItemHandle(), (boolean)true).getDataBindingType() == 2)) {
                    BindingGroupDescriptor.this.saveBinding();
                }
            }
        });
        this.reportItemCombo = this.isFormStyle() ? FormWidgetFactory.getInstance().createCCombo(this.container, true) : new CCombo(this.container, 8);
        this.reportItemCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingGroupDescriptor.this.saveBinding();
            }
        });
        gd = new GridData();
        gd.widthHint = 300;
        this.reportItemCombo.setLayoutData((Object)gd);
        this.reportItemCombo.setVisibleItemCount(30);
        return this.container;
    }

    public Control getControl() {
        return this.container;
    }

    private void saveBinding() {
        BindingGroupDescriptorProvider.BindingInfo info = new BindingGroupDescriptorProvider.BindingInfo();
        if (this.datasetRadio.getSelection()) {
            info.setBindingType(1);
            info.setBindingValue(this.datasetCombo.getText());
        } else {
            info.setBindingType(2);
            info.setBindingValue(this.reportItemCombo.getText());
        }
        try {
            this.oldInfo = info;
            this.save(info);
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    public void load() {
        if (!this.provider.isEnable()) {
            this.datasetRadio.setEnabled(false);
            this.datasetRadio.setSelection(false);
            this.datasetCombo.setEnabled(false);
            this.bindingButton.setEnabled(false);
            this.reportItemRadio.setSelection(false);
            this.reportItemRadio.setEnabled(false);
            this.reportItemCombo.setEnabled(false);
            this.datasetCombo.deselectAll();
            this.reportItemCombo.deselectAll();
            return;
        }
        this.datasetRadio.setEnabled(true);
        this.reportItemRadio.setEnabled(true);
        BindingGroupDescriptorProvider.BindingInfo info = (BindingGroupDescriptorProvider.BindingInfo)this.getDescriptorProvider().load();
        if (info != null) {
            this.refreshBindingInfo(info);
        }
    }

    private void refreshBinding() {
        if (this.datasetRadio.getSelection()) {
            this.datasetRadio.setSelection(true);
            this.datasetCombo.setEnabled(true);
            this.bindingButton.setEnabled(this.getProvider().enableBindingButton());
            this.reportItemRadio.setSelection(false);
            this.reportItemCombo.setEnabled(false);
            if (this.datasetCombo.getSelectionIndex() == -1) {
                this.datasetCombo.setItems(this.getProvider().getAvailableDatasetItems());
                this.datasetCombo.select(0);
            }
        } else {
            this.datasetRadio.setSelection(false);
            this.datasetCombo.setEnabled(false);
            this.bindingButton.setEnabled(false);
            this.reportItemRadio.setSelection(true);
            this.reportItemCombo.setEnabled(true);
            if (this.reportItemCombo.getSelectionIndex() == -1) {
                this.reportItemCombo.setItems(this.getProvider().getReferences());
                this.reportItemCombo.select(0);
            }
        }
    }

    private void refreshBindingInfo(BindingGroupDescriptorProvider.BindingInfo info) {
        int type = info.getBindingType();
        Object value = info.getBindingValue();
        this.datasetCombo.setItems(this.getProvider().getAvailableDatasetItems());
        this.reportItemCombo.setItems(this.getProvider().getReferences());
        if (type == 0 && DEUtil.getBindingHolder((DesignElementHandle)this.getProvider().getReportItemHandle(), (boolean)true) != null && DEUtil.getBindingHolder((DesignElementHandle)this.getProvider().getReportItemHandle(), (boolean)true).getDataBindingType() == 2) {
            type = 2;
        }
        switch (type) {
            case 0: {
                if (this.oldInfo != null) {
                    if (this.oldInfo.getBindingType() == 1) {
                        this.selectDatasetType(value);
                        break;
                    }
                    if (this.oldInfo.getBindingType() != 2) break;
                    this.selectReferenceType(info, value);
                    break;
                }
            }
            case 1: {
                this.selectDatasetType(value);
                break;
            }
            case 2: {
                this.selectReferenceType(info, value);
            }
        }
    }

    private void selectReferenceType(BindingGroupDescriptorProvider.BindingInfo info, Object value) {
        this.datasetRadio.setSelection(false);
        this.datasetCombo.setEnabled(false);
        this.bindingButton.setEnabled(false);
        this.reportItemRadio.setSelection(true);
        this.reportItemCombo.setEnabled(true);
        this.reportItemCombo.setText(value.toString());
        if (info.isReadOnly()) {
            this.datasetRadio.setEnabled(false);
            this.reportItemRadio.setEnabled(false);
            this.reportItemCombo.setEnabled(false);
        }
    }

    private void selectDatasetType(Object value) {
        this.datasetRadio.setSelection(true);
        this.datasetCombo.setEnabled(true);
        this.datasetCombo.setText(value.toString());
        this.bindingButton.setEnabled(this.getProvider().enableBindingButton());
        this.reportItemRadio.setSelection(false);
        this.reportItemCombo.setEnabled(false);
    }

    public void save(Object obj) throws SemanticException {
        this.getProvider().save(obj);
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        this.descriptorProvider = (BindingGroupDescriptorProvider)provider;
        if (provider instanceof BindingGroupDescriptorProvider) {
            this.provider = (BindingGroupDescriptorProvider)provider;
        }
    }

    public BindingGroupDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setInput(Object handle) {
        super.setInput(handle);
    }
}

