/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.TabularCube;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ElementFactoryUtil;
import org.eclipse.birt.report.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementStructureUtil {
    public static boolean updateStructureFromParent(Module childModule, DesignElement child, DesignElement parent) {
        if (child == null || parent == null) {
            return false;
        }
        if (child.getExtendsElement() != parent) {
            return false;
        }
        Map<Long, List<Object>> overriddenValues = ElementStructureUtil.collectPropertyValues(childModule, child);
        boolean retValue = ElementStructureUtil.duplicateStructure(parent, child, childModule);
        ElementStructureUtil.distributeValues(childModule, child, overriddenValues);
        return retValue;
    }

    public static void distributeValues(Module module, DesignElement element, Map<Long, List<Object>> overriddenValues) {
        if (element == null) {
            return;
        }
        ContentIterator contentIterator = new ContentIterator(module, element);
        while (contentIterator.hasNext()) {
            List<Object> values;
            DesignElement content = contentIterator.next();
            Long baseId = content.getBaseId();
            if (overriddenValues == null || overriddenValues.isEmpty() || (values = overriddenValues.get(baseId)) == null || values.isEmpty()) continue;
            int i = 0;
            while (i < values.size()) {
                Property prop = (Property)values.get(i);
                Object value = prop.getValue();
                if ("style".equals(prop.getName())) {
                    ((StyledElement)content).setStyleName((String)prop.getValue());
                } else if (value instanceof ReferenceValue) {
                    Object newValue = ((ReferenceValue)value).copy();
                    content.setProperty(prop.getName(), newValue);
                } else {
                    content.setProperty(prop.getName(), prop.getValue());
                }
                ++i;
            }
        }
    }

    public static Map<Long, List<Object>> collectPropertyValues(Module module, DesignElement element) {
        if (element == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<Object>> map = new HashMap<Long, List<Object>>();
        Module root = element.getRoot();
        ContentIterator contentIterator = new ContentIterator(module, element);
        while (contentIterator.hasNext()) {
            DesignElement content = contentIterator.next();
            Long baseId = content.getBaseId();
            ArrayList<Property> values = (ArrayList<Property>)map.get(baseId);
            if (values == null) {
                values = new ArrayList<Property>();
                map.put(baseId, values);
            }
            List<IElementPropertyDefn> propDefns = null;
            if (content instanceof ExtendedItem) {
                if (!((ExtendedItem)content).hasLocalPropertyValuesOnOwnModel()) {
                    ((ExtendedItem)content).getExtensibilityProvider().clearOwnModel();
                    propDefns = new ArrayList<IElementPropertyDefn>();
                } else {
                    propDefns = ((ExtendedItem)content).getExtDefn().getProperties();
                }
            } else {
                propDefns = content.getPropertyDefns();
            }
            int i = 0;
            while (i < propDefns.size()) {
                String propName;
                Object propValue;
                PropertyDefn propDefn = (PropertyDefn)((Object)propDefns.get(i));
                if (!("name".equalsIgnoreCase(propDefn.getName()) || "extends".equalsIgnoreCase(propDefn.getName()) || propDefn.getTypeCode() == 23 || content instanceof ExtendedItem && "extensionName".equalsIgnoreCase(propDefn.getName()) || (propValue = content.getLocalProperty(root, propName = propDefn.getName())) == null)) {
                    if ("style".equals(propName)) {
                        ReferenceValue refValue = (ReferenceValue)propValue;
                        propValue = refValue.getName();
                    }
                    values.add(new Property(propName, propValue));
                }
                ++i;
            }
        }
        return map;
    }

    public static boolean duplicateStructure(DesignElement source, DesignElement target, Module targetModule) {
        if (source == null || target == null) {
            throw new IllegalArgumentException("Element can not be null.");
        }
        ElementDefn defn = (ElementDefn)source.getDefn();
        if (defn != target.getDefn()) {
            throw new IllegalArgumentException("Two element are not the same type.");
        }
        if (!defn.isContainer()) {
            return true;
        }
        int i = 0;
        while (i < defn.getSlotCount()) {
            ElementStructureUtil.duplicateStructure(new ContainerContext(source, i), new ContainerContext(target, i), targetModule);
            ++i;
        }
        List<IElementPropertyDefn> properties = defn.getContents();
        int i2 = 0;
        while (i2 < properties.size()) {
            IElementPropertyDefn propDefn = properties.get(i2);
            ElementStructureUtil.duplicateStructure(new ContainerContext(source, propDefn.getName()), new ContainerContext(target, propDefn.getName()), targetModule);
            ++i2;
        }
        if (target instanceof TabularCube) {
            TabularCube targetCube = (TabularCube)target;
            Cube sourceCube = (Cube)source;
            Module sourceRoot = sourceCube.getRoot();
            DesignElement group = source.getReferenceProperty(sourceRoot, "defaultMeasureGroup");
            if (group != null) {
                int index = group.getIndex(sourceCube.getRoot());
                assert (index > -1);
                targetCube.setDefaultMeasureGroup(index);
            }
        } else if (target instanceof Dimension) {
            Dimension targetDimension = (Dimension)target;
            Dimension sourceDimension = (Dimension)source;
            ModelUtil.duplicateDefaultHierarchy(targetDimension, sourceDimension);
        }
        return true;
    }

    public static boolean duplicateDimensionStructure(DesignElement source, DesignElement target, Module targetModule) {
        boolean retValue = ElementStructureUtil.duplicateStructure(source, target, targetModule);
        ElementStructureUtil.duplicateProperties(source, target);
        ContentIterator iter1 = new ContentIterator(source.getRoot(), source);
        ContentIterator iter2 = new ContentIterator(targetModule, target);
        while (iter1.hasNext()) {
            DesignElement virtualParent = iter1.next();
            DesignElement virtualChild = iter2.next();
            ElementStructureUtil.duplicateProperties(virtualParent, virtualChild);
        }
        return retValue;
    }

    public static void duplicateStructure(ContainerContext sourceInfor, ContainerContext targetInfor, Module targetModule) {
        targetInfor.clearContents();
        int j = 0;
        while (j < sourceInfor.getContentCount(null)) {
            DesignElement sourceContent = sourceInfor.getContent(null, j);
            DesignElement targetContent = null;
            if (sourceContent instanceof ExtendedItem) {
                ExtendedItem extendedItem = (ExtendedItem)sourceContent;
                targetContent = new ExtendedItem(sourceContent.getName());
                targetContent.setProperty("extensionName", extendedItem.getProperty(extendedItem.getRoot(), "extensionName"));
            } else if (!(sourceContent instanceof OdaDataSet) && !(sourceContent instanceof OdaDataSource)) {
                targetContent = ElementFactoryUtil.newElement(sourceContent.getElementName(), sourceContent.getName());
            }
            if (targetContent != null) {
                targetContent.setID(sourceContent.getID());
                targetContent.setBaseId(sourceContent.getID());
                targetInfor.add(targetModule, targetContent);
                ElementStructureUtil.duplicateStructure(sourceContent, targetContent, targetModule);
                if (targetContent instanceof TableItem) {
                    ((TableItem)targetContent).refreshRenderModel(targetModule);
                }
            }
            ++j;
        }
    }

    public static void clearStructure(DesignElement element) {
        if (element == null) {
            return;
        }
        ElementDefn defn = (ElementDefn)element.getDefn();
        if (!defn.isContainer()) {
            return;
        }
        int i = 0;
        while (i < defn.getSlotCount()) {
            new ContainerContext(element, i).clearContents();
            ++i;
        }
        List<IElementPropertyDefn> properties = defn.getContents();
        int i2 = 0;
        while (i2 < properties.size()) {
            IElementPropertyDefn propDefn = properties.get(i2);
            new ContainerContext(element, propDefn.getName()).clearContents();
            ++i2;
        }
    }

    public static void addTheVirualElementsToNamesapce(DesignElement element, Module module) {
        ContentIterator contentIter = new ContentIterator(module, element);
        while (contentIter.hasNext()) {
            DesignElement virtualElement = (DesignElement)contentIter.next();
            if (virtualElement.getName() == null) continue;
            module.makeUniqueName(virtualElement);
            NameSpace ns = new NameExecutor(virtualElement).getNameSpace(module);
            if (ns == null) continue;
            ns.insert(virtualElement);
        }
    }

    public static boolean refreshStructureFromParent(Module module, DesignElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Parent element can not be null.");
        }
        DesignElement parent = element.getExtendsElement();
        if (parent == null) {
            return false;
        }
        boolean result = ElementStructureUtil.updateStructureFromParent(module, element, parent);
        if (element instanceof TableItem) {
            ((TableItem)element).refreshRenderModel(module);
        }
        return result;
    }

    public static Map<Long, DesignElement> getIdMap(Module module, DesignElement element) {
        assert (element != null);
        DesignElement parent = element.getExtendsElement();
        if (parent == null) {
            return Collections.emptyMap();
        }
        return ElementStructureUtil.getIdMap(module, element, parent);
    }

    public static Map<Long, DesignElement> getIdMap(Module module, DesignElement element, DesignElement parent) {
        HashMap<Long, DesignElement> idMap = new HashMap<Long, DesignElement>();
        ContentIterator parentIter = new ContentIterator(module, parent);
        ContentIterator childIter = new ContentIterator(module, element);
        while (childIter.hasNext()) {
            DesignElement virtualParent = (DesignElement)parentIter.next();
            DesignElement virtualChild = (DesignElement)childIter.next();
            assert (virtualParent.getID() > 0L);
            idMap.put(virtualParent.getID(), virtualChild);
        }
        return idMap;
    }

    public static void localizeElement(Module module, DesignElement element) {
        assert (element != null);
        DesignElement parent = element.getExtendsElement();
        if (parent == null) {
            return;
        }
        ElementStructureUtil.duplicateProperties(parent, element);
        ContentIterator iter1 = new ContentIterator(module, parent);
        ContentIterator iter2 = new ContentIterator(module, element);
        while (iter1.hasNext()) {
            DesignElement virtualParent = iter1.next();
            DesignElement virtualChild = iter2.next();
            ElementStructureUtil.duplicateProperties(virtualParent, virtualChild);
        }
    }

    private static void duplicateProperties(DesignElement from, DesignElement to) {
        if (from.getDefn().allowsUserProperties()) {
            for (UserPropertyDefn userPropertyDefn : from.getUserProperties()) {
                to.addUserPropertyDefn(userPropertyDefn);
            }
        }
        for (ElementPropertyDefn elementPropertyDefn : from.getDefn().getProperties()) {
            String propName = elementPropertyDefn.getName();
            if ("style".equals(propName) || "extends".equals(propName) || "userProperties".equals(propName) || "refTemplateParameter".equals(propName)) continue;
            Object localValue = to.getLocalProperty(from.getRoot(), elementPropertyDefn);
            Object parentValue = from.getStrategy().getPropertyFromElement(from.getRoot(), from, elementPropertyDefn);
            if (localValue != null || parentValue == null) continue;
            Object valueToSet = ModelUtil.copyValue(elementPropertyDefn, parentValue);
            to.setProperty(elementPropertyDefn, valueToSet);
        }
    }

    private static class Property {
        private String name;
        private Object value;

        Property(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        Object getValue() {
            return this.value;
        }
    }
}

