/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.DialogField;
import org.eclipse.birt.report.designer.ui.preferences.IDialogFieldListener;
import org.eclipse.birt.report.designer.ui.preferences.IReportPreferenceFactory;
import org.eclipse.birt.report.designer.ui.preferences.IStatusChangeListener;
import org.eclipse.birt.report.designer.ui.preferences.ProjectSelectionDialog;
import org.eclipse.birt.report.designer.ui.preferences.SelectionButtonDialogField;
import org.eclipse.birt.report.designer.ui.preferences.StatusInfo;
import org.eclipse.birt.report.designer.ui.preferences.StatusUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class PropertyAndPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private Control fConfigurationBlockControl;
    private ControlEnableState fBlockEnableState;
    private Link fChangeWorkspaceSettings;
    private SelectionButtonDialogField fUseProjectSettings;
    private IStatus fBlockStatus;
    private Composite fParentComposite;
    private IProject fProject;
    private Map fData;
    public static final String DATA_NO_LINK = "PropertyAndPreferencePage.nolink";

    public PropertyAndPreferencePage() {
        this.fBlockStatus = new StatusInfo();
        this.fBlockEnableState = null;
        this.fProject = null;
        this.fData = null;
    }

    public PropertyAndPreferencePage(String title) {
        super(title);
    }

    public PropertyAndPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected abstract Control createPreferenceContent(Composite var1);

    protected abstract boolean hasProjectSpecificOptions(IProject var1);

    protected abstract String getPreferencePageID();

    protected abstract String getPropertyPageID();

    protected boolean supportsProjectSpecificOptions() {
        return this.getPropertyPageID() != null;
    }

    protected boolean offerLink() {
        return this.fData == null || !Boolean.TRUE.equals(this.fData.get(DATA_NO_LINK));
    }

    protected Label createDescriptionLabel(Composite parent) {
        this.fParentComposite = parent;
        if (this.enableSetProjectSettings()) {
            if (this.isProjectPreferencePage()) {
                Composite composite = new Composite(parent, 0);
                composite.setFont(parent.getFont());
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.numColumns = 2;
                composite.setLayout((Layout)layout);
                composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                IDialogFieldListener listener = new IDialogFieldListener(){

                    public void dialogFieldChanged(DialogField field) {
                        if (field instanceof SelectionButtonDialogField) {
                            PropertyAndPreferencePage.this.enableProjectSpecificSettings(((SelectionButtonDialogField)field).isSelected());
                        }
                    }
                };
                this.fUseProjectSettings = new SelectionButtonDialogField(32);
                this.fUseProjectSettings.setDialogFieldListener(listener);
                this.fUseProjectSettings.setLabelText(Messages.getString((String)"PropertyAndPreferencePage.Text.Enable.SpecialSettings"));
                this.fUseProjectSettings.doFillIntoGrid(composite, 1);
                WidgetUtil.setHorizontalGrabbing((Control)this.fUseProjectSettings.getSelectionButton(null));
                if (this.offerLink()) {
                    this.fChangeWorkspaceSettings = this.createLink(composite, Messages.getString((String)"PropertyAndPreferencePage.Text.Configure.Workspace.Settings"));
                    this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                } else {
                    WidgetUtil.setHorizontalSpan((Control)this.fUseProjectSettings.getSelectionButton(null), 2);
                }
                Label horizontalLine = new Label(composite, 258);
                horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                horizontalLine.setFont(composite.getFont());
            } else if (this.supportsProjectSpecificOptions() && this.offerLink()) {
                this.fChangeWorkspaceSettings = this.createLink(parent, Messages.getString((String)"PropertyAndPreferencePage.Text.Configure.Special.Settings"));
                this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
            }
        }
        return super.createDescriptionLabel(parent);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData data = new GridData(4, 4, true, true);
        this.fConfigurationBlockControl = this.createPreferenceContent(composite);
        this.fConfigurationBlockControl.setLayoutData((Object)data);
        if (this.isProjectPreferencePage()) {
            boolean useProjectSettings = this.hasProjectSpecificOptions(this.getProject());
            this.enableProjectSpecificSettings(useProjectSettings);
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertyAndPreferencePage.this.doLinkActivated((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertyAndPreferencePage.this.doLinkActivated((Link)e.widget);
            }
        });
        return link;
    }

    protected boolean useProjectSettings() {
        return this.isProjectPreferencePage() && this.fUseProjectSettings != null && this.fUseProjectSettings.isSelected();
    }

    protected boolean isProjectPreferencePage() {
        return this.fProject != null;
    }

    protected IProject getProject() {
        return this.fProject;
    }

    final void doLinkActivated(Link link) {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put(DATA_NO_LINK, Boolean.TRUE);
        if (this.isProjectPreferencePage()) {
            this.openWorkspacePreferences(data);
        } else {
            HashSet<IProject> projectsWithSpecifics = new HashSet<IProject>();
            IProject[] projects = ReportPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                if (this.hasProjectSpecificOptions(projects[i])) {
                    projectsWithSpecifics.add(projects[i]);
                }
                ++i;
            }
            ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getShell(), projectsWithSpecifics);
            if (dialog.open() == 0) {
                IProject res = (IProject)dialog.getFirstResult();
                this.openProjectProperties(res, data);
            }
        }
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = this.getPreferencePageID();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    protected final void openProjectProperties(IProject project, Object data) {
        String id = this.getPropertyPageID();
        if (id != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)id, (String[])new String[]{id}, (Object)data).open();
        }
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        if (this.fUseProjectSettings != null) {
            this.fUseProjectSettings.setSelection(useProjectSpecificSettings);
            this.enablePreferenceContent(useProjectSpecificSettings);
            this.updateLinkVisibility();
            this.doStatusChanged();
        }
    }

    private void updateLinkVisibility() {
        if (this.fChangeWorkspaceSettings == null || this.fChangeWorkspaceSettings.isDisposed()) {
            return;
        }
        if (this.isProjectPreferencePage()) {
            this.fChangeWorkspaceSettings.setEnabled(!this.useProjectSettings());
        }
    }

    protected void setPreferenceContentStatus(IStatus status) {
        this.fBlockStatus = status;
        this.doStatusChanged();
    }

    protected IStatusChangeListener getNewStatusChangedListener() {
        return new IStatusChangeListener(){

            public void statusChanged(IStatus status) {
                PropertyAndPreferencePage.this.setPreferenceContentStatus(status);
            }
        };
    }

    protected IStatus getPreferenceContentStatus() {
        return this.fBlockStatus;
    }

    protected void doStatusChanged() {
        if (!this.isProjectPreferencePage() || this.useProjectSettings()) {
            this.updateStatus(this.fBlockStatus);
        } else {
            this.updateStatus(new StatusInfo());
        }
    }

    protected void enablePreferenceContent(boolean enable) {
        if (enable) {
            if (this.fBlockEnableState != null) {
                this.fBlockEnableState.restore();
                this.fBlockEnableState = null;
            }
        } else if (this.fBlockEnableState == null) {
            this.fBlockEnableState = ControlEnableState.disable((Control)this.fConfigurationBlockControl);
        }
    }

    protected void performDefaults() {
        if (this.useProjectSettings()) {
            this.enableProjectSpecificSettings(false);
        }
        super.performDefaults();
    }

    private void updateStatus(IStatus status) {
        this.setValid(status == null ? true : !status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return this.fProject;
    }

    public void setElement(IAdaptable element) {
        this.fProject = (IProject)element.getAdapter(IResource.class);
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            this.fData = (Map)data;
        }
        if (this.fChangeWorkspaceSettings != null && !this.offerLink()) {
            this.fChangeWorkspaceSettings.dispose();
            this.fParentComposite.layout(true, true);
        }
    }

    protected Map getData() {
        return this.fData;
    }

    protected boolean enableSetProjectSettings() {
        return (IReportPreferenceFactory)ElementAdapterManager.getAdapter((Object)ReportPlugin.getDefault(), IReportPreferenceFactory.class) != null;
    }
}

