/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.designer.core.commands.CreateCommand;
import org.eclipse.birt.report.designer.core.model.LibRootModel;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class InsertCubeInLayoutAction
extends AbstractViewAction {
    public static final String DISPLAY_TEXT = Messages.getString("InsertCubeInLayoutAction.action.text");
    private EditPart targetPart;

    public InsertCubeInLayoutAction(Object selectedObject, String text) {
        super(selectedObject, text);
    }

    public InsertCubeInLayoutAction(Object selectedObject) {
        super(selectedObject, DISPLAY_TEXT);
    }

    public boolean isEnabled() {
        Object obj = this.getSelection();
        if (obj instanceof Object[] ? ((Object[])obj).length == 0 || ((Object[])obj).length > 1 : obj instanceof IStructuredSelection && (((IStructuredSelection)obj).size() == 0 || ((IStructuredSelection)obj).size() > 1)) {
            return false;
        }
        return this.canDrop(this.getFirstSelectedObj(), this.getTargetEditPart());
    }

    protected Object getFirstSelectedObj() {
        Object obj = this.getSelection();
        if (obj instanceof Object[]) {
            obj = ((Object[])obj)[0];
        } else if (obj instanceof IStructuredSelection) {
            obj = ((IStructuredSelection)obj).getFirstElement();
        }
        return obj;
    }

    protected EditPart getTargetEditPart() {
        if (this.targetPart == null) {
            EditPartViewer viewer = UIUtil.getLayoutEditPartViewer();
            if (viewer == null) {
                return null;
            }
            IStructuredSelection targets = (IStructuredSelection)viewer.getSelection();
            if (targets.isEmpty() && targets.size() > 1) {
                return null;
            }
            this.targetPart = (EditPart)targets.getFirstElement();
        }
        return this.targetPart;
    }

    public boolean canDrop(Object transfer, Object target) {
        DesignElementHandle targetHandle;
        Object model;
        IStructuredSelection models;
        SlotHandle targetSlot;
        return target != null && transfer instanceof CubeHandle && ((targetSlot = this.getTargetSlotHandle(target, "Crosstab")) != null ? DNDUtil.handleValidateTargetCanContainType((Object)targetSlot, (String)"Crosstab") && DNDUtil.handleValidateTargetCanContainMore((Object)targetSlot, (int)0) : !(models = InsertInLayoutUtil.editPart2Model((ISelection)new StructuredSelection(target))).isEmpty() && (model = DNDUtil.unwrapToModel((Object)models.getFirstElement())) instanceof DesignElementHandle && (targetHandle = (DesignElementHandle)model).canContain(DEUtil.getDefaultContentName((Object)targetHandle), "Crosstab"));
    }

    private SlotHandle getTargetSlotHandle(Object target, String insertType) {
        IStructuredSelection models = InsertInLayoutUtil.editPart2Model((ISelection)new StructuredSelection(target));
        if (models.isEmpty()) {
            return null;
        }
        Object model = DNDUtil.unwrapToModel((Object)models.getFirstElement());
        if (model instanceof LibRootModel) {
            model = ((LibRootModel)model).getModel();
        }
        if (model instanceof SlotHandle) {
            return (SlotHandle)model;
        }
        if (model instanceof DesignElementHandle) {
            int slotId;
            DesignElementHandle handle = (DesignElementHandle)model;
            if (handle.getDefn().isContainer() && handle.canContain(slotId = DEUtil.getDefaultSlotID((Object)handle), insertType)) {
                return handle.getSlot(slotId);
            }
            return handle.getContainerSlotHandle();
        }
        return null;
    }

    public void run() {
        CubeHandle transfer = (CubeHandle)this.getFirstSelectedObj();
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(Messages.getString("InsertCubeInLayoutAction.action.message"));
        CubeHandle cube = transfer;
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (cube.getModuleHandle() != moduleHandle && cube.getRoot() instanceof LibraryHandle) {
            try {
                UIUtil.includeLibrary((ModuleHandle)moduleHandle, (LibraryHandle)((LibraryHandle)cube.getRoot()));
                cube = (CubeHandle)moduleHandle.getElementFactory().newElementFrom((DesignElementHandle)cube, cube.getName());
                moduleHandle.getCubes().add((DesignElementHandle)cube);
            }
            catch (Exception exception) {
                stack.rollback();
                return;
            }
        }
        ExtendedItemHandle handle = null;
        String name = ReportPlugin.getDefault().getCustomName("Crosstab");
        try {
            handle = CrosstabExtendedItemFactory.createCrosstabReportItem((ModuleHandle)SessionHandleAdapter.getInstance().getReportDesignHandle(), null, (String)name);
        }
        catch (Exception exception) {
            stack.rollback();
            return;
        }
        if (this.targetPart instanceof EditPart) {
            EditPartViewer viewer = this.targetPart.getViewer();
            EditPart editPart = this.targetPart;
            if (editPart != null) {
                try {
                    HashMap<String, ExtendedItemHandle> map = new HashMap<String, ExtendedItemHandle>();
                    map.put("newObject", handle);
                    CreateCommand command = new CreateCommand(map);
                    Object parentModel = DNDUtil.unwrapToModel((Object)this.targetPart.getModel());
                    if (parentModel instanceof DesignElementHandle) {
                        DesignElementHandle parentHandle = (DesignElementHandle)parentModel;
                        if (parentHandle.getDefn().isContainer() && (parentHandle.canContain(DEUtil.getDefaultSlotID((Object)parentHandle), (DesignElementHandle)handle) || parentHandle.canContain(DEUtil.getDefaultContentName((Object)parentHandle), (DesignElementHandle)handle))) {
                            command.setParent((Object)parentHandle);
                        } else {
                            if (parentHandle.getContainerSlotHandle() != null) {
                                command.setAfter((Object)parentHandle.getContainerSlotHandle().get(parentHandle.getIndex() + 1));
                            } else if (parentHandle.getContainerPropertyHandle() != null) {
                                command.setAfter(parentHandle.getContainerPropertyHandle().get(parentHandle.getIndex() + 1));
                            }
                            DesignElementHandle container = parentHandle.getContainer();
                            if (container instanceof ListHandle) {
                                command.setParent((Object)parentHandle.getContainerSlotHandle());
                            } else {
                                command.setParent((Object)container);
                            }
                        }
                    } else if (parentModel instanceof SlotHandle) {
                        command.setParent(parentModel);
                    } else {
                        command.setParent((Object)SessionHandleAdapter.getInstance().getReportDesignHandle());
                    }
                    if (command != null && command.canExecute()) {
                        viewer.getEditDomain().getCommandStack().execute((Command)command);
                        handle.setProperty("cube", (Object)cube);
                        List dimensions = cube.getContents("dimensions");
                        for (DimensionHandle dimension : dimensions) {
                            if (dimension.isTimeType()) {
                                this.createDimensionViewHandle(handle, dimension, 1);
                                continue;
                            }
                            this.createDimensionViewHandle(handle, dimension, 0);
                        }
                        List measureGroups = cube.getContents("measureGroups");
                        int index = 0;
                        for (MeasureGroupHandle measureGroup : measureGroups) {
                            List measures = measureGroup.getContents("measures");
                            int j = 0;
                            while (j < measures.size()) {
                                Object temp = measures.get(j);
                                if (temp instanceof MeasureHandle) {
                                    this.addMeasureHandle(handle, (MeasureHandle)temp, index++);
                                }
                                ++j;
                            }
                        }
                        stack.commit();
                        ReportRequest request = new ReportRequest();
                        ArrayList<ExtendedItemHandle> selectionObjects = new ArrayList<ExtendedItemHandle>();
                        selectionObjects.add(handle);
                        request.setSelectionObject(selectionObjects);
                        request.setType((Object)"selection");
                        SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
                        if (SessionHandleAdapter.getInstance().getReportDesignHandle() instanceof LibraryHandle) {
                            HandleAdapterFactory.getInstance().getLibraryHandleAdapter().setCurrentEditorModel((Object)handle, "create element");
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    stack.rollback();
                    return;
                }
            }
        }
    }

    private void addMeasureHandle(ExtendedItemHandle handle, MeasureHandle measureHandle, int index) throws SemanticException {
        IReportItem reportItem = handle.getReportItem();
        CrosstabReportItemHandle xtabHandle = (CrosstabReportItemHandle)reportItem;
        CrosstabAdaptUtil.addMeasureHandle(xtabHandle, measureHandle, index);
    }

    private void createDimensionViewHandle(ExtendedItemHandle handle, DimensionHandle dimensionHandle, int type) throws SemanticException {
        if (dimensionHandle.getDefaultHierarchy().getLevelCount() > 0) {
            IReportItem reportItem = handle.getReportItem();
            CrosstabReportItemHandle xtabHandle = (CrosstabReportItemHandle)reportItem;
            DimensionViewHandle viewHandle = xtabHandle.insertDimension(dimensionHandle, type, xtabHandle.getDimensionCount(type));
            LevelHandle[] levels = this.getLevelHandles(dimensionHandle);
            int j = 0;
            while (j < levels.length) {
                LevelHandle levelHandle = levels[j];
                DataItemHandle dataHandle = CrosstabAdaptUtil.createColumnBindingAndDataItem((ReportItemHandle)((ExtendedItemHandle)xtabHandle.getModelHandle()), levelHandle);
                LevelViewHandle levelViewHandle = viewHandle.insertLevel(levelHandle, j);
                CrosstabCellHandle cellHandle = levelViewHandle.getCell();
                cellHandle.addContent((DesignElementHandle)dataHandle);
                ActionHandle actionHandle = levelHandle.getActionHandle();
                if (actionHandle != null) {
                    ArrayList<IStructure> source = new ArrayList<IStructure>();
                    source.add(actionHandle.getStructure());
                    ArrayList newAction = ModelUtil.cloneStructList(source);
                    dataHandle.setAction((Action)newAction.get(0));
                }
                ++j;
            }
        }
    }

    private LevelHandle[] getLevelHandles(DimensionHandle dimensionHandle) {
        LevelHandle[] dimensionLevelHandles = new LevelHandle[dimensionHandle.getDefaultHierarchy().getLevelCount()];
        int i = 0;
        while (i < dimensionLevelHandles.length) {
            dimensionLevelHandles[i] = dimensionHandle.getDefaultHierarchy().getLevel(i);
            ++i;
        }
        return dimensionLevelHandles;
    }
}

