/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.model;

import java.util.List;
import org.eclipse.birt.report.designer.util.IVirtualValidator;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.BaseCrosstabAdapter;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;

public abstract class CrosstabCellAdapter
extends BaseCrosstabAdapter
implements IVirtualValidator {
    int rowNumber;
    int columnNumber;
    int rowSpan = 1;
    int columnSpan = 1;
    private String positionType = "";

    public CrosstabCellAdapter(CrosstabCellHandle handle) {
        super((AbstractCrosstabItemHandle)handle);
    }

    public List getModelList() {
        return this.getCrosstabCellHandle().getContents();
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public int getColumnSpan() {
        return this.columnSpan;
    }

    public void setColumnSpan(int columnSpan) {
        this.columnSpan = columnSpan;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public CrosstabCellHandle getCrosstabCellHandle() {
        return (CrosstabCellHandle)this.getCrosstabItemHandle();
    }

    public String toString() {
        return "rownumber == " + this.getRowNumber() + " rowspan == " + this.getRowSpan() + " columnnumber=" + this.getColumnNumber() + " columnspan ==" + this.getColumnSpan();
    }

    public String getPositionType() {
        return this.positionType;
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType;
    }

    public BaseCrosstabAdapter copyToTarget(BaseCrosstabAdapter crossAdapt) {
        if (crossAdapt instanceof CrosstabCellAdapter) {
            CrosstabCellAdapter copy = (CrosstabCellAdapter)crossAdapt;
            copy.setColumnNumber(this.getColumnNumber());
            copy.setRowNumber(this.getRowNumber());
            copy.setColumnSpan(this.getColumnSpan());
            copy.setRowSpan(this.getRowSpan());
            copy.setPositionType(this.getPositionType());
        }
        return super.copyToTarget(crossAdapt);
    }

    public DataItemHandle getFirstDataItem() {
        List list = this.getCrosstabCellHandle().getContents();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof DataItemHandle) {
                return (DataItemHandle)list.get(i);
            }
            ++i;
        }
        return null;
    }

    public Object getFirstElement() {
        List list = this.getCrosstabCellHandle().getContents();
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public PropertyHandle getPropertyHandle() {
        if (this.getCrosstabCellHandle() != null) {
            DesignElementHandle handle = this.getCrosstabCellHandle().getModelHandle();
            return handle.getPropertyHandle(this.getDefaultContentName(handle));
        }
        return null;
    }

    public String getDefaultContentName(DesignElementHandle parent) {
        List propDefns = parent.getDefn().getContents();
        if (!propDefns.isEmpty()) {
            return ((IPropertyDefn)propDefns.get(0)).getName();
        }
        return "";
    }

    public boolean handleValidate(Object obj) {
        if (obj instanceof Object[]) {
            Object[] objects = (Object[])obj;
            int len = objects.length;
            if (len == 0) {
                return false;
            }
            if (len == 1) {
                return this.handleValidate(objects[0]);
            }
            if (this.isAllParameter(objects)) {
                return true;
            }
        }
        return obj instanceof ScalarParameterHandle || obj instanceof VariableElementHandle;
    }

    private boolean isAllParameter(Object[] objs) {
        int i = 0;
        while (i < objs.length) {
            if (!(objs[i] instanceof ScalarParameterHandle)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

