/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Direction;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Stretch;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartInsets;
import org.eclipse.birt.chart.ui.swt.AbstractChartNumberEditor;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.ChartSpinner;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextNumberEditorAssistField;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

public class LegendLayoutSheet
extends AbstractPopupSheet
implements Listener,
ModifyListener,
SelectionListener {
    protected ChartCombo cmbAnchor;
    private ChartCombo cmbStretch;
    protected LineAttributesComposite outlineLegend;
    private AbstractChartInsets icLegend;
    protected ChartCombo cmbOrientation;
    protected ChartCombo cmbPosition;
    protected FillChooserComposite fccBackground;
    private ChartCombo cmbDirection;
    protected AbstractChartNumberEditor txtWrapping;
    private ChartSpinner spnMaxPercent;
    private ChartSpinner spnTitlePercent;

    public LegendLayoutSheet(String title, ChartWizardContext context) {
        super(title, context, false);
    }

    protected void bindHelp(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.LegendLayout_ID");
    }

    protected Composite getComponent(Composite parent) {
        Composite cmpContent = new Composite(parent, 0);
        cmpContent.setLayout((Layout)new GridLayout());
        Group grpLegendArea = new Group(cmpContent, 0);
        grpLegendArea.setLayout((Layout)new GridLayout(2, false));
        grpLegendArea.setLayoutData((Object)new GridData(768));
        grpLegendArea.setText(Messages.getString("MoreOptionsChartLegendSheet.Label.LegendArea"));
        Composite cmpLegLeft = new Composite((Composite)grpLegendArea, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginRight = 4;
        gl.horizontalSpacing = 8;
        cmpLegLeft.setLayout((Layout)gl);
        cmpLegLeft.setLayoutData((Object)new GridData(770));
        this.getComponentLegendLeftArea(cmpLegLeft);
        Composite cmpLegRight = new Composite((Composite)grpLegendArea, 0);
        GridLayout gl2 = new GridLayout();
        gl2.marginHeight = 0;
        gl2.marginWidth = 0;
        gl2.verticalSpacing = 10;
        cmpLegRight.setLayout((Layout)gl2);
        GridData gd = new GridData(768);
        gd.verticalAlignment = 1;
        cmpLegRight.setLayoutData((Object)gd);
        this.getComponentLegendRightArea(cmpLegRight);
        this.populateLists();
        return cmpContent;
    }

    private ChartSpinner createSpinner(Composite cmp, String sCaption, double dValue, boolean bEnableUI, Legend legend, String property) {
        new Label(cmp, 0).setText(sCaption);
        ChartSpinner spn = this.getContext().getUIFactory().createChartSpinner(cmp, 2048, (EObject)legend, property, bEnableUI);
        this.setSpinnerValue(spn.getWidget(), dValue);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        spn.setLayoutData((Object)gd);
        return spn;
    }

    protected void setSpinnerValue(Spinner spn, double dValue) {
        int spnValue = (int)(dValue * 100.0);
        spn.setValues(spnValue, 1, 100, 0, 1, 10);
    }

    protected void getComponentLegendLeftArea(Composite cmpLegLeft) {
        Label lblOrientation = new Label(cmpLegLeft, 0);
        lblOrientation.setText(Messages.getString("BlockAttributeComposite.Lbl.Orientation"));
        this.cmbOrientation = this.getContext().getUIFactory().createChartCombo(cmpLegLeft, 12, (EObject)this.getBlockForProcessing(), "orientation", ChartDefaultValueUtil.getDefaultLegend((Chart)this.getChart()).getOrientation().getName());
        GridData gdCMBOrientation = new GridData(768);
        gdCMBOrientation.horizontalSpan = 2;
        this.cmbOrientation.setLayoutData((Object)gdCMBOrientation);
        this.cmbOrientation.addSelectionListener((SelectionListener)this);
        Label lblPosition = new Label(cmpLegLeft, 0);
        lblPosition.setText(Messages.getString("BlockAttributeComposite.Lbl.Position"));
        this.cmbPosition = this.getContext().getUIFactory().createChartCombo(cmpLegLeft, 12, (EObject)this.getBlockForProcessing(), "position", ChartDefaultValueUtil.getDefaultLegend((Chart)this.getChart()).getPosition().getName());
        GridData gdCMBPosition = new GridData(768);
        gdCMBPosition.horizontalSpan = 2;
        this.cmbPosition.setLayoutData((Object)gdCMBPosition);
        this.cmbPosition.addSelectionListener((SelectionListener)this);
        Label lblAnchor = new Label(cmpLegLeft, 0);
        lblAnchor.setText(Messages.getString("BlockAttributeComposite.Lbl.Anchor"));
        this.cmbAnchor = this.getContext().getUIFactory().createChartCombo(cmpLegLeft, 12, (EObject)this.getBlockForProcessing(), "anchor", ChartDefaultValueUtil.getDefaultLegend((Chart)this.getChart()).getAnchor().getName());
        GridData gdCBAnchor = new GridData(768);
        gdCBAnchor.horizontalSpan = 2;
        this.cmbAnchor.setLayoutData((Object)gdCBAnchor);
        this.cmbAnchor.addSelectionListener((SelectionListener)this);
        Label lblStretch = new Label(cmpLegLeft, 0);
        lblStretch.setText(Messages.getString("BlockAttributeComposite.Lbl.Stretch"));
        this.cmbStretch = this.getContext().getUIFactory().createChartCombo(cmpLegLeft, 12, (EObject)this.getBlockForProcessing(), "stretch", ChartDefaultValueUtil.getDefaultLegend((Chart)this.getChart()).getStretch().getName());
        GridData gdCBStretch = new GridData(768);
        gdCBStretch.horizontalSpan = 2;
        this.cmbStretch.setLayoutData((Object)gdCBStretch);
        this.cmbStretch.addSelectionListener((SelectionListener)this);
        Label lblBackground = new Label(cmpLegLeft, 0);
        lblBackground.setText(Messages.getString("Shared.mne.Background_K"));
        int fillOptions = 27;
        this.fccBackground = new FillChooserComposite(cmpLegLeft, 0, fillOptions |= this.getContext().getUIFactory().supportAutoUI() ? 4 : fillOptions, this.getContext(), this.getBlockForProcessing().getBackground());
        GridData gdFCCBackground = new GridData(768);
        gdFCCBackground.horizontalSpan = 2;
        this.fccBackground.setLayoutData(gdFCCBackground);
        this.fccBackground.addListener(this);
        this.fccBackground.setTextIndent(0);
        Label lblDirection = new Label(cmpLegLeft, 0);
        lblDirection.setText(Messages.getString("BlockAttributeComposite.Lbl.Direction"));
        this.cmbDirection = this.getContext().getUIFactory().createChartCombo(cmpLegLeft, 12, (EObject)this.getBlockForProcessing(), "direction", ChartDefaultValueUtil.getDefaultLegend((Chart)this.getChart()).getDirection().getName());
        GridData gdCMBDirection = new GridData(768);
        gdCMBDirection.horizontalSpan = 2;
        this.cmbDirection.setLayoutData((Object)gdCMBDirection);
        this.cmbDirection.addSelectionListener((SelectionListener)this);
        Label lblWrapping = new Label(cmpLegLeft, 0);
        lblWrapping.setText(Messages.getString("LegendLayoutSheet.Label.WrappingWidth"));
        this.txtWrapping = this.getContext().getUIFactory().createChartNumberEditor(cmpLegLeft, 2052, null, (EObject)this.getBlockForProcessing(), "wrappingSize");
        new TextNumberEditorAssistField(this.txtWrapping.getTextControl(), null);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.txtWrapping.setLayoutData((Object)gd);
        this.txtWrapping.setValue(this.getBlockForProcessing().getWrappingSize());
        this.txtWrapping.addModifyListener((ModifyListener)this);
        this.spnMaxPercent = this.createSpinner(cmpLegLeft, Messages.getString("LegendLayoutSheet.Label.MaxPercent"), this.getBlockForProcessing().getMaxPercent(), true, this.getBlockForProcessing(), "maxPercent");
        this.spnMaxPercent.setRatio(100.0);
        this.spnTitlePercent = this.createSpinner(cmpLegLeft, Messages.getString("LegendLayoutSheet.Label.TitlePercent"), this.getBlockForProcessing().getTitlePercent(), true, this.getBlockForProcessing(), "titlePercent");
        this.spnTitlePercent.setRatio(100.0);
    }

    protected void getComponentLegendRightArea(Composite cmpLegRight) {
        Group grpOutline = new Group(cmpLegRight, 0);
        GridData gdGRPOutline = new GridData(768);
        grpOutline.setLayoutData((Object)gdGRPOutline);
        grpOutline.setLayout((Layout)new FillLayout());
        grpOutline.setText(Messages.getString("MoreOptionsChartLegendSheet.Label.Outline"));
        boolean bEnableUI = this.getBlockForProcessing().isVisible();
        int lineOptions = 15;
        this.outlineLegend = new LineAttributesComposite((Composite)grpOutline, 0, lineOptions |= this.getContext().getUIFactory().supportAutoUI() ? 16 : lineOptions, this.getContext(), this.getBlockForProcessing().getOutline(), ChartDefaultValueUtil.getDefaultLegend((Chart)this.getChart()).getOutline());
        this.outlineLegend.addListener(this);
        this.outlineLegend.setAttributesEnabled(bEnableUI);
        this.icLegend = this.getContext().getUIFactory().createChartInsetsComposite(cmpLegRight, 0, 2, this.getBlockForProcessing().getInsets(), this.getChart().getUnits(), this.getContext().getUIServiceProvider(), this.getContext(), ChartDefaultValueUtil.getDefaultPlot((Chart)this.getChart()).getInsets());
        GridData gdICBlock = new GridData(768);
        this.icLegend.setLayoutData((Object)gdICBlock);
        this.icLegend.setEnabled(bEnableUI);
    }

    protected void populateLists() {
        NameSet ns = LiteralHelper.stretchSet;
        this.cmbStretch.setItems(ns.getDisplayNames());
        this.cmbStretch.setItemData(ns.getNames());
        this.cmbStretch.setSelection(this.getBlockForProcessing().getStretch().getName());
        ns = LiteralHelper.orientationSet;
        this.cmbOrientation.setItems(ns.getDisplayNames());
        this.cmbOrientation.setItemData(ns.getNames());
        this.cmbOrientation.setSelection(this.getBlockForProcessing().getOrientation().getName());
        ns = LiteralHelper.directionSet;
        this.cmbDirection.setItems(ns.getDisplayNames());
        this.cmbDirection.setItemData(ns.getNames());
        this.cmbDirection.setSelection(this.getBlockForProcessing().getDirection().getName());
        ns = LiteralHelper.notOutPositionSet;
        this.cmbPosition.setItems(ns.getDisplayNames());
        this.cmbPosition.setItemData(ns.getNames());
        this.cmbPosition.setSelection(this.getBlockForProcessing().getPosition().getName());
        this.getAnchorSet();
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget.equals(this.txtWrapping) && !"Reset".equals(e.data)) {
            this.setWrappingSizeAttr();
        }
    }

    protected void setWrappingSizeAttr() {
        this.getBlockForProcessing().setWrappingSize(this.txtWrapping.getValue());
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.fccBackground)) {
            this.getBlockForProcessing().setBackground((Fill)event.data);
        } else if (event.widget.equals((Object)this.outlineLegend)) {
            boolean isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
            switch (event.type) {
                case 1: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing().getOutline(), (String)"style", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 2: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing().getOutline(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
                    break;
                }
                case 3: {
                    this.getBlockForProcessing().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing().getOutline(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                }
            }
        } else if (event.widget.equals(this.icLegend)) {
            this.getBlockForProcessing().setInsets((Insets)event.data);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        Legend legend = this.getBlockForProcessing();
        if (oSource.equals(this.cmbAnchor)) {
            String selectedAnchor = this.cmbAnchor.getSelectedItemData();
            if (selectedAnchor != null) {
                legend.setAnchor(Anchor.getByName((String)selectedAnchor));
            }
        } else if (oSource.equals(this.cmbStretch)) {
            String selectedStretch = this.cmbStretch.getSelectedItemData();
            if (selectedStretch != null) {
                legend.setStretch(Stretch.getByName((String)selectedStretch));
            }
        } else if (oSource.equals(this.cmbOrientation)) {
            String selectedOrientation = this.cmbOrientation.getSelectedItemData();
            if (selectedOrientation != null) {
                legend.setOrientation(Orientation.getByName((String)selectedOrientation));
            }
        } else if (oSource.equals(this.cmbDirection)) {
            String selectedDirection = this.cmbDirection.getSelectedItemData();
            if (selectedDirection != null) {
                legend.setDirection(Direction.getByName((String)selectedDirection));
            }
        } else if (oSource.equals(this.cmbPosition)) {
            String selectedPosition = this.cmbPosition.getSelectedItemData();
            if (selectedPosition != null) {
                legend.setPosition(Position.getByName((String)selectedPosition));
            }
            this.getAnchorSet();
        }
    }

    protected Legend getBlockForProcessing() {
        return this.getChart().getLegend();
    }

    protected void getAnchorSet() {
        String positionValue = this.getBlockForProcessing().getPosition().getLiteral();
        NameSet ns = positionValue.equals(Position.LEFT_LITERAL.getLiteral()) || positionValue.equals(Position.RIGHT_LITERAL.getLiteral()) ? LiteralHelper.verticalAnchorSet : (positionValue.equals(Position.ABOVE_LITERAL.getLiteral()) || positionValue.equals(Position.BELOW_LITERAL.getLiteral()) ? LiteralHelper.horizontalAnchorSet : LiteralHelper.anchorSet);
        this.cmbAnchor.setItems(ns.getDisplayNames());
        this.cmbAnchor.setItemData(ns.getNames());
        this.cmbAnchor.setSelection(this.getBlockForProcessing().getAnchor().getName());
    }
}

