/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Vector;
import org.eclipse.birt.chart.ui.swt.AbstractChartIntSpinner;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class IntegerSpinControl
extends AbstractChartIntSpinner
implements SelectionListener,
Listener {
    private transient int iSize = 16;
    private transient int iMinValue = 0;
    private transient int iMaxValue = 100;
    protected transient int iCurrentValue = 0;
    private transient int iIncrement = 1;
    protected transient Composite cmpContentOuter = null;
    private transient Composite cmpContentInner = null;
    private transient Composite cmpBtnContainer = null;
    protected transient Button btnIncrement = null;
    protected transient Button btnDecrement = null;
    protected transient TextEditorComposite txtValue = null;
    protected transient Vector<Listener> vListeners = null;
    public static final int VALUE_CHANGED_EVENT = 1;
    protected transient boolean bEnabled = true;

    public IntegerSpinControl(Composite parent, int style, int iCurrentValue) {
        super(parent, style);
        this.iCurrentValue = iCurrentValue;
        this.init();
        this.placeComponents();
        this.initAccessible();
    }

    private void init() {
        if (Display.getCurrent().getHighContrast()) {
            GC gc = new GC((Drawable)this);
            this.iSize = gc.getFontMetrics().getHeight();
        }
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.vListeners = new Vector();
    }

    protected void placeComponents() {
        FillLayout fl = new FillLayout();
        fl.marginHeight = 0;
        fl.marginWidth = 0;
        this.setLayout((Layout)fl);
        this.cmpContentOuter = new Composite((Composite)this, 0);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 1;
        this.cmpContentOuter.setLayout((Layout)gl);
        this.creaetSpinner(this.cmpContentOuter);
    }

    protected void creaetSpinner(Composite parent) {
        this.cmpContentInner = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        this.cmpContentInner.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        this.cmpContentInner.setLayoutData((Object)gd);
        this.txtValue = new TextEditorComposite(this.cmpContentInner, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 1;
        gd.heightHint = this.iSize + 8;
        gd.minimumWidth = 30;
        this.txtValue.setLayoutData(gd);
        this.txtValue.setText(String.valueOf(this.iCurrentValue));
        this.txtValue.addListener(this);
        this.cmpBtnContainer = new Composite(this.cmpContentInner, 0);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 0x1000008;
        this.cmpBtnContainer.setLayoutData((Object)gd);
        this.cmpBtnContainer.setBackground(Display.getDefault().getSystemColor(3));
        gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.cmpBtnContainer.setLayout((Layout)gl);
        int iHalf = (this.iSize + 8) / 2;
        this.btnIncrement = new Button(this.cmpBtnContainer, 132);
        gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = iHalf;
        gd.widthHint = iHalf;
        this.btnIncrement.setLayoutData((Object)gd);
        this.btnIncrement.addSelectionListener((SelectionListener)this);
        this.btnDecrement = new Button(this.cmpBtnContainer, 1028);
        gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = iHalf;
        gd.widthHint = iHalf;
        this.btnDecrement.setLayoutData((Object)gd);
        this.btnDecrement.addSelectionListener((SelectionListener)this);
    }

    public void setMinimum(int iMin) {
        this.iMinValue = iMin;
    }

    public int getMinimum() {
        return this.iMinValue;
    }

    public void setMaximum(int iMax) {
        this.iMaxValue = iMax;
    }

    public int getMaximum() {
        return this.iMaxValue;
    }

    public void setIncrement(int iIncrement) {
        this.iIncrement = iIncrement;
    }

    public void setValue(int iCurrent) {
        this.iCurrentValue = iCurrent;
        this.txtValue.setText(String.valueOf(this.iCurrentValue));
    }

    public int getValue() {
        return this.iCurrentValue;
    }

    public void setEnabled(boolean bState) {
        super.setEnabled(bState);
        this.setEnabledImpl(bState);
        this.bEnabled = bState;
    }

    protected void setEnabledImpl(boolean bState) {
        this.btnIncrement.setEnabled(bState);
        this.btnDecrement.setEnabled(bState);
        this.txtValue.setEnabled(bState);
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public boolean isSpinnerEnabled() {
        return this.isEnabled();
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    public void widgetSelected(SelectionEvent e) {
        int iTextValue = this.iCurrentValue;
        try {
            iTextValue = Integer.valueOf(this.txtValue.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        Object oSource = e.getSource();
        if (oSource.equals(this.btnIncrement)) {
            if (this.iCurrentValue < this.iMaxValue && iTextValue >= this.iMinValue && iTextValue < this.iMaxValue) {
                this.iCurrentValue = iTextValue + this.iIncrement;
                this.txtValue.setText(String.valueOf(this.iCurrentValue));
            } else if (iTextValue < this.iMinValue) {
                this.iCurrentValue = this.iMinValue;
                this.txtValue.setText(String.valueOf(this.iMinValue));
            }
        } else if (oSource.equals(this.btnDecrement)) {
            if (this.iCurrentValue > this.iMinValue && iTextValue > this.iMinValue && iTextValue <= this.iMaxValue) {
                this.iCurrentValue = iTextValue - this.iIncrement;
                this.txtValue.setText(String.valueOf(this.iCurrentValue));
            } else if (this.iCurrentValue > this.iMaxValue) {
                this.iCurrentValue = this.iMaxValue;
                this.txtValue.setText(String.valueOf(this.iMaxValue));
            }
        }
        this.fireValueChangedEvent();
    }

    protected void fireValueChangedEvent() {
        int iL = 0;
        while (iL < this.vListeners.size()) {
            Event se = new Event();
            se.widget = this;
            se.data = this.iCurrentValue;
            se.type = 1;
            se.detail = ChartUIExtensionUtil.PROPERTY_UPDATE;
            this.vListeners.get(iL).handleEvent(se);
            ++iL;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Point getPreferredSize() {
        return new Point(80, 24);
    }

    public void handleEvent(Event event) {
        block12: {
            if (event.type == 0) {
                try {
                    int iValue = Integer.valueOf(this.txtValue.getText());
                    if (iValue >= this.iMinValue && iValue <= this.iMaxValue) {
                        this.iCurrentValue = iValue;
                        this.fireValueChangedEvent();
                        break block12;
                    }
                    this.txtValue.setText(String.valueOf(this.iCurrentValue));
                }
                catch (NumberFormatException numberFormatException) {
                    this.txtValue.setText(String.valueOf(this.iCurrentValue));
                }
            } else if (event.type == 1) {
                int iValue = this.iCurrentValue;
                if (event.keyCode == 0x1000001) {
                    iValue = event.stateMask == 262144 ? (iValue += this.iIncrement * 10) : (iValue += this.iIncrement);
                } else if (event.keyCode == 0x1000002) {
                    iValue = event.stateMask == 262144 ? (iValue -= this.iIncrement * 10) : (iValue -= this.iIncrement);
                }
                if (iValue < this.iMinValue) {
                    iValue = this.iMinValue;
                } else if (iValue > this.iMaxValue) {
                    iValue = this.iMaxValue;
                }
                this.iCurrentValue = iValue;
                this.txtValue.setText(String.valueOf(this.iCurrentValue));
                this.fireValueChangedEvent();
            }
        }
    }

    public void setToolTipText(String string) {
        this.txtValue.setToolTipText(string);
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = IntegerSpinControl.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = IntegerSpinControl.this.toControl(new Point(e.x, e.y));
                if (IntegerSpinControl.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = IntegerSpinControl.this.getBounds();
                Point pt = IntegerSpinControl.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }
}

