/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view.internal;

import hiro.yoshioka.job.CompareDatabasesJob;
import hiro.yoshioka.job.MirrorJob;
import hiro.yoshioka.preferences.DataGenerateDialog;
import hiro.yoshioka.preferences.ModifyDBResourceDialog;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.engine.GettingResourceRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBResourceType;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.view.DBResourceTreeSelection;
import hiro.yoshioka.sql.resource.view.IDBResourceTreeViewerContextMenuListener;
import hiro.yoshioka.sql.resource.view.action.FunctionExecuteAction;
import hiro.yoshioka.sql.resource.xml.DBTableValue;
import hiro.yoshioka.sql.ui.editor.SQLEditor;
import hiro.yoshioka.sql.util.DefaultDatabaseComparingDialog;
import hiro.yoshioka.sql.util.DefaultMirroringDialog;
import hiro.yoshioka.ui.action.ConnectAction;
import hiro.yoshioka.ui.action.CountReportAction;
import hiro.yoshioka.ui.action.DeaultSQLAction;
import hiro.yoshioka.ui.action.DisConnectAction;
import hiro.yoshioka.ui.action.ReadExcelDefinitionAction;
import hiro.yoshioka.ui.action.RenameFieldAction;
import hiro.yoshioka.ui.action.ShowACLAction;
import hiro.yoshioka.ui.view.ExplorerView;
import hiro.yoshioka.ui.view.Messages;
import hiro.yoshioka.ui.view.internal.WolfSelectTableDialog;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.vaction.NewEditorDropDownAction;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ImageManager;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExplorerMenu
implements IDBResourceTreeViewerContextMenuListener {
    protected transient Log fLogger = LogFactory.getLog(this.getClass());
    private ExplorerView explorerView;

    public ExplorerMenu(ExplorerView explorerView) {
        this.explorerView = explorerView;
    }

    private IAction createSqlAction(boolean isScrap) {
        NewEditorDropDownAction ret = new NewEditorDropDownAction(ResourceMarker.sqlFolder, "SQL Editor", ImageManager.getImageDescriptor("action/edit_sql.png"), isScrap);
        ret.setConnectionProperties(this.explorerView.getSelectedConnectionProperties());
        return ret;
    }

    private IAction createLstAction(boolean isScrap) {
        NewEditorDropDownAction ret = new NewEditorDropDownAction(ResourceMarker.lstFolder, "Table List Editor", ImageManager.getImageDescriptor("action/table_analysis.png"), isScrap);
        ret.setConnectionProperties(this.explorerView.getSelectedConnectionProperties());
        return ret;
    }

    public boolean hasEditorMenu() {
        return true;
    }

    public void createEditorContextMenuShow(IMenuManager manager) {
        MenuManager sqlEditorMenu = new MenuManager(Messages.getString("ExplorerView.OpenSQLEditorMenu"), ImageManager.getImageDescriptor("action/edit_sql.png"), "wolf-sql-menu_id");
        MenuManager lstEditorMenu = new MenuManager(Messages.getString("ExplorerView.OpenTableListEditorMenu"), ImageManager.getImageDescriptor("action/table_analysis.png"), "wolf-lst-menu_id");
        sqlEditorMenu.add(this.createSqlAction(false));
        sqlEditorMenu.add(this.createSqlAction(true));
        lstEditorMenu.add(this.createLstAction(false));
        lstEditorMenu.add(this.createLstAction(true));
        manager.add((IContributionItem)sqlEditorMenu);
        manager.add((IContributionItem)lstEditorMenu);
    }

    public void createConnectionMenuShow(IMenuManager manager, DatabaseType databaseType, ConnectionProperties prop) {
        ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(prop);
        manager.add((IAction)new Action(Messages.getString("ExplorerView.RefreshResourceTree"), ImageUtil.getImageDescriptor((String)"action/0v_rehresh.gif")){

            public void run() {
                ConnectAction c = new ConnectAction(ExplorerMenu.this.explorerView, prop);
                c.run();
            }
        });
        manager.add((IContributionItem)new Separator());
        ConnectAction connect = new ConnectAction(this.explorerView, prop);
        connect.setEnabled(!prop.isConnected());
        manager.add((IAction)connect);
        DisConnectAction dis_connect = new DisConnectAction(this.explorerView, prop);
        dis_connect.setEnabled(prop.isConnected());
        manager.add((IAction)dis_connect);
        manager.add((IContributionItem)new Separator());
        DeaultSQLAction commit = new DeaultSQLAction(this.explorerView, SQLOperationType.COMMIT, prop);
        commit.configureAction(Messages.getString("ExplorerView.Commit"), "Commit", ImageManager.getImageDescriptor("action/35commit.gif"));
        commit.setEnabled(sql != null && sql.canDoOperation(SQLOperationType.COMMIT));
        manager.add((IAction)commit);
        DeaultSQLAction rollback = new DeaultSQLAction(this.explorerView, SQLOperationType.ROLLBACK, prop);
        rollback.configureAction(Messages.getString("ExplorerView.RollBack"), "RollBack", ImageManager.getImageDescriptor("action/36rollback.gif"));
        rollback.setEnabled(sql != null && sql.canDoOperation(SQLOperationType.ROLLBACK));
        manager.add((IAction)rollback);
        DeaultSQLAction calsel = new DeaultSQLAction(this.explorerView, SQLOperationType.CANSEL, prop);
        calsel.configureAction(Messages.getString("ExplorerView.RequestCansel"), "Request Cansel", ImageManager.getImageDescriptor("action/39cancel.gif"));
        calsel.setEnabled(sql != null);
        manager.add((IAction)calsel);
        manager.add((IContributionItem)new Separator());
        Action connectionDialog = new Action(Messages.getString("ExplorerView.OpenConnectionConfigDialogMenu"), ImageUtil.getImageDescriptor((String)"action/0v_rehresh.gif")){

            public void run() {
                ExplorerMenu.this.explorerView.getTreeViewer().openConfigDialog(prop);
            }
        };
        manager.add((IAction)connectionDialog);
        if (prop.isConnected()) {
            DeaultSQLAction showSession;
            manager.add((IContributionItem)new Separator());
            if (sql.canDoOperation(SQLOperationType.SELECT_SESSION)) {
                showSession = new DeaultSQLAction(this.explorerView, SQLOperationType.SELECT_SESSION, prop);
                showSession.configureAction("Show Session", Messages.getString("ExplorerView.31"), ImageUtil.getImageDescriptor((String)"action/38show_session.gif"));
                manager.add((IAction)showSession);
            } else {
                showSession = new DeaultSQLAction(this.explorerView, SQLOperationType.SELECT_SESSION, prop);
                showSession.configureAction("Show Session (NO GRANT SYS.V_$SESSION)", Messages.getString("ExplorerView.31"), ImageUtil.getImageDescriptor((String)"action/38show_session.gif"));
                showSession.setEnabled(false);
                manager.add((IAction)showSession);
            }
            if (sql.canDoOperation(SQLOperationType.SELECT_LOCK)) {
                DeaultSQLAction showLock = new DeaultSQLAction(this.explorerView, SQLOperationType.SELECT_LOCK, prop);
                showLock.configureAction(Messages.getString("ExplorerView.ShowLockInfo"), "Show Lock Info", ImageUtil.getImageDescriptor((String)"action/80lock.gif"));
                manager.add((IAction)showLock);
                manager.add((IContributionItem)new Separator());
            }
            if (sql.canDoOperation(SQLOperationType.WORST_SQL)) {
                DeaultSQLAction worstSql = new DeaultSQLAction(this.explorerView, SQLOperationType.WORST_SQL, prop);
                worstSql.configureAction(Messages.getString("ExplorerView.ShowWorstSQL"), "Show Worst SQL", ImageUtil.getImageDescriptor((String)"action/81warning.gif"));
                manager.add((IAction)worstSql);
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IContributionItem)new Separator());
            CountReportAction ca = new CountReportAction(this.explorerView, prop, null);
            manager.add((IAction)ca);
        }
    }

    private void createMenuOfCreateDBResource(DBResourceType dType, MenuManager createMenu, Shell shell, ConnectionProperties prop, ITransactionSQL sql, DBResourceTreeSelection selection) {
        String title = String.format("Create %s", dType.name());
        SQLOperationType opType0 = null;
        String imgKey = null;
        switch (dType) {
            case DATABASE: {
                opType0 = SQLOperationType.CREATE_DATABASE;
                imgKey = "dbresource/01database.gif";
                break;
            }
            case SCHEMA: {
                opType0 = SQLOperationType.CREATE_SCHEMA;
                imgKey = "dbresource/02schema.png";
                break;
            }
            case LOGIN_ROLE: {
                opType0 = SQLOperationType.CREATE_LOGIN_ROLE;
                imgKey = "dbresource/02schema.png";
            }
        }
        SQLOperationType opType = opType0;
        Action createDBResourceAction = new Action(title, ImageUtil.getImageDescriptor((String)imgKey)){

            public void run() {
                String title2 = title;
                if (prop.getDatabaseType().isEvernote()) {
                    title2 = "Create Notebook";
                }
                ModifyDBResourceDialog dialog = new ModifyDBResourceDialog(shell, prop, opType, selection, dType);
                dialog.setDialogTitle(title2);
                if (dialog.open() == 0) {
                    try {
                        if (SQLServerThread.runNowThisRequest((Request)dialog.getRequest())) {
                            GettingResourceRequest request = new GettingResourceRequest(prop);
                            SQLServerThread.putRequest((Request)request);
                            Application.openDialog("", "Success", 2);
                        } else {
                            Application.openDialog("", "Fault", 1);
                        }
                    }
                    catch (Exception e) {
                        ExplorerMenu.this.fLogger.fatal((Object)"", (Throwable)e);
                    }
                }
            }
        };
        createMenu.add((IAction)createDBResourceAction);
        createDBResourceAction.setEnabled(sql.canDoOperation(opType));
    }

    public void createResourceOfDBMenuShow(Shell shell, IMenuManager manager, DatabaseType databaseType, ConnectionProperties prop, DBResourceTreeSelection selection) {
        IDBResource firstSelection = selection.getFirstDBResource();
        if (prop.isConnected()) {
            MenuManager createMenu = new MenuManager("Create menu", ImageUtil.getImageDescriptor((String)"action/add_obj.gif"), "Wolf Create Menu");
            ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(prop);
            manager.add((IContributionItem)createMenu);
            if (sql != null) {
                DBResourceType[] menus;
                DBResourceType[] dBResourceTypeArray = menus = new DBResourceType[]{DBResourceType.DATABASE, DBResourceType.SCHEMA, DBResourceType.LOGIN_ROLE};
                int n = menus.length;
                int n2 = 0;
                while (n2 < n) {
                    DBResourceType dType = dBResourceTypeArray[n2];
                    this.createMenuOfCreateDBResource(dType, createMenu, shell, prop, sql, selection);
                    ++n2;
                }
            }
            CountReportAction ca = new CountReportAction(this.explorerView, prop, firstSelection);
            manager.add((IAction)ca);
            if (!selection.hasMultiResource()) {
                if (firstSelection instanceof IDBSchema || firstSelection instanceof IDBTable) {
                    manager.add((IAction)new Action(Messages.getString("ExplorerView.RefreshResourceTree"), ImageUtil.getImageDescriptor((String)"action/0v_rehresh.gif")){

                        public void run() {
                            if (firstSelection instanceof IDBSchema) {
                                ExplorerMenu.this.explorerView.refreshSchemaOnTree(prop, (IDBSchema)firstSelection);
                            } else if (firstSelection instanceof IDBTable) {
                                ExplorerMenu.this.explorerView.getTreeViewer().refreshTableColumnsOnTree((IDBTable)firstSelection, true);
                            }
                        }
                    });
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new Action(Messages.getString("ExplorerView.MirroringToAnoterDatabase")){

                        public void run() {
                            for (IDBSchema schema : selection.getSchemaSet(false)) {
                                if (schema.getTableOrSystemTables().length != 0) continue;
                                ExplorerMenu.this.explorerView.refreshSchemaOnTree(prop, schema);
                            }
                            WolfMirroringDialog dialog = new WolfMirroringDialog(shell, prop, selection);
                            dialog.open();
                        }
                    });
                    manager.add((IAction)new Action(Messages.getString("ExplorerView.CompareToAnotherDatabase"), ImageUtil.getImageDescriptor((String)"action/54compare.gif")){

                        public void run() {
                            WolfComparingDialog dialog = new WolfComparingDialog(shell, prop, selection);
                            dialog.open();
                        }
                    });
                    manager.add((IContributionItem)new Separator());
                    if (firstSelection instanceof IDBTable) {
                        IDBTable tbl = (IDBTable)firstSelection;
                        if (tbl.isTable() || tbl.isView()) {
                            manager.add((IAction)new Action("Open 'Record selection dialog'", ImageUtil.getImageDescriptor((String)"action/select_table.gif")){

                                public void run() {
                                    ExplorerMenu.this.openRecordSelectionDialog(prop, tbl);
                                }
                            });
                        } else if (tbl.isFunction() || tbl.isProcudeure()) {
                            manager.add((IAction)new FunctionExecuteAction(this.explorerView.getTreeViewer(), tbl));
                        }
                        if (tbl.isTable()) {
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new Action(Messages.getString("ExplorerView.GenerateData"), ImageUtil.getImageDescriptor((String)"action/add_obj.gif")){

                                public void run() {
                                    if (tbl.getColumns().length == 0) {
                                        ExplorerMenu.this.explorerView.getTreeViewer().refreshTableColumnsOnTree(tbl, true);
                                    }
                                    DataGenerateDialog dialog = new DataGenerateDialog(Display.getCurrent().getActiveShell(), new DBTableValue(tbl), prop);
                                    dialog.setDatabaseType(prop.getDatabaseType());
                                    DBRoot root = prop.getDBRootResource();
                                    if (root != null) {
                                        dialog.setDatabaseVersion(root.getDatabaseVersion());
                                    }
                                    if (dialog.open() == 0) {
                                        String text = dialog.getInsertScript();
                                        SQLEditor editor = Application.openNewSQLEditor(null, null);
                                        editor.setText(text);
                                        editor.setConnectionCombo(SQLServerThread.getSQLServer().getConnectionSettingBean().getDisplayStrings(), prop.getDisplayString());
                                    }
                                }
                            });
                        }
                    }
                }
                if (firstSelection instanceof IDBColumn) {
                    RenameFieldAction renameAction = new RenameFieldAction(this.explorerView, prop, (IDBColumn)firstSelection);
                    renameAction.configureAction(Messages.getString("ExplorerView.RenameField_Column"), "Rename", null);
                    manager.add((IAction)renameAction);
                }
            }
        }
        ReadExcelDefinitionAction rExcelDefAction = new ReadExcelDefinitionAction(this.explorerView);
        manager.add((IAction)rExcelDefAction);
        if (firstSelection instanceof IDBSchema && prop.getDatabaseType().isDomino()) {
            ShowACLAction acl = new ShowACLAction(this.explorerView, prop, (IDBSchema)firstSelection);
            manager.add((IAction)acl);
        }
    }

    public void openRecordSelectionDialog(ConnectionProperties connectionProperties, IDBTable tbl) {
        WolfSelectTableDialog dialog = new WolfSelectTableDialog(connectionProperties, this.explorerView.getTreeViewer().getTree().getShell(), tbl, null, null);
        dialog.open();
    }

    class WolfComparingDialog
    extends DefaultDatabaseComparingDialog {
        public WolfComparingDialog(Shell shell, ConnectionProperties p, DBResourceTreeSelection treeSelection) {
            super(shell, p, treeSelection);
        }

        protected boolean showProgressSection() {
            return false;
        }

        protected int getInitialHeight() {
            return 440;
        }

        protected void compare(Set<IDBTable> compareTableSet) {
            try {
                this.close();
                CompareDatabasesJob job = new CompareDatabasesJob(this.diff_struct_request, this.mirroring_request, compareTableSet);
                job.setUser(true);
                job.schedule();
            }
            catch (Exception e) {
                this.fLogger.warn((Object)"", (Throwable)e);
            }
        }
    }

    class WolfMirroringDialog
    extends DefaultMirroringDialog {
        public WolfMirroringDialog(Shell shell, ConnectionProperties p, DBResourceTreeSelection treeSelection) {
            super(shell, p, treeSelection);
        }

        protected boolean showProgressSection() {
            return false;
        }

        protected void mirroring() {
            try {
                this.close();
                MirrorJob job = new MirrorJob(this.mirroring_request);
                job.setUser(true);
                job.schedule();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

