/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view;

import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.ui.view.IResultSetView;
import hiro.yoshioka.ui.view.internal.SimaPureViewer;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class MultiResultSetView
extends ViewPart
implements IResultSetView {
    protected transient Log fLogger = LogFactory.getLog(this.getClass());
    public static final String ID = "MultiResultSetViewID";
    ResultSetDataHolder2[] fResultSetDataHolders;
    int[][] fMatchingPos;
    private SimaPureViewer[] fSimasimas;
    private CTabFolder fFolder;
    ArrayList<SimaPureViewer> fViewerList = new ArrayList();
    private int fViewMode = 0;
    private String connectionPropertiesDisplayString;

    public void createPartControl(Composite parent) {
        this.fFolder = new CTabFolder(parent, 2048);
        if (this.fLogger.isTraceEnabled()) {
            this.fLogger.trace((Object)("created fFolder[" + this.fFolder + "]"));
        }
        this.fFolder.setSimple(false);
        this.fFolder.setTabPosition(1024);
        this.fFolder.setSelectionBackground(new Color[]{this.getViewSite().getShell().getDisplay().getSystemColor(31), this.getViewSite().getShell().getDisplay().getSystemColor(32)}, new int[]{70}, true);
        this.fFolder.setSelectionForeground(this.getViewSite().getShell().getDisplay().getSystemColor(1));
    }

    public void setInput(Object result, boolean isVirtual) {
        this.fResultSetDataHolders = (ResultSetDataHolder2[])result;
        this.fViewerList.clear();
        if (this.fFolder == null) {
            this.fLogger.error((Object)"fFolder is NULL cant execute setInput Method");
            this.fLogger.error((Object)("result=" + result));
            return;
        }
        CTabItem[] items = this.fFolder.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        this.fLogger.info((Object)("result Len =" + this.fResultSetDataHolders.length));
        this.fSimasimas = new SimaPureViewer[this.fResultSetDataHolders.length];
        i = 0;
        while (i < this.fResultSetDataHolders.length) {
            SimaPureViewer viewer;
            CTabItem tabItem1 = new CTabItem(this.fFolder, 0);
            if (this.fResultSetDataHolders[i].getTableName().trim().length() > 0) {
                tabItem1.setText(this.fResultSetDataHolders[i].getTableName());
            } else {
                tabItem1.setText(this.fResultSetDataHolders[i].getTableNameE());
            }
            this.fSimasimas[i] = viewer = new SimaPureViewer((Composite)this.fFolder, PreferenceUtil.getBoolean("BOOLEAN_VIEWER_SWING"), isVirtual, false);
            viewer.setInput((ResultSetDataHolder)this.fResultSetDataHolders[i], false);
            tabItem1.setControl(viewer.getControl());
            this.fViewerList.add(viewer);
            ++i;
        }
        if (this.fFolder.getItemCount() > 0) {
            this.fFolder.setSelection(0);
        }
    }

    public void setInput(Object o) {
        this.setInput(o, false);
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    public void setFocus() {
        if (this.fSimasimas != null && this.fFolder != null && this.fSimasimas.length > this.fFolder.getSelectionIndex() && this.fFolder.getSelectionIndex() >= 0) {
            this.fSimasimas[this.fFolder.getSelectionIndex()].setFocus();
        }
    }

    @Override
    public ResultSetDataHolder2[] getResultSetDataHolders() {
        return this.fResultSetDataHolders;
    }

    public void setMatchingPos(int[][] pos) {
        this.fMatchingPos = pos;
    }

    @Override
    public int[][] getMatchingPos() {
        return this.fMatchingPos;
    }

    @Override
    public void adjustDatum() {
        this.fSimasimas[this.fFolder.getSelectionIndex()].adjustDatum();
    }

    @Override
    public void adjustHeader() {
        this.fSimasimas[this.fFolder.getSelectionIndex()].adjustHeader();
    }

    @Override
    public void adjustArea() {
        this.fSimasimas[this.fFolder.getSelectionIndex()].adjustArea();
    }

    @Override
    public void selectAll() {
        this.fSimasimas[this.fFolder.getSelectionIndex()].selectAll();
    }

    public void setViewMode(int flashBack) {
        this.fViewMode = flashBack;
    }

    public int getViewMode() {
        return this.fViewMode;
    }

    @Override
    public String[] getSQLStatements() {
        String[] ret = new String[this.fResultSetDataHolders.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = this.fResultSetDataHolders[i].getSqlStatement();
            ++i;
        }
        return ret;
    }

    @Override
    public String getConnectionPropertiesDisplay() {
        return this.connectionPropertiesDisplayString;
    }

    @Override
    public void setConnectionPropertiesDisplay(String connectionDisplayString) {
        this.connectionPropertiesDisplayString = connectionDisplayString;
    }
}

