/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view;

import hiro.yoshioka.util.logging.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsoleResourceBundleMessages;
import org.eclipse.ui.internal.console.IConsoleHelpContextIds;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractActionViewPart
extends ViewPart {
    private MenuManager fMenuManager;
    private List fContextMenuManagers;
    protected Map fGlobalActions = new HashMap();
    protected ArrayList fSelectionActions = new ArrayList();
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            AbstractActionViewPart.this.updateSelectionDependentActions();
        }
    };
    private ITextListener textListener = new ITextListener(){

        public void textChanged(TextEvent event) {
            IUpdate findReplace = (IUpdate)AbstractActionViewPart.this.fGlobalActions.get(ActionFactory.FIND.getId());
            if (findReplace != null) {
                findReplace.update();
            }
        }
    };
    SourceViewer viewer;

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateAction(String actionId) {
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void createActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        TextViewerAction action = new TextViewerAction((ITextViewer)this.getViewer(), 7);
        action.configureAction(ConsoleMessages.TextConsolePage_SelectAllText, ConsoleMessages.TextConsolePage_SelectAllDescrip, ConsoleMessages.TextConsolePage_SelectAllDescrip);
        action.setActionDefinitionId(ActionFactory.SELECT_ALL.getCommandId());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, IConsoleHelpContextIds.CONSOLE_SELECT_ALL_ACTION);
        this.setGlobalAction(actionBars, ActionFactory.SELECT_ALL.getId(), (IAction)action);
        action = new TextViewerAction((ITextViewer)this.getViewer(), 3);
        action.configureAction(ConsoleMessages.TextConsolePage_CutText, ConsoleMessages.TextConsolePage_CutDescrip, ConsoleMessages.TextConsolePage_CutDescrip);
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
        action.setActionDefinitionId(ActionFactory.CUT.getCommandId());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, IConsoleHelpContextIds.CONSOLE_CUT_ACTION);
        this.setGlobalAction(actionBars, ActionFactory.CUT.getId(), (IAction)action);
        action = new TextViewerAction((ITextViewer)this.getViewer(), 4);
        action.configureAction(ConsoleMessages.TextConsolePage_CopyText, ConsoleMessages.TextConsolePage_CopyDescrip, ConsoleMessages.TextConsolePage_CopyDescrip);
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        action.setActionDefinitionId(ActionFactory.COPY.getCommandId());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, IConsoleHelpContextIds.CONSOLE_COPY_ACTION);
        this.setGlobalAction(actionBars, ActionFactory.COPY.getId(), (IAction)action);
        action = new TextViewerAction((ITextViewer)this.getViewer(), 5);
        action.configureAction(ConsoleMessages.TextConsolePage_PasteText, ConsoleMessages.TextConsolePage_PasteDescrip, ConsoleMessages.TextConsolePage_PasteDescrip);
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        action.setActionDefinitionId(ActionFactory.PASTE.getCommandId());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, IConsoleHelpContextIds.CONSOLE_PASTE_ACTION);
        this.setGlobalAction(actionBars, ActionFactory.PASTE.getId(), (IAction)action);
        ConsoleResourceBundleMessages.getBundle();
        this.fSelectionActions.add(ActionFactory.CUT.getId());
        this.fSelectionActions.add(ActionFactory.COPY.getId());
        this.fSelectionActions.add(ActionFactory.PASTE.getId());
        this.fSelectionActions.add(ActionFactory.FIND.getId());
        actionBars.updateActionBars();
    }

    public void createPartControl(Composite parent) {
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new LineNumberRulerColumn());
        this.viewer = new SourceViewer(parent, (IVerticalRuler)ruler, 2816);
        LogUtil.connect((StyledText)this.viewer.getTextWidget());
        this.viewer.setDocument((IDocument)new Document());
        String id = "#ContextMenu";
        this.fMenuManager = new MenuManager("#ContextMenu", id);
        this.fMenuManager.setRemoveAllWhenShown(true);
        this.fMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                AbstractActionViewPart.this.contextMenuAboutToShow(m);
            }
        });
        Menu menu = this.fMenuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
        this.createActions();
        this.configureToolBar(this.getViewSite().getActionBars().getToolBarManager());
        this.getSite().registerContextMenu(id, this.fMenuManager, (ISelectionProvider)this.getViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.viewer.getSelectionProvider().addSelectionChangedListener(this.selectionChangedListener);
        this.viewer.addTextListener(this.textListener);
    }

    public Control getControl() {
        return this.viewer != null ? this.viewer.getControl() : null;
    }

    protected void contextMenuAboutToShow(IMenuManager menuManager) {
        IDocument doc = this.getViewer().getDocument();
        if (doc == null) {
            return;
        }
        menuManager.add((IAction)this.fGlobalActions.get(ActionFactory.CUT.getId()));
        menuManager.add((IAction)this.fGlobalActions.get(ActionFactory.COPY.getId()));
        menuManager.add((IAction)this.fGlobalActions.get(ActionFactory.PASTE.getId()));
        menuManager.add((IAction)this.fGlobalActions.get(ActionFactory.SELECT_ALL.getId()));
        menuManager.add((IContributionItem)new Separator("FIND"));
        menuManager.add((IAction)this.fGlobalActions.get(ActionFactory.FIND.getId()));
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    protected void setGlobalAction(IActionBars actionBars, String actionID, IAction action) {
        this.fGlobalActions.put(actionID, action);
        actionBars.setGlobalActionHandler(actionID, action);
    }

    protected void createContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager("#PopUp");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractActionViewPart.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        if (this.getSite() != null) {
            this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getViewer());
        }
        this.addContextMenuManager((IMenuManager)menuMgr);
    }

    public void addContextMenuManager(IMenuManager contextMenuManager) {
        if (this.fContextMenuManagers == null) {
            this.fContextMenuManagers = new ArrayList();
        }
        this.fContextMenuManagers.add(contextMenuManager);
    }

    protected abstract void fillContextMenu(IMenuManager var1);

    protected void initializeToolBar() {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        this.configureToolBar(tbm);
        this.getViewSite().getActionBars().updateActionBars();
    }

    protected abstract void configureToolBar(IToolBarManager var1);

    public abstract TextViewer getViewer();
}

