/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.util;

import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Activator;
import hiro.yoshioka.wolfdbmanager.ApplicationWorkbenchWindowAdvisor;
import java.sql.SQLException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GeneralPopUpDialog
implements Runnable {
    String title;
    String message;
    Throwable e;
    int style;
    int stackTraceCnt;
    private Shell shell;

    public GeneralPopUpDialog(Shell shell, String title, String message, int style) {
        this.shell = shell;
        this.title = title;
        this.message = message;
        this.style = style;
    }

    public GeneralPopUpDialog(Shell shell, String title, Throwable e, int style) {
        this.shell = shell;
        this.title = title;
        this.e = e;
        this.style = style;
    }

    private void addStackTrace(MultiStatus m, Throwable th) {
        SQLException se;
        ++this.stackTraceCnt;
        int cnt = 0;
        StackTraceElement[] stackTraceElementArray = th.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stack = stackTraceElementArray[n2];
            m.add((IStatus)new Status(4, Activator.getPluginId(), 4, stack.toString(), null));
            if (++cnt > 10) break;
            ++n2;
        }
        if (this.e instanceof SQLException && (se = ((SQLException)this.e).getNextException()) != null) {
            m.add((IStatus)new Status(4, Activator.getPluginId(), 4, "----- " + se.getMessage() + " -----", null));
            if (this.stackTraceCnt < 3) {
                this.addStackTrace(m, se);
            }
        }
    }

    @Override
    public void run() {
        try {
            if (this.shell == null) {
                this.shell = Display.getCurrent().getActiveShell();
            }
            if (this.e != null) {
                String lm = this.e.getLocalizedMessage();
                if (StringUtil.isEmpty((Object)lm)) {
                    lm = this.e.getMessage();
                }
                if (StringUtil.isEmpty((Object)lm)) {
                    lm = String.valueOf(this.title) + " " + this.e.getStackTrace()[0].toString();
                }
                MultiStatus m = new MultiStatus(Activator.getPluginId(), 4, lm, this.e);
                this.addStackTrace(m, this.e);
                String footer = String.format("----- [%s] [%s] -----", ApplicationWorkbenchWindowAdvisor.TITLE, this.title);
                m.add((IStatus)new Status(4, Activator.getPluginId(), 4, footer, null));
                ErrorDialog.openError((Shell)this.shell, (String)this.title, null, (IStatus)m);
                return;
            }
            switch (this.style) {
                case 2: {
                    MessageDialog.openInformation((Shell)this.shell, (String)this.title, (String)this.message);
                    break;
                }
                case 1: {
                    MessageDialog.openError((Shell)this.shell, (String)this.title, (String)this.message);
                    break;
                }
                case 4: {
                    MessageDialog.openWarning((Shell)this.shell, (String)this.title, (String)this.message);
                    break;
                }
                case 5: {
                    MessageDialog.openConfirm((Shell)this.shell, (String)this.title, (String)this.message);
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

