/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AnimatedGifCanvas
extends Canvas {
    protected Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    int imageNumber;
    private boolean isRunning = false;
    private ImageLoader loader;
    private GC canvasGC;
    private Display display;
    private int width;
    private int height;
    ExecutorService executor = Executors.newSingleThreadExecutor();
    Future future;
    static ImageData[] imageDataArray;
    static Image image;
    static Image initialImage;

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("GIFCanvasTest");
        shell.setLayout((Layout)new GridLayout(3, false));
        AnimatedGifCanvas gifc1 = new AnimatedGifCanvas((Composite)shell, "D:/hoge/rajikon.gif");
        Button startButton1 = new Button((Composite)shell, 8);
        startButton1.setText("Start");
        startButton1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnimatedGifCanvas.this.startAnimation();
            }
        });
        Button stopButton1 = new Button((Composite)shell, 8);
        stopButton1.setText("Stop");
        stopButton1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnimatedGifCanvas.this.stopAnimation();
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public AnimatedGifCanvas(Composite parent, String filename) {
        super(parent, 0);
        this.loader = new ImageLoader();
        imageDataArray = this.loader.load(filename);
        this.width = this.loader.logicalScreenWidth;
        this.height = this.loader.logicalScreenHeight;
        this.display = parent.getDisplay();
        this.setBackground(parent.getBackground());
        this.canvasGC = new GC((Drawable)this);
        initialImage = new Image((Device)this.display, this.loader.data[0]);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setBackground(AnimatedGifCanvas.this.getBackground());
                e.gc.fillRectangle(0, 0, AnimatedGifCanvas.this.width, AnimatedGifCanvas.this.height);
                e.gc.drawImage(initialImage, 0, 0);
            }
        });
        Shell shell = parent.getShell();
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AnimatedGifCanvas.this.isRunning = false;
                AnimatedGifCanvas.this.executor.shutdown();
                e.doit = true;
            }
        });
    }

    public synchronized void startAnimation() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.future = this.executor.submit(new AnimationThread());
    }

    public synchronized void stopAnimation() {
        this.fLogger.fatal((Object)" stoppp.");
        this.isRunning = false;
        if (this.future != null && !this.future.isCancelled()) {
            this.future.cancel(false);
        }
    }

    public synchronized void dispose() {
        this.isRunning = false;
        if (image != null) {
            image.dispose();
        }
        if (this.canvasGC != null) {
            this.canvasGC.dispose();
        }
        initialImage.dispose();
        super.dispose();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(this.width, this.height, changed);
    }

    class AnimationThread
    extends Thread {
        AnimationThread() {
        }

        @Override
        public void run() {
            Image offScreenImage = new Image((Device)AnimatedGifCanvas.this.display, ((AnimatedGifCanvas)AnimatedGifCanvas.this).loader.logicalScreenWidth, ((AnimatedGifCanvas)AnimatedGifCanvas.this).loader.logicalScreenHeight);
            GC offScreenImageGC = new GC((Drawable)offScreenImage);
            Color bgcolor = AnimatedGifCanvas.this.canvasGC.getBackground();
            offScreenImageGC.setBackground(bgcolor);
            offScreenImageGC.fillRectangle(0, 0, ((AnimatedGifCanvas)AnimatedGifCanvas.this).loader.logicalScreenWidth, ((AnimatedGifCanvas)AnimatedGifCanvas.this).loader.logicalScreenHeight);
            try {
                try {
                    int imageDataIndex = 0;
                    ImageData imageData = imageDataArray[imageDataIndex];
                    if (image != null && !image.isDisposed()) {
                        image.dispose();
                    }
                    image = new Image((Device)AnimatedGifCanvas.this.display, imageData);
                    offScreenImageGC.drawImage(image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                    int cfr_ignored_0 = ((AnimatedGifCanvas)AnimatedGifCanvas.this).loader.repeatCount;
                    while (AnimatedGifCanvas.this.isRunning) {
                        switch (imageData.disposalMethod) {
                            case 2: {
                                Color bgColor = null;
                                offScreenImageGC.setBackground(bgColor != null ? bgColor : bgcolor);
                                offScreenImageGC.fillRectangle(imageData.x, imageData.y, imageData.width, imageData.height);
                                break;
                            }
                            case 3: {
                                offScreenImageGC.drawImage(image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                            }
                        }
                        imageDataIndex = (imageDataIndex + 1) % imageDataArray.length;
                        imageData = imageDataArray[imageDataIndex];
                        if (image != null && !image.isDisposed()) {
                            image.dispose();
                        }
                        image = new Image((Device)AnimatedGifCanvas.this.display, imageData);
                        offScreenImageGC.drawImage(image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                        AnimatedGifCanvas.this.canvasGC.drawImage(offScreenImage, 0, 0);
                        try {
                            int ms = imageData.delayTime * 10;
                            if (ms < 20) {
                                ms += 30;
                            }
                            if (ms < 30) {
                                ms += 10;
                            }
                            Thread.sleep(ms);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (imageDataIndex != imageDataArray.length - 1) continue;
                    }
                }
                catch (Throwable ex) {
                    AnimatedGifCanvas.this.fLogger.warn((Object)ex);
                    if (offScreenImage != null && !offScreenImage.isDisposed()) {
                        offScreenImage.dispose();
                    }
                    if (offScreenImageGC != null && !offScreenImageGC.isDisposed()) {
                        offScreenImageGC.dispose();
                    }
                    if (image != null && !image.isDisposed()) {
                        image.dispose();
                    }
                }
            }
            finally {
                if (offScreenImage != null && !offScreenImage.isDisposed()) {
                    offScreenImage.dispose();
                }
                if (offScreenImageGC != null && !offScreenImageGC.isDisposed()) {
                    offScreenImageGC.dispose();
                }
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        }
    }
}

