/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.action;

import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.util.ConnectionSettingDialog;
import hiro.yoshioka.ui.action.Messages;
import hiro.yoshioka.ui.action.SQLAction;
import hiro.yoshioka.ui.view.ExplorerView;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public class TransactionAction
extends SQLAction {
    ExplorerView view;
    static String TEXT = Messages.getString("TransactionAction.text");
    static String TOOL_TIP = Messages.getString("TransactionAction.tooltip");

    public TransactionAction(ExplorerView view, ConnectionProperties connectionProperties) {
        super(SQLOperationType.COMMIT, 1, connectionProperties);
        this.view = view;
        this.configureAction(TEXT, TOOL_TIP, ImageUtil.getImageDescriptor((String)"action/43go.gif"));
    }

    public TransactionAction() {
        super(SQLOperationType.CONNECT, 1, null);
        this.configureAction(TEXT, TOOL_TIP, ImageUtil.getImageDescriptor((String)"action/43go.gif"));
    }

    @Override
    public void run() {
        try {
            this.setEnabled(false);
            ConnectionSettingDialog dialog = null;
            List cons = null;
            cons = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionList();
            if (cons.size() == 0) {
                Application.openDialog(Messages.getString("TransactionAction.information"), Messages.getString("TransactionAction.infomation_text"), 2);
                return;
            }
            dialog = new ConnectionSettingDialog(Display.getCurrent().getActiveShell(), cons, this.connectionProperties, 2);
            int ret = dialog.open();
            if (ret == 500) {
                this.connectionProperties = dialog.getSelectedConnectionProperties();
                this.fOperation = SQLOperationType.COMMIT;
            } else if (ret == 600) {
                this.connectionProperties = dialog.getSelectedConnectionProperties();
                this.fOperation = SQLOperationType.ROLLBACK;
            } else {
                return;
            }
            try {
                this.fRequest = new Request(this.fOperation, this.connectionProperties);
                this.fRequest.addListener((IRequestListener)this);
                SQLServerThread.putRequest((Request)this.fRequest);
            }
            catch (RuntimeException e) {
                this.fLogger.error((Object)"", (Throwable)e);
            }
        }
        finally {
            if (this.finalClearConnectionFlg) {
                this.connectionProperties = null;
            }
            this.setEnabled(true);
        }
    }

    @Override
    public void called_done(Request request, SQLOperationType operation, ConnectionProperties properteis, Object o) {
        Application.setStatus(String.format(Messages.getString("TransactionAction.result"), new Date(), properteis.getDisplayString(), operation.name(), request.result));
        Throwable ex = this.fRequest.getException();
        if (ex != null) {
            Application.openErrorDialog(null, String.format(Messages.getString("TransactionAction.error_result"), properteis.getDisplayString()), ex);
        }
    }
}

