/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.ast.sql.util.ASTFormatingInfo;
import hiro.yoshioka.preferences.DBConnectionInitialItem;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Activator;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class PreferenceUtil {
    protected static Log fLogger = LogFactory.getLog(PreferenceUtil.class.getClass());
    private static DBRoot fDefaultRoot;
    private static DBRoot fDefaultEditorRoot;
    private static HashMap<String, Color> disposeColorMap;

    static {
        disposeColorMap = new HashMap();
    }

    public static Properties getHSQLMirrorConnectProperties() {
        Properties properties = new Properties();
        properties.put("url", "jdbc:hsqldb:hsql://127.0.0.1:" + PreferenceUtil.getString("HSQL_PORT"));
        properties.put("user", "sa");
        properties.put("password", "");
        return properties;
    }

    public static Properties getConnectProperties(DBConnectionInitialItem item) {
        if (item != null) {
            Properties properties = new Properties();
            properties.put("url", item.fURL);
            properties.put("user", item.fUser);
            properties.put("password", item.fPassWord);
            if (item.fInternalLogon != null && item.fInternalLogon.trim().length() != 0) {
                properties.put("internal_logon", item.fInternalLogon);
            }
            return properties;
        }
        return null;
    }

    public static FontData getFont(String string) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        try {
            if (store.contains(string)) {
                return PreferenceConverter.getFontDataArray((IPreferenceStore)store, (String)string)[0];
            }
        }
        catch (Exception e) {
            fLogger.error((Object)("getInt[" + string + "]store[" + store + "]"), (Throwable)e);
        }
        return PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)store, (String)string)[0];
    }

    public static int getInt(String string) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        try {
            if (store.contains(string)) {
                return store.getInt(string);
            }
        }
        catch (Exception e) {
            fLogger.error((Object)("getInt[" + string + "]store[" + store + "]"), (Throwable)e);
        }
        return store.getDefaultInt(string);
    }

    public static Color getColor(String key, Display display) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return PreferenceUtil.createColor(store, key, display);
    }

    public static boolean getBoolean(String string) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        try {
            if (store.contains(string)) {
                return store.getBoolean(string);
            }
        }
        catch (Exception e) {
            fLogger.error((Object)("getBooleant[" + string + "]store[" + store + "]"), (Throwable)e);
        }
        return store.getDefaultBoolean(string);
    }

    public static TemplateStore getTemplateStore() {
        TemplateStore tm;
        block11: {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            tm = new TemplateStore(store, "SQL_TEMPLATES");
            try {
                tm.load();
                if (tm.getTemplates().length != 0) break block11;
                try {
                    TemplateReaderWriter reader = new TemplateReaderWriter();
                    BufferedInputStream input = new FileUtil(PreferenceUtil.class, "templates.xml").getStream();
                    try {
                        TemplatePersistenceData[] datas = reader.read((InputStream)input, null);
                        int i = 0;
                        while (i < datas.length) {
                            TemplatePersistenceData data = datas[i];
                            tm.add(data);
                            ++i;
                        }
                        tm.save();
                    }
                    catch (Throwable throwable) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tm;
    }

    public static String getString(String string) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store.contains(string)) {
            return store.getString(string);
        }
        return store.getDefaultString(string);
    }

    public static String getString(String string, boolean asDefault) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store.contains(string)) {
            if (store.isDefault(string) || asDefault) {
                return store.getDefaultString(string);
            }
            return store.getString(string);
        }
        return null;
    }

    public static RGB getRGB(String key) {
        return PreferenceUtil.getRGB(key, false);
    }

    public static RGB getRGB(String key, boolean asDefault) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store.contains(key)) {
            if (store.isDefault(key) || asDefault) {
                return PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
            }
            return PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        }
        return null;
    }

    public static Object copyObject(Object target) {
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        Object newObject = null;
        try {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                out = new ObjectOutputStream(bout);
                out.writeObject(target);
                out.flush();
                byte[] bytes = bout.toByteArray();
                in = new ObjectInputStream(new ByteArrayInputStream(bytes));
                newObject = in.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return newObject;
    }

    public static boolean saveXML(File f, Object saveObject) {
        XMLEncoder encoder = null;
        try {
            fLogger.info((Object)("save file->" + f));
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader newLoader = PreferenceUtil.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(newLoader);
            encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(f)));
            encoder.writeObject(saveObject);
            encoder.close();
            Thread.currentThread().setContextClassLoader(oldLoader);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Object readObjectXML(File f) {
        XMLDecoder decoder = null;
        try {
            decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(f)));
            Object object = decoder.readObject();
            return object;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            decoder.close();
        }
        return null;
    }

    public static boolean save(File f, Object saveObject) throws IOException {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(f));
            out.writeObject(saveObject);
            return true;
        }
        catch (Exception e) {
            fLogger.error((Object)e);
            return false;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * Loose catch block
     */
    public static Object readObject(BufferedInputStream stream) {
        Object object;
        ObjectInputStream in;
        block11: {
            in = null;
            in = new ObjectInputStream(stream);
            object = in.readObject();
            if (in == null) break block11;
            try {
                in.close();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return object;
        catch (Exception e) {
            block12: {
                try {
                    fLogger.error((Object)"Deserialize error", (Throwable)e);
                    if (in == null) break block12;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static Object readObject(File f) {
        ObjectInputStream in;
        block16: {
            block14: {
                Object object;
                block15: {
                    in = null;
                    if (!f.exists() || !f.isFile()) break block14;
                    in = new ObjectInputStream(new FileInputStream(f));
                    object = in.readObject();
                    if (in == null) break block15;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
                return object;
            }
            fLogger.trace((Object)("File Not Found or Not File [" + f.getAbsolutePath() + "]"));
            if (in == null) break block16;
            try {
                in.close();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
        catch (Exception exception) {
            block17: {
                try {
                    fLogger.trace((Object)"Deserialize error");
                    if (in == null) break block17;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return null;
        }
    }

    public static File getFileByString(String filename) {
        return new File(PreferenceUtil.getString(filename));
    }

    public static ASTFormatingInfo getFormatterInfo(String input) {
        ASTFormatingInfo info = new ASTFormatingInfo(input);
        info.setIndentInfo(PreferenceUtil.getBoolean("BOOLEAN_INDENT_BY_TAB"), PreferenceUtil.getInt("INDENT_NUM"));
        info.col_num = PreferenceUtil.getInt("COLUMN_NUM");
        info.mode = PreferenceUtil.getInt("COLUMN_MODE") + 1;
        info.left = PreferenceUtil.getBoolean("BOOLEAN_ALIGHN_LEFT");
        info.setExpandDecode(PreferenceUtil.getBoolean("BOOLEAN_DECODE_CARE"));
        info.setContinuingBlank2aBlank(PreferenceUtil.getBoolean("BOOLEAN_CONTINUING_BLANK_2_BLANK"));
        info.setSelectColumnCommentOn(PreferenceUtil.getBoolean("BOOLEAN_LEAVE_COLUMN_COMMENT"));
        info.max_col_len = 180;
        return info;
    }

    private static Color createColor(IPreferenceStore store, String key, Display display) {
        if (disposeColorMap.containsKey(key)) {
            return disposeColorMap.get(key);
        }
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            Color c = new Color((Device)display, rgb);
            disposeColorMap.put(key, c);
            return c;
        }
        return null;
    }

    public static void setInt(String key, int state) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue(key, state);
    }

    public static void setRGBString(String key, RGB rgb) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue(key, String.valueOf(rgb.red) + "," + rgb.green + "," + rgb.blue);
    }

    public static void setString(String key, String value) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue(key, value);
    }

    public static void setBoolean(String key, boolean value) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue(key, value);
    }

    public static Color getStatusForeground() {
        String str = PreferenceUtil.getString("STATUS_FORE_COLOR");
        if ("Black".equals(str)) {
            return ColorConstants.black;
        }
        if ("Red".equals(str)) {
            return ColorConstants.red;
        }
        if ("White".equals(str)) {
            return ColorConstants.white;
        }
        return null;
    }

    public static String[] getExternalJars() {
        String str = PreferenceUtil.getString("RHINO_EXTERNAL_JARS");
        if (StringUtil.isEmpty((Object)str)) {
            return null;
        }
        return str.split("" + File.pathSeparatorChar);
    }
}

