/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.job.AbsBasicPoiWriter;
import hiro.yoshioka.preferences.AbsDDL;
import hiro.yoshioka.preferences.ExcelDefData;
import hiro.yoshioka.util.StringUtil;
import java.io.File;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public class DDL
extends AbsDDL {
    public DDL(ExcelDefData excelDefData) {
        super(excelDefData);
    }

    @Override
    public String doWork() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.fExcelDefData.files.length) {
            try {
                if (this.fExcelDefData.files[i].isFile()) {
                    String text = this.createDDL(this.fExcelDefData.files[i]);
                    buf.append(text);
                    buf.append(StringUtil.LINE_SEPARATOR);
                }
            }
            catch (Exception e) {
                this.fLogger.error((Object)"", (Throwable)e);
            }
            ++i;
        }
        return buf.toString();
    }

    private String createDDL(File file) {
        MyPoi poi = new MyPoi(file);
        return poi.createDDL();
    }

    class MyPoi
    extends AbsBasicPoiWriter {
        public MyPoi(File file) {
            super(file);
            this.init();
        }

        public String createDDL() {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < this.fHSSFWorkbook.getNumberOfSheets()) {
                this.setName(buf, this.fHSSFWorkbook.getSheetAt(i));
                ++i;
            }
            return buf.toString();
        }

        public String setName(StringBuilder buf, HSSFSheet sheet) {
            HashMap<String, String> dobleCheck = new HashMap<String, String>();
            StringBuilder p_buf = new StringBuilder();
            HSSFCell cell = this.getHSSFCellByA1(sheet, DDL.this.fExcelDefData.fPhysicalTableName);
            buf.append(String.format("DROP TABLE %s;%s", this.getCellString(cell), StringUtil.LINE_SEPARATOR));
            buf.append(String.format("CREATE TABLE %s (%s", this.getCellString(cell), StringUtil.LINE_SEPARATOR));
            int j = DDL.this.fExcelDefData.fStartLine;
            while (j < sheet.getLastRowNum()) {
                block21: {
                    block20: {
                        String name;
                        block19: {
                            block18: {
                                block17: {
                                    HSSFRow row = sheet.getRow(j);
                                    if (row != null) break block17;
                                    buf.append(",\r\n");
                                    break block21;
                                }
                                cell = this.getHSSFCellByA1(sheet, DDL.this.fExcelDefData.fPhysicalColumnName, j + 1);
                                name = this.getCellString(cell);
                                if (name.length() != 0) break block18;
                                buf.append(",\r\n");
                                break block21;
                            }
                            if (dobleCheck.get(name) == null) break block19;
                            buf.append(",\r\n");
                            break block21;
                        }
                        try {
                            try {
                                dobleCheck.put(name, name);
                                if (name.equals("COUNT")) {
                                    buf.append("  \"COUNT\"");
                                } else if (name.equals("BINARY")) {
                                    buf.append("  \"BINARY\"");
                                } else {
                                    buf.append("  ").append(name);
                                }
                                if (!StringUtil.isEmpty((Object)DDL.this.fExcelDefData.fDataType)) {
                                    cell = this.getHSSFCellByA1(sheet, DDL.this.fExcelDefData.fDataType, j + 1);
                                    String type = this.getCellString(cell);
                                    buf.append(" ").append(type);
                                }
                                if (!StringUtil.isEmpty((Object)DDL.this.fExcelDefData.fSize) && this.getCellString(cell = this.getHSSFCellByA1(sheet, DDL.this.fExcelDefData.fSize, j + 1)).length() > 0) {
                                    buf.append("(").append(this.getCellString(cell).replaceAll("(\\d+)[.]\\d+", "$1")).append(") ");
                                }
                                if (StringUtil.isEmpty((Object)DDL.this.fExcelDefData.fPk)) break block20;
                                cell = this.getHSSFCellByA1(sheet, DDL.this.fExcelDefData.fPk, j + 1);
                                if (this.getCellString(cell).length() > 0) {
                                    if (p_buf.length() > 0) {
                                        p_buf.append(",");
                                    }
                                    p_buf.append(name);
                                    break block20;
                                }
                                if (StringUtil.isEmpty((Object)DDL.this.fExcelDefData.fNn) || this.getCellString(cell = this.getHSSFCellByA1(sheet, DDL.this.fExcelDefData.fNn, j + 1)).length() <= 0) break block20;
                                buf.append(" NOT NULL");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                buf.append(",\r\n");
                            }
                        }
                        catch (Throwable throwable) {
                            buf.append(",\r\n");
                            throw throwable;
                        }
                    }
                    buf.append(",\r\n");
                }
                ++j;
            }
            if (p_buf.length() > 0) {
                buf.append("  PRIMARY KEY(").append((CharSequence)p_buf).append(")\r\n");
            }
            buf.append(");\r\n");
            return buf.toString();
        }
    }
}

