/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.job.AbsBasicPoiWriter;
import hiro.yoshioka.preferences.AbsDDL;
import hiro.yoshioka.preferences.ExcelDefData;
import hiro.yoshioka.util.StringUtil;
import java.io.File;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public class CommentDDL
extends AbsDDL {
    public CommentDDL(ExcelDefData excelDefData) {
        super(excelDefData);
    }

    @Override
    public String doWork() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.fExcelDefData.files.length) {
            try {
                if (this.fExcelDefData.files[i].isFile()) {
                    String text = this.createComment(this.fExcelDefData.files[i]);
                    buf.append(text);
                    buf.append(StringUtil.LINE_SEPARATOR);
                }
            }
            catch (Exception e) {
                this.fLogger.error((Object)"", (Throwable)e);
            }
            ++i;
        }
        return buf.toString();
    }

    private String createComment(File file) {
        MyPoi poi = new MyPoi(file);
        return poi.createDDL();
    }

    class MyPoi
    extends AbsBasicPoiWriter {
        public MyPoi(File file) {
            super(file);
            this.init();
        }

        public void setName(StringBuilder buf, HSSFSheet sheet) {
            HashMap<String, String> dobleCheck = new HashMap<String, String>();
            HSSFCell cell = this.getHSSFCellByA1(sheet, CommentDDL.this.fExcelDefData.fLogicalTableName);
            String comment = this.getCellString(cell);
            cell = this.getHSSFCellByA1(sheet, CommentDDL.this.fExcelDefData.fPhysicalTableName);
            String tableName = this.getCellString(cell);
            if (tableName != null) {
                buf.append(String.format("COMMENT ON TABLE %s IS '%s';", tableName, comment));
                buf.append(StringUtil.LINE_SEPARATOR);
                int j = 4;
                while (j < sheet.getLastRowNum()) {
                    block4: {
                        try {
                            cell = this.getHSSFCellByA1(sheet, CommentDDL.this.fExcelDefData.fPhysicalColumnName, j + 1);
                            String name = this.getCellString(cell);
                            if (name.length() == 0 || dobleCheck.get(name) != null) break block4;
                            dobleCheck.put(name, name);
                            cell = this.getHSSFCellByA1(sheet, CommentDDL.this.fExcelDefData.fLogicalColumnName, j + 1);
                            comment = this.getCellString(cell);
                            buf.append(String.format("COMMENT ON COLUMN %s.%s IS '%s';", tableName, name, comment));
                            buf.append(StringUtil.LINE_SEPARATOR);
                        }
                        catch (NullPointerException nullPointerException) {
                            break;
                        }
                    }
                    ++j;
                }
            }
        }

        public String createDDL() {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < this.fHSSFWorkbook.getNumberOfSheets()) {
                try {
                    this.setName(buf, this.fHSSFWorkbook.getSheetAt(i));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            return buf.toString();
        }
    }
}

