/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import hiro.yoshioka.sdh.BindObject;
import hiro.yoshioka.sql.engine.DataGenerateRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DataInsertFromGeneratorsJob
extends Job {
    protected transient Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    List<Map<String, BindObject>> insertMapList;
    String tableName;
    ConnectionProperties con_prop;

    public DataInsertFromGeneratorsJob(List<Map<String, BindObject>> insertMapList, String tableName, ConnectionProperties con_prop) {
        super("Data Insert");
        this.insertMapList = insertMapList;
        this.tableName = tableName;
        this.con_prop = con_prop;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus ret = Status.CANCEL_STATUS;
        try {
            try {
                int total = this.insertMapList.size();
                int success = 0;
                int failure = 0;
                this.fLogger.info((Object)"start data insert.");
                monitor.beginTask("connect", total + 1);
                SQLServerThread.getSQLServer();
                if (!this.con_prop.isConnected()) {
                    SQLServerThread.runNowThisRequest((Request)new Request(SQLOperationType.CONNECT, this.con_prop));
                }
                monitor.worked(1);
                monitor.setTaskName("Insert into " + this.tableName);
                for (Map<String, BindObject> insertValuesMap : this.insertMapList) {
                    if (monitor.isCanceled()) break;
                    DataGenerateRequest dreq = new DataGenerateRequest(this.con_prop, this.tableName, insertValuesMap);
                    if (SQLServerThread.runNowThisRequest((Request)dreq)) {
                        ++success;
                    } else {
                        ++failure;
                    }
                    monitor.worked(1);
                    monitor.setTaskName(String.format("TOTAL:%d SUCESS:%d FAILURE:%d", total, success, failure));
                }
                this.fLogger.trace((Object)("ret=" + ret));
            }
            catch (Throwable e) {
                this.fLogger.fatal((Object)"", e);
                ret = Status.CANCEL_STATUS;
                this.fLogger.info((Object)"end data insert.");
            }
        }
        finally {
            this.fLogger.info((Object)"end data insert.");
        }
        return ret;
    }
}

