/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.generator.usingrdh;

import hiro.yoshioka.generator.FormatArg;
import hiro.yoshioka.generator.FormatArgType;
import hiro.yoshioka.util.ColorNameEnum;
import hiro.yoshioka.util.ColorUtil;
import hiro.yoshioka.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class MyFormatterDialog
extends Dialog {
    final int numOfDigit;
    String formatString;
    String defaultString;
    String message = "< java.lang.String#format(format,args...) >";
    Label validationLabel;
    List<FormatArg> argList;
    Text formatTxt;
    ListViewer argsListViewer;
    Label formatedLb;
    boolean isThisLineOnly;
    Button btThisRow;
    Button btAdd;
    Button btDel;

    public MyFormatterDialog(Shell parentShell, String formatString, String defaultString, int numOfDigit, List<FormatArg> argList) {
        super(parentShell);
        this.formatString = formatString;
        this.defaultString = defaultString;
        this.numOfDigit = numOfDigit;
        this.argList = argList;
        if (this.argList == null || this.argList == Collections.EMPTY_LIST) {
            this.argList = new ArrayList<FormatArg>();
        }
    }

    public boolean isThisLineOnly() {
        return this.isThisLineOnly;
    }

    protected void okPressed() {
        this.formatString = this.formatTxt.getText();
        this.isThisLineOnly = this.btThisRow.getSelection();
        super.okPressed();
    }

    public List<FormatArg> getArgList() {
        return this.argList;
    }

    public String getInitialFormatString() {
        return this.formatString;
    }

    private void refresh() {
        String errorMessage = "";
        this.argsListViewer.refresh();
        try {
            Object[] args = new Object[this.argList.size()];
            int j = 0;
            while (j < args.length) {
                FormatArg arg = this.argList.get(j);
                switch (arg.type) {
                    case DATE: {
                        args[j] = new Date();
                        break;
                    }
                    case RANDOM: {
                        Random rand = new Random();
                        args[j] = Math.abs(rand.nextInt(arg.maxValue));
                        break;
                    }
                    default: {
                        args[j] = new Integer(1);
                    }
                }
                ++j;
            }
            String result = String.format(this.formatTxt.getText(), args);
            this.formatedLb.setText(result);
        }
        catch (Exception e) {
            this.formatedLb.setText(" < Error > ");
            errorMessage = e.getMessage();
        }
        Button okButton = this.getButton(0);
        if (StringUtil.isEmpty((Object)errorMessage)) {
            this.validationLabel.setText("success");
            this.validationLabel.setForeground(ColorUtil.getColor((ColorNameEnum)ColorNameEnum.BLACK));
            this.formatedLb.setForeground(ColorUtil.getColor((ColorNameEnum)ColorNameEnum.BLACK));
        } else {
            this.validationLabel.setText(errorMessage);
            this.validationLabel.setForeground(ColorUtil.getColor((ColorNameEnum)ColorNameEnum.CHANGE));
            this.formatedLb.setForeground(ColorUtil.getColor((ColorNameEnum)ColorNameEnum.CHANGE));
        }
        if (okButton != null) {
            okButton.setEnabled(StringUtil.isEmpty((Object)errorMessage));
        }
    }

    private void restoreDefault() {
        this.formatTxt.setText(this.defaultString);
        this.argList.clear();
        this.refresh();
    }

    private void setCounters() {
        this.argList.clear();
        if (this.numOfDigit > 7) {
            this.formatTxt.setText("%3d%03d%03d");
            this.argList.add(new FormatArg(FormatArgType.GROUP_COUNTER, 0, Integer.MAX_VALUE));
            this.argList.add(new FormatArg(FormatArgType.GROUP_IN_COUNTER, 0, Integer.MAX_VALUE));
            this.argList.add(new FormatArg(FormatArgType.TOTAL_COUNTER, 0, Integer.MAX_VALUE));
        } else if (this.numOfDigit > 4) {
            this.formatTxt.setText("%d%03d");
            this.argList.add(new FormatArg(FormatArgType.GROUP_COUNTER, 0, Integer.MAX_VALUE));
            this.argList.add(new FormatArg(FormatArgType.GROUP_IN_COUNTER, 0, Integer.MAX_VALUE));
        } else {
            this.formatTxt.setText("%d");
            this.argList.add(new FormatArg(FormatArgType.TOTAL_COUNTER, 0, Integer.MAX_VALUE));
        }
        this.refresh();
    }

    private void setRandom() {
        this.formatTxt.setText("%d");
        this.argList.clear();
        int max = (int)(Math.pow(10.0, this.numOfDigit) - 1.0);
        this.argList.add(new FormatArg(FormatArgType.RANDOM, 0, max));
        this.refresh();
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(c, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        main.setLayoutData((Object)new GridData(1808));
        new Label(main, 0).setText("Easy setting:");
        Composite btnEasy = new Composite(main, 0);
        btnEasy.setLayout((Layout)new FillLayout());
        btnEasy.setLayoutData((Object)new GridData(768));
        Button btDefault = new Button(btnEasy, 8);
        btDefault.setText("Restore Default");
        btDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MyFormatterDialog.this.restoreDefault();
            }
        });
        Button btCounters = new Button(btnEasy, 8);
        btCounters.setText("Set Counters");
        btCounters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MyFormatterDialog.this.setCounters();
            }
        });
        Button btRandom = new Button(btnEasy, 8);
        btRandom.setText("Set Random");
        btRandom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MyFormatterDialog.this.setRandom();
            }
        });
        new Label(main, 0).setText("Format:");
        this.formatTxt = new Text(main, 4);
        this.formatTxt.setLayoutData((Object)new GridData(768));
        this.formatTxt.setText(this.formatString);
        this.formatTxt.setMessage(this.message);
        this.formatTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MyFormatterDialog.this.refresh();
            }
        });
        new Label(main, 0).setText("Args:");
        this.argsListViewer = new ListViewer(main, 0);
        this.argsListViewer.getList().setLayoutData((Object)new GridData(768));
        this.argsListViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.argsListViewer.setInput(this.argList);
        this.argsListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MyFormatterDialog.this.btDel.setEnabled(true);
            }
        });
        new Label(main, 0).setText("Args control:");
        Composite btnC = new Composite(main, 0);
        btnC.setLayout((Layout)new FillLayout());
        btnC.setLayoutData((Object)new GridData(768));
        this.btAdd = new Button(btnC, 8);
        this.btAdd.setText("ADD");
        this.btAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MyArgDialog argDialog = new MyArgDialog(MyFormatterDialog.this.getShell());
                if (argDialog.open() == 0) {
                    FormatArg arg = new FormatArg(argDialog.type, argDialog.additionalValue, argDialog.maxValue);
                    MyFormatterDialog.this.argList.add(arg);
                    MyFormatterDialog.this.argsListViewer.refresh();
                    MyFormatterDialog.this.refresh();
                }
            }
        });
        this.btDel = new Button(btnC, 8);
        this.btDel.setText("DEL");
        this.btDel.setEnabled(false);
        this.btDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = MyFormatterDialog.this.argsListViewer.getList().getSelectionIndex();
                if (idx >= 0) {
                    MyFormatterDialog.this.argList.remove(idx);
                    MyFormatterDialog.this.argsListViewer.refresh();
                    MyFormatterDialog.this.refresh();
                    MyFormatterDialog.this.btDel.setEnabled(false);
                }
            }
        });
        new Label(main, 0).setText("Sample:");
        Text argsSampleTxt = new Text(main, 12);
        argsSampleTxt.setText("Format{hoge_%05d} arg{123} // -> hoge_00123");
        argsSampleTxt.setLayoutData((Object)new GridData(768));
        new Label(main, 0).setText("Syntax:");
        Link link = new Link(main, 0);
        link.setText("<a>click</a>");
        link.setLayoutData((Object)new GridData(768));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String url = "http://docs.oracle.com/javase/6/docs/api/java/util/Formatter.html#syntax";
                Program.launch((String)url);
            }
        });
        new Label(main, 0).setText("Formated:");
        this.formatedLb = new Label(main, 0);
        this.formatedLb.setText("");
        this.formatedLb.setLayoutData((Object)new GridData(768));
        new Label(main, 0).setText("Target row:");
        Composite g = new Composite(main, 0);
        g.setLayout((Layout)new FillLayout());
        g.setLayoutData((Object)new GridData(768));
        this.btThisRow = new Button(g, 16);
        this.btThisRow.setText("This row");
        this.btThisRow.setSelection(true);
        Button btAllRows = new Button(g, 16);
        btAllRows.setText("All rows");
        new Label(main, 0).setText("Validation:");
        this.validationLabel = new Label(main, 0);
        this.validationLabel.setLayoutData((Object)new GridData(768));
        this.refresh();
        return c;
    }

    class ListContentProvider
    implements IStructuredContentProvider {
        List fContents;

        public Object[] getElements(Object input) {
            if (this.fContents != null && this.fContents == input) {
                return this.fContents.toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fContents = newInput instanceof List ? (List)newInput : null;
        }

        public void dispose() {
        }

        public boolean isDeleted(Object o) {
            return this.fContents != null && !this.fContents.contains(o);
        }
    }

    class MyArgDialog
    extends Dialog {
        Combo typeCombo;
        Spinner additionalSpinner;
        Spinner maxSpinner;
        FormatArgType type;
        Integer additionalValue;
        Integer maxValue;

        public MyArgDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void okPressed() {
            this.type = (FormatArgType)((Object)this.typeCombo.getData(this.typeCombo.getText()));
            this.additionalValue = this.additionalSpinner.getSelection();
            this.maxValue = this.maxSpinner.getSelection();
            super.okPressed();
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = (Composite)super.createDialogArea(parent);
            Composite main = new Composite(c, 0);
            main.setLayout((Layout)new GridLayout(2, false));
            main.setLayoutData((Object)new GridData(1808));
            new Label(main, 0).setText("TYPE:");
            this.typeCombo = new Combo(main, 8);
            this.typeCombo.setLayoutData((Object)new GridData(768));
            FormatArgType[] formatArgTypeArray = FormatArgType.values();
            int n = formatArgTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FormatArgType type = formatArgTypeArray[n2];
                this.typeCombo.add(type.getMessage());
                this.typeCombo.setData(type.getMessage(), (Object)type);
                ++n2;
            }
            Label addLb = new Label(main, 0);
            addLb.setText("+");
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            addLb.setLayoutData((Object)gd);
            new Label(main, 0).setText("Additional value:");
            this.additionalSpinner = new Spinner(main, 0);
            this.additionalSpinner.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 5);
            this.additionalSpinner.setLayoutData((Object)new GridData(768));
            new Label(main, 0).setText("(Max value):");
            this.maxSpinner = new Spinner(main, 0);
            this.maxSpinner.setValues(0, 0, Integer.MAX_VALUE, 0, 1, 5);
            this.maxSpinner.setLayoutData((Object)new GridData(768));
            return c;
        }
    }
}

