/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.generator.usingrdh;

import hiro.yoshioka.generator.formatter.ColumnGenerateFormat;
import hiro.yoshioka.generator.formatter.GenerateFormatDef;
import hiro.yoshioka.generator.formatter.IFormattersConstant;
import hiro.yoshioka.generator.usingrdh.FormatInfRow;
import hiro.yoshioka.generator.usingrdh.MyFormatterDialog;
import hiro.yoshioka.generator.usingrdh.RDHCustomizedWizard;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

class ColumnDefPage
extends WizardPage
implements IFormattersConstant {
    private static String FMT_TITLE = "Define [%s] Format";
    TableViewer tableViewer;
    ColumnGenerateFormat data;

    protected ColumnDefPage(ColumnGenerateFormat data) {
        super(String.format(FMT_TITLE, data.getColumn().getName()));
        this.data = data;
        this.setTitle(String.format(FMT_TITLE, data.getColumn().getName()));
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridData gd0 = new GridData(1808);
        gd0.widthHint = 680;
        gd0.heightHint = 200;
        c.setLayoutData((Object)gd0);
        c.setLayout((Layout)new FillLayout());
        Table table0 = new Table(c, 68352);
        table0.setHeaderVisible(true);
        this.tableViewer = new TableViewer(table0);
        int i = 0;
        while (i < COLUMN_HEADERS.length) {
            TableColumn col = new TableColumn(table0, 0);
            col.setText(COLUMN_HEADERS[i]);
            col.setWidth(COLUMN_HEADERS_WIDTH[i]);
            ++i;
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new MyContentProvider());
        this.tableViewer.setColumnProperties(COLUMN_HEADERS);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                int idx = ColumnDefPage.this.tableViewer.getTable().getSelectionIndex();
                GenerateFormatDef def = ColumnDefPage.this.data.getGenerateFormatDefs()[idx];
                MyFormatterDialog dialog = new MyFormatterDialog(Display.getDefault().getActiveShell(), def.getFormat(), def.getInitiaFormat(), ColumnDefPage.this.data.getColumn().getSize(), def.getFmtArgTypeList());
                if (dialog.open() == 0) {
                    if (dialog.isThisLineOnly()) {
                        GenerateFormatDef m_def = ColumnDefPage.this.data.getGenerateFormatDefs()[idx];
                        m_def.setFormat(dialog.getInitialFormatString());
                        m_def.setFormatArgList(dialog.getArgList());
                    } else {
                        GenerateFormatDef[] generateFormatDefArray = ColumnDefPage.this.data.getGenerateFormatDefs();
                        int n = generateFormatDefArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            GenerateFormatDef m_def = generateFormatDefArray[n2];
                            m_def.setFormat(dialog.getInitialFormatString());
                            m_def.setFormatArgList(dialog.getArgList());
                            ++n2;
                        }
                    }
                    ColumnDefPage.this.refreshTable(false);
                }
            }
        });
        this.tableViewer.getTable().setLinesVisible(true);
        RDHCustomizedWizard wiz = (RDHCustomizedWizard)this.getWizard();
        if (wiz.rdh == null) {
            this.tableViewer.setInput((Object)this.data);
        } else {
            this.refreshTable(true);
        }
        this.setControl((Control)c);
    }

    public void refreshTable(boolean initializeWithRdh) {
        if (initializeWithRdh) {
            try {
                RDHCustomizedWizard wiz = (RDHCustomizedWizard)this.getWizard();
                this.data.resetRdh(wiz.rdh);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)this.data);
        }
    }

    private class MyContentProvider
    implements IStructuredContentProvider {
        private MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ColumnGenerateFormat) {
                return ((ColumnGenerateFormat)inputElement).getElements();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private MyLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            try {
                FormatInfRow row = (FormatInfRow)element;
                return row.getElements()[columnIndex];
            }
            catch (Exception e) {
                e.printStackTrace();
                return "xxxxxxxxxxxxx";
            }
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex <= 2) {
                return ColorConstants.darkBlue;
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }
    }
}

