/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.generator;

import hiro.yoshioka.generator.Messages;
import hiro.yoshioka.generator.MyFormatter;
import hiro.yoshioka.generator.bean.GeneratorBean;
import hiro.yoshioka.generator.bean.GroupGeneratorBean;
import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;

public class TextFormatter
extends MyFormatter {
    static final String EXTRA_MES = Messages.getString("TextFormatter.ExtraFormatTitle");
    private boolean splitted;
    private boolean sequencial;
    private String filePath;
    private boolean reseted = true;
    private ArrayList<String> myojiList = new ArrayList();
    private ArrayList<String> nameList = new ArrayList();
    private Random random = new Random();

    public TextFormatter() {
    }

    public TextFormatter(GeneratorBean generator) {
        super(generator, null);
    }

    public boolean isSplitted() {
        return this.splitted;
    }

    public void setSplitted(boolean splitted) {
        this.splitted = splitted;
        this.reseted = true;
    }

    public boolean isSequencial() {
        return this.sequencial;
    }

    public void setSequencial(boolean sequencial) {
        this.sequencial = sequencial;
        this.reseted = true;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
        this.reseted = true;
    }

    @Override
    public String getExtraFormat() {
        return String.format(EXTRA_MES, Boolean.toString(this.sequencial), Boolean.toString(this.splitted), this.filePath);
    }

    private void reset() {
        this.reseted = false;
        this.myojiList.clear();
        this.nameList.clear();
        File f = new File(this.filePath);
        if (f.exists()) {
            String[] lines = FileUtil.getTexts((File)f);
            int i = 0;
            while (i < lines.length) {
                if (!StringUtil.isEmpty((Object)lines[i].trim())) {
                    if (this.splitted) {
                        String[] sp = lines[i].split(" ", 2);
                        this.myojiList.add(sp[0]);
                        if (sp.length <= 1) {
                            this.nameList.add("");
                        } else {
                            this.nameList.add(sp[1]);
                        }
                    } else {
                        this.myojiList.add(lines[i]);
                    }
                }
                ++i;
            }
        } else {
            String mes = String.valueOf(Messages.getString("TextFormatter.FileNotFound")) + f.getAbsolutePath() + "] AT [" + this.generator.getParent().getColumnName() + "]";
            Application.openDialog("Error", mes, 1);
        }
    }

    public String getPreviewText() {
        ArrayList<String> myojiList = new ArrayList<String>();
        ArrayList<String> nameList = new ArrayList<String>();
        String[] lines = FileUtil.getTexts((File)new File(this.filePath));
        int i = 0;
        while (i < lines.length && i < 10) {
            if (!StringUtil.isEmpty((Object)lines[i].trim())) {
                if (this.splitted) {
                    String[] sp = lines[i].split(" ", 2);
                    myojiList.add(sp[0]);
                    if (sp.length <= 1) {
                        nameList.add("");
                    } else {
                        nameList.add(sp[1]);
                    }
                } else {
                    myojiList.add(lines[i]);
                }
            }
            ++i;
        }
        StringBuilder buf = new StringBuilder();
        int i2 = 0;
        int j = 0;
        while (i2 < 20) {
            if (j >= myojiList.size()) {
                j = 0;
            }
            if (this.sequencial) {
                if (this.splitted) {
                    int mIdx = i2 / myojiList.size() % myojiList.size();
                    buf.append((String)myojiList.get(mIdx)).append(" ").append((String)nameList.get(j));
                } else {
                    buf.append((String)myojiList.get(j));
                }
            } else {
                int mi = this.random.nextInt(myojiList.size());
                if (this.splitted) {
                    buf.append((String)myojiList.get(mi)).append(" ").append((String)nameList.get(this.random.nextInt(nameList.size())));
                } else {
                    buf.append((String)myojiList.get(mi));
                }
            }
            buf.append(StringUtil.LINE_SEPARATOR);
            ++i2;
            ++j;
        }
        return buf.toString();
    }

    @Override
    public String formatedString(int sumGeneratedGroupCount, int numOfGroupInCounter, int totalCounter, Date today) {
        if (this.reseted) {
            this.reset();
        }
        StringBuilder buf = new StringBuilder();
        GroupGeneratorBean ggbean = this.generator.getParent();
        ggbean.getParent();
        int index = totalCounter % this.myojiList.size();
        if (this.sequencial) {
            if (this.splitted) {
                int mIdx = totalCounter / this.myojiList.size() % this.myojiList.size();
                buf.append(this.myojiList.get(mIdx)).append(" ").append(this.nameList.get(index));
            } else {
                buf.append(this.myojiList.get(index));
            }
        } else {
            int mi = this.random.nextInt(this.myojiList.size());
            if (this.splitted) {
                buf.append(this.myojiList.get(mi)).append(" ").append(this.nameList.get(this.random.nextInt(this.nameList.size())));
            } else {
                buf.append(this.myojiList.get(mi));
            }
        }
        return buf.toString();
    }
}

