/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.generator;

import hiro.yoshioka.generator.Messages;
import hiro.yoshioka.generator.MyFormatter;
import hiro.yoshioka.generator.RandomMode;
import hiro.yoshioka.generator.bean.GeneratorBean;
import hiro.yoshioka.sql.resource.xml.DBColumnValue;
import hiro.yoshioka.util.SQLDataType;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;

public class RandomFormatter
extends MyFormatter {
    private RandomMode mode;
    public static final String ALPHA = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String ALPHA_DIGIT = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final String HIRA_GANA = Messages.getString("RandomFormatter.hiragana");
    public static final String KATA_KANA = Messages.getString("RandomFormatter.katakana");
    private Random random = new Random();
    private int n;
    private Calendar cal = GregorianCalendar.getInstance();

    public RandomFormatter() {
    }

    public RandomFormatter(GeneratorBean generator) {
        super(generator, null);
        this.resetMode(RandomMode.DIGITAL, false);
    }

    public RandomMode getMode() {
        return this.mode;
    }

    public void setMode(RandomMode mode) {
        this.mode = mode;
    }

    public void resetMode(RandomMode mode, boolean zeroFilled) {
        DBColumnValue column = this.generator.getParent().getColumn();
        SQLDataType dataType = column.getType();
        this.mode = mode;
        if (dataType.isDate()) {
            this.format = "%tF";
            return;
        }
        if (dataType.isTimeStamp()) {
            this.format = "%tF %1$tT";
            return;
        }
        if (dataType.isTime()) {
            this.format = "%tT";
            return;
        }
        this.format = "";
        switch (mode) {
            case DIGITAL: {
                this.format = dataType.isString() && zeroFilled ? "%0" + column.getSize() + "d" : "%d";
                if (column.getSize() == 0) {
                    this.n = 9;
                    break;
                }
                if (column.getSize() >= 10) {
                    this.n = Integer.MAX_VALUE;
                    break;
                }
                this.n = (int)Math.pow(10.0, column.getSize()) - 1;
                break;
            }
            case ALPHA: 
            case ALPHA_DIGIT: {
                this.n = column.getSize();
                if (column.getSize() != 0) break;
                this.n = 9;
                break;
            }
            case KATA_KANA: 
            case HIRAGANA: {
                this.n = column.getSize();
            }
        }
    }

    @Override
    public String getExtraFormat() {
        return this.mode.getText();
    }

    @Override
    public String formatedString(int sumGeneratedGroupCount, int numOfGroupInCounter, int totalCounter, Date today) {
        String message = "";
        try {
            DBColumnValue column = this.generator.getParent().getColumn();
            SQLDataType dataType = column.getType();
            if (dataType.isDateOrDateTimeOrTime()) {
                int div = this.random.nextInt(90);
                long original = this.cal.getTimeInMillis();
                if (div % 2 == 0) {
                    this.cal.add(5, div);
                } else {
                    this.cal.add(5, -div);
                }
                message = String.format(this.format, this.cal.getTime());
                this.cal.setTimeInMillis(original);
            } else if (dataType.isBit()) {
                message = String.format(this.format, this.random.nextInt(this.n));
            } else {
                String targetStrings = null;
                switch (this.mode) {
                    case DIGITAL: {
                        message = String.format(this.format, this.random.nextInt(this.n));
                        break;
                    }
                    case ALPHA: {
                        int len = this.random.nextInt(this.n);
                        StringBuilder buf = new StringBuilder();
                        int i = 0;
                        while (i < len) {
                            buf.append(ALPHA.charAt(this.random.nextInt(ALPHA.length())));
                            ++i;
                        }
                        message = buf.toString();
                        break;
                    }
                    case ALPHA_DIGIT: {
                        int len = this.random.nextInt(this.n);
                        StringBuilder buf = new StringBuilder();
                        if (len <= 0) {
                            len = 1;
                        }
                        int i = 0;
                        while (i < len) {
                            buf.append(ALPHA_DIGIT.charAt(this.random.nextInt(ALPHA_DIGIT.length())));
                            ++i;
                        }
                        message = buf.toString();
                        break;
                    }
                    case KATA_KANA: {
                        int len;
                        targetStrings = KATA_KANA;
                        if (this.n <= 1) {
                            targetStrings = ALPHA_DIGIT;
                            len = 1;
                        } else {
                            len = this.random.nextInt(this.n / 2);
                            if (len <= 0) {
                                len = 1;
                            }
                        }
                        StringBuilder buf = new StringBuilder();
                        int i = 0;
                        while (i < len) {
                            buf.append(targetStrings.charAt(this.random.nextInt(targetStrings.length())));
                            ++i;
                        }
                        message = buf.toString();
                        break;
                    }
                    case HIRAGANA: {
                        int len;
                        targetStrings = HIRA_GANA;
                        if (this.n <= 1) {
                            targetStrings = ALPHA_DIGIT;
                            len = 1;
                        } else {
                            len = this.random.nextInt(this.n / 2);
                            if (len <= 0) {
                                len = 1;
                            }
                        }
                        StringBuilder buf = new StringBuilder();
                        int i = 0;
                        while (i < len) {
                            buf.append(targetStrings.charAt(this.random.nextInt(targetStrings.length())));
                            ++i;
                        }
                        message = buf.toString();
                        break;
                    }
                    default: {
                        message = String.format(this.format, this.random.nextInt(this.n));
                    }
                }
            }
            message = this.formatedString(message, column);
        }
        catch (Throwable e) {
            this.fLogger.warn((Object)e);
            e.printStackTrace();
        }
        return message;
    }
}

