/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.tabbedview;

import hiro.yoshioka.gef.model.PropertyAwareObject;
import hiro.yoshioka.gef.part.PropertyAwarePart;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public abstract class AbsBaseSection
extends AbstractPropertySection {
    protected Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected PropertyAwareObject[] models;
    protected PropertyAwarePart[] parts;

    public void setInput(IWorkbenchPart wpart, ISelection selection) {
        super.setInput(wpart, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        ArrayList<PropertyAwareObject> list = new ArrayList<PropertyAwareObject>();
        ArrayList<PropertyAwarePart> plist = new ArrayList<PropertyAwarePart>();
        try {
            IStructuredSelection st = (IStructuredSelection)selection;
            Iterator ite = st.iterator();
            int i = 0;
            while (ite.hasNext()) {
                Object ob = ite.next();
                System.out.println("obj=" + ob);
                if (ob instanceof PropertyAwarePart) {
                    PropertyAwarePart part = (PropertyAwarePart)ob;
                    PropertyAwareObject o = (PropertyAwareObject)part.getModel();
                    if (this.fLogger.isTraceEnabled()) {
                        this.fLogger.trace((Object)("model[" + i + "]=" + o));
                    }
                    if (o != null) {
                        list.add(o);
                        plist.add(part);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.fLogger.error((Object)e);
        }
        this.models = list.toArray(new PropertyAwareObject[list.size()]);
        this.parts = plist.toArray(new PropertyAwarePart[plist.size()]);
        if (this.fLogger.isTraceEnabled()) {
            this.fLogger.trace((Object)("models.length=" + this.models.length));
        }
    }
}

