/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.figures;

import hiro.yoshioka.sql.resource.xml.DBColumnValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ColumnLabel
extends Label {
    protected Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private boolean selected;
    DBColumnValue column;

    public ColumnLabel(DBColumnValue column) {
        super(column.getNameWithComment());
        this.column = column;
        if (column.isPkey()) {
            this.setForegroundColor(ColorConstants.red);
        } else if (column.isNotnull()) {
            this.setForegroundColor(ColorConstants.blue);
        }
    }

    private Rectangle getSelectionRectangle() {
        Rectangle bounds = this.getTextBounds().getCopy();
        bounds.expand(new Insets(2, 2, 0, 0));
        this.translateToParent((Translatable)bounds);
        bounds.intersect(this.getBounds());
        return bounds;
    }

    protected void paintFigure(Graphics graphics) {
        if (this.selected) {
            graphics.pushState();
            graphics.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            graphics.fillRectangle(this.getSelectionRectangle());
            graphics.popState();
            graphics.setForegroundColor(ColorConstants.white);
        }
        super.paintFigure(graphics);
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.repaint();
    }

    public boolean isPkey() {
        return this.column.isPkey();
    }
}

