/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerComposite;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.TableDragGuideTracker;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Cursor;

public class RowDragTracker
extends TableDragGuideTracker {
    private static final String RESIZE_COLUMN_TRANS_LABEL = Messages.getString((String)"RowDragTracker.ResizeRow");
    private static final String PREFIX_LABEL = Messages.getString((String)"RowDragTracker.Show.Label");

    public RowDragTracker(EditPart sourceEditPart, int start, int end) {
        super(sourceEditPart, start, end);
        this.setDisabledCursor(Cursors.SIZENS);
    }

    protected Cursor getDefaultCursor() {
        if (this.isCloneActive()) {
            return Cursors.SIZENS;
        }
        return super.getDefaultCursor();
    }

    protected void resize() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        int value = this.getMouseTrueValueY();
        part.getTableAdapter().transStar(RESIZE_COLUMN_TRANS_LABEL);
        if (this.isresizeMultipleRow()) {
            List list = this.filterEditPart(part.getViewer().getSelectedEditParts());
            boolean resizeTable = false;
            int height = 0;
            int i = 0;
            while (i < list.size()) {
                int tempValue = value;
                Object model = ((EditPart)list.get(i)).getModel();
                RowHandleAdapter adapter = HandleAdapterFactory.getInstance().getRowHandleAdapter(model);
                int start = adapter.getRowNumber();
                int end = start + 1;
                int ori = TableUtil.caleVisualHeight(part, model);
                int adjustHeight = TableUtil.caleVisualHeight(part, part.getRow(this.getStart())) + value;
                if (this.getStart() != start) {
                    tempValue = adjustHeight - ori;
                }
                if (start == part.getRowCount()) {
                    end = start;
                    resizeTable = true;
                } else {
                    height += this.getTrueValue(tempValue, start, end);
                }
                this.resizeRow(tempValue, start, end);
                ++i;
            }
            if (resizeTable) {
                Dimension size = part.getTableAdapter().getSize();
                try {
                    part.getTableAdapter().setSize(new Dimension(-1, size.height + height));
                }
                catch (SemanticException e) {
                    part.getTableAdapter().rollBack();
                    ExceptionHandler.handle(e);
                }
            }
        } else {
            this.resizeRow(value, this.getStart(), this.getEnd());
        }
        part.getTableAdapter().transEnd();
    }

    private void resizeRow(int value, int start, int end) {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        if (start != end) {
            value = this.getTrueValue(value, start, end);
            part.resizeRow(start, end, value);
        } else {
            Dimension dimension = this.getDragWidth(start, end);
            if (value < dimension.width) {
                value = dimension.width;
            }
            TableHandleAdapter adp = HandleAdapterFactory.getInstance().getTableHandleAdapter(part.getModel());
            Dimension dm = adp.calculateSize();
            dm.height += value;
            dm.width = -1;
            try {
                adp.ajustSize(dm);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private void resizeFixRow(int value, int start, int end) {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        Object row = part.getRow(start);
        if (!(row instanceof RowHandle)) {
            return;
        }
        int rowHeight = TableUtil.caleVisualHeight(part, row);
        try {
            double height = this.converPixToDefaultUnit(rowHeight + this.getTrueValue(value));
            DimensionValue dimensionValue = new DimensionValue(height, this.getDefaultUnits());
            ((RowHandle)row).getHeight().setValue((Object)dimensionValue);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    private boolean isresizeMultipleRow() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        List list = this.filterEditPart(part.getViewer().getSelectedEditParts());
        if (list.size() < 2) {
            return false;
        }
        Object first = ((EditPart)list.get(0)).getModel();
        if (!(first instanceof RowHandle) || !((RowHandle)first).getContainer().equals(part.getModel())) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            Object model = ((EditPart)list.get(i)).getModel();
            if (model.equals(part.getRow(this.getStart()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Rectangle getMarqueeSelectionRectangle() {
        IFigure figure = ((TableEditPart)this.getSourceEditPart()).getFigure();
        Insets insets = figure.getInsets();
        int value = this.getLocation().y - this.getStartLocation().y;
        value = this.getTrueValueAbsolute(value);
        Point p = this.getStartLocation().getCopy();
        figure.translateToAbsolute((Translatable)p);
        figure.translateToRelative((Translatable)p);
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        return new Rectangle(bounds.x + insets.left, value + p.y, bounds.width - (insets.left + insets.right), 2);
    }

    protected Dimension getDragWidth(int startNumber, int endNumber) {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        Object start = part.getRow(startNumber);
        return new Dimension(part.getMinHeight(startNumber) - this.getRowHeight(start), Integer.MAX_VALUE);
    }

    protected int getRowHeight(Object row) {
        return TableUtil.caleVisualHeight(this.getTableEditPart(), row);
    }

    protected int getRowHeight(int rowNumber) {
        Object row = this.getTableEditPart().getRow(rowNumber);
        return this.getRowHeight(row);
    }

    protected TableEditPart getTableEditPart() {
        return (TableEditPart)this.getSourceEditPart();
    }

    protected String getInfomation() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        return this.getShowLabel(TableUtil.caleVisualHeight(part, part.getRow(this.getStart())));
    }

    private String getShowLabel(int pix) {
        String unit = this.getDefaultUnits();
        double doubleValue = MetricUtility.pixelToPixelInch((int)pix);
        double showValue = DimensionUtil.convertTo((double)doubleValue, (String)"in", (String)unit).getMeasure();
        return String.valueOf(PREFIX_LABEL) + " " + this.getShowValue(showValue) + " " + this.getUnitDisplayName(unit) + " (" + pix + " " + PIXELS_LABEL + ")";
    }

    private String getShowValue(double value) {
        return FORMAT.format(value);
    }

    protected boolean handleDragInProgress() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        boolean bool = super.handleDragInProgress();
        int value = this.getTrueValue(this.getMouseTrueValueY());
        int adjustWidth = TableUtil.caleVisualHeight(part, part.getRow(this.getStart())) + value;
        this.updateInfomation(this.getShowLabel(adjustWidth));
        return bool;
    }

    protected void fitResize() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        int value = this.getMouseTrueValueY();
        part.getTableAdapter().transStar(RESIZE_COLUMN_TRANS_LABEL);
        int height = 0;
        if (this.isresizeMultipleRow()) {
            List list = this.filterEditPart(part.getViewer().getSelectedEditParts());
            int i = 0;
            while (i < list.size()) {
                int tempValue = value;
                Object model = ((EditPart)list.get(i)).getModel();
                RowHandleAdapter adapter = HandleAdapterFactory.getInstance().getRowHandleAdapter(model);
                int start = adapter.getRowNumber();
                int end = start + 1;
                int ori = TableUtil.caleVisualHeight(part, model);
                int adjustHeight = TableUtil.caleVisualHeight(part, part.getRow(this.getStart())) + value;
                if (this.getStart() != start) {
                    tempValue = adjustHeight - ori;
                }
                if (start == part.getRowCount()) {
                    end = start;
                }
                height += this.getTrueValue(tempValue, start, end);
                this.resizeFixRow(tempValue, start, end);
                ++i;
            }
        } else {
            height += this.getTrueValue(value, this.getStart(), this.getEnd());
            this.resizeFixRow(value, this.getStart(), this.getEnd());
        }
        Dimension tableSize = part.getFigure().getSize();
        try {
            if (part.getTableAdapter().isSupportHeight()) {
                ReportItemHandle handle = part.getTableAdapter().getReportItemHandle();
                double tbWidth = this.converPixToDefaultUnit(tableSize.height + height);
                DimensionValue dimensionValue = new DimensionValue(tbWidth, this.getDefaultUnits());
                handle.getHeight().setValue((Object)dimensionValue);
            }
        }
        catch (SemanticException e) {
            part.getTableAdapter().rollBack();
            ExceptionHandler.handle(e);
        }
        part.getTableAdapter().transEnd();
    }

    protected EditorRulerComposite.DragGuideInfo createDragGuideInfo() {
        int value = this.getTrueValue(this.getMouseTrueValueY());
        Point p = this.getStartLocation().getCopy();
        this.getAbstractTableEditPart().getFigure().translateToRelative((Translatable)p);
        EditorRulerComposite.DragGuideInfo info = new EditorRulerComposite.DragGuideInfo(false, value += p.y);
        return info;
    }
}

