/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.csveditor;

import hiro.yoshioka.csveditor.dialog.CSVConfigDialog;
import hiro.yoshioka.eclipse.core.CoreUtil;
import hiro.yoshioka.sdh.CDHTableViewer;
import hiro.yoshioka.sdh.CSVRecordDataHolder;
import hiro.yoshioka.sdh.StringRecordData;
import hiro.yoshioka.util.CSVUtil;
import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Set;
import jp.sf.orangesignal.csv.CsvConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class CSVRDHView
extends EditorPart {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    CDHTableViewer fViewer;
    ToolBar toolbar;
    CSVConfigDialog.MyCsvConfig config = new CSVConfigDialog.MyCsvConfig(CSVUtil.QUOTE_DOUBLE_QUOTE_SEPARATE_TAB);
    Shell shell;
    CSVRecordDataHolder fCSVRecordDataHolder;
    char latestLayout = (char)104;

    public CSVRecordDataHolder getInput() {
        return this.fCSVRecordDataHolder;
    }

    public String getInputString() {
        return this.fCSVRecordDataHolder.toCSV((CsvConfig)this.config, this.config.isWithRowColumn());
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    public int[] getSelectionIndices() {
        return this.fViewer.getTable().getSelectionIndices();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input != null) {
            this.setPartName("Sheet");
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        try {
            this.shell = parent.getShell();
            Composite mainPanel = new Composite(parent, 0);
            GridLayout gd = new GridLayout();
            gd.horizontalSpacing = 0;
            gd.marginHeight = 0;
            gd.marginWidth = 0;
            gd.verticalSpacing = 0;
            mainPanel.setLayout((Layout)gd);
            this.fViewer = new CDHTableViewer(mainPanel, 268536578);
            this.fViewer.getTable().setLayoutData((Object)new GridData(1808));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    FileEditorInput getfileEditorInput() {
        if (this.getEditorInput() instanceof FileEditorInput) {
            return (FileEditorInput)this.getEditorInput();
        }
        return null;
    }

    protected void setInput(IEditorInput input) {
        try {
            super.setInput(input);
            if (this.getEditorInput() instanceof FileEditorInput) {
                FileEditorInput fi = (FileEditorInput)this.getEditorInput();
                String target = FileUtil.getText((InputStream)fi.getFile().getContents(), (String)fi.getFile().getCharset(), (long)5000L);
                char c = CSVUtil.getFrequentlyAppearingSeparetor((String)target);
                this.config.setSeparator(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshFromEditorInput() {
        if (this.getEditorInput() instanceof FileEditorInput) {
            FileEditorInput fi = (FileEditorInput)this.getEditorInput();
            try {
                this.config.setEncoding(fi.getFile().getCharset());
                String[][] lists = CSVUtil.split((File)CoreUtil.cnvFile((IFile)fi.getFile()), (String)this.config.getEncoding(), (CsvConfig)this.config);
                this.resetCsvRecordDataHolder(lists);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void refreshFromString(String target) {
        String[][] lists = CSVUtil.split((String)target, (CsvConfig)this.config);
        this.resetCsvRecordDataHolder(lists);
    }

    private void resetCsvRecordDataHolder(String[][] lists) {
        if (lists.length > 0) {
            boolean ignoreFirstRowColumn = false;
            if (this.config.isIgnoreFirstRowColumn() && lists[0].length > 0 && "ROW".equalsIgnoreCase(lists[0][0])) {
                ignoreFirstRowColumn = true;
                lists[0] = Arrays.copyOfRange(lists[0], 1, lists[0].length);
            }
            this.fCSVRecordDataHolder = new CSVRecordDataHolder(lists[0]);
            int i = 1;
            while (i < lists.length) {
                if (ignoreFirstRowColumn) {
                    lists[i] = Arrays.copyOfRange(lists[i], 1, lists[i].length);
                }
                this.fCSVRecordDataHolder.addRow(lists[i]);
                ++i;
            }
        } else {
            this.fCSVRecordDataHolder = new CSVRecordDataHolder(StringUtil.EMPTY_STRING_ARRAY);
        }
        this.adjustHeader();
    }

    public void setFocus() {
        this.fViewer.getTable().setFocus();
    }

    public void adjustDatum() {
        try {
            this.latestLayout = (char)100;
            this.fViewer.setInputAdjustDatum(this.fCSVRecordDataHolder);
            this.fViewer.getTable().redraw();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void adjustHeader() {
        try {
            this.latestLayout = (char)104;
            this.fViewer.setInputAdjustHeader(this.fCSVRecordDataHolder);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    protected void adjustSame() {
        switch (this.latestLayout) {
            case 'a': {
                this.adjustArea();
                break;
            }
            case 'd': {
                this.adjustDatum();
                break;
            }
            default: {
                this.adjustHeader();
            }
        }
    }

    public void adjustArea() {
        try {
            this.latestLayout = (char)97;
            this.fViewer.setInputAdjustArea(this.fCSVRecordDataHolder);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void selectAll() {
        this.fViewer.getTable().selectAll();
    }

    public void lostFocus() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"focus lost");
        }
        this.fViewer.cancelEditing();
    }

    public void openConfigDialog() {
        CSVConfigDialog dialog = new CSVConfigDialog(this.shell, this.config);
        if (dialog.open() == 0) {
            this.config = dialog.getConfig();
            FileEditorInput fi = this.getfileEditorInput();
            if (fi != null) {
                try {
                    fi.getFile().setCharset(this.config.getEncoding(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            }
            this.refreshFromEditorInput();
        }
    }

    public void deleteRow() {
        int[] sels = this.getSelectionIndices();
        if (sels.length > 0) {
            if (sels.length == 1) {
                StringRecordData[] row = this.fCSVRecordDataHolder.getStringRecordRow(sels[0]);
                String message = null;
                String first = StringUtil.cutByBytes((CharSequence)row[1].getString(), (int)15, (Charset)Charset.defaultCharset());
                if (row.length >= 2) {
                    String second = StringUtil.cutByBytes((CharSequence)row[row.length - 1].getString(), (int)15, (Charset)Charset.defaultCharset());
                    message = String.format("Delete Row at [%d][%s...%s] ", sels[0] + 1, first, second);
                } else {
                    message = String.format("Delete Row at [%d][%s]", sels[0] + 1, first);
                }
                if (MessageDialog.openQuestion((Shell)this.shell, (String)"Delete Row", (String)message)) {
                    this.fCSVRecordDataHolder.deleteRow(sels[0]);
                    this.adjustSame();
                }
            } else {
                String message = "Delete Rows at [" + (sels[0] + 1);
                int i = 1;
                while (i < sels.length) {
                    message = String.valueOf(message) + "," + (sels[i] + 1);
                    ++i;
                }
                if (MessageDialog.openQuestion((Shell)this.shell, (String)"Delete Row", (String)(message = String.valueOf(message) + "]"))) {
                    i = sels.length - 1;
                    while (i >= 0) {
                        this.fCSVRecordDataHolder.deleteRow(sels[i]);
                        --i;
                    }
                    this.adjustSame();
                }
            }
        } else {
            int idx = this.fViewer.getLastSelectedRow();
            if (idx >= 0) {
                StringRecordData[] row = this.fCSVRecordDataHolder.getStringRecordRow(idx);
                String message = null;
                String first = StringUtil.cutByBytes((CharSequence)row[1].getString(), (int)15, (Charset)Charset.defaultCharset());
                if (row.length >= 2) {
                    String second = StringUtil.cutByBytes((CharSequence)row[row.length - 1].getString(), (int)15, (Charset)Charset.defaultCharset());
                    message = String.format("Delete Row at [%d][%s...%s]", idx + 1, first, second);
                } else {
                    message = String.format("Delete Row at [%d][%s]", idx + 1, first);
                }
                if (MessageDialog.openQuestion((Shell)this.shell, (String)"Delete Row", (String)message)) {
                    this.fCSVRecordDataHolder.deleteRow(idx);
                    this.adjustSame();
                }
            }
        }
    }

    public void distinct(String ... keys) {
        this.fCSVRecordDataHolder.distinct(keys);
        this.adjustSame();
    }

    public void addRow() {
        String desc;
        InsertDialog dialog;
        int idx = this.fViewer.getLastSelectedRow();
        int[] sels = this.getSelectionIndices();
        if (sels.length > 0) {
            idx = sels[0];
        }
        if (idx >= 0 && (dialog = new InsertDialog(this.shell, "addRow", desc = "Add Row at [" + (idx + 1) + "]", false)).open() == 0) {
            if (dialog.empty) {
                this.fCSVRecordDataHolder.addEmptyRow(dialog.before ? idx : idx + 1);
            }
            this.adjustSame();
        }
    }

    public void deleteColumn() {
        int idx = this.fViewer.getLastSelectedColumn();
        if (idx >= 0 && MessageDialog.openQuestion((Shell)this.shell, (String)"Delete Column", (String)("Delete column at [" + (idx + 1) + "][" + this.fCSVRecordDataHolder.getKey()[idx] + "] ?"))) {
            this.fCSVRecordDataHolder.deleteColumn(idx);
            this.adjustSame();
        }
    }

    public void deleteColumns(Set<String> columnNameSet) {
        block0: for (String targetName : columnNameSet) {
            String[] keys = this.fCSVRecordDataHolder.getKey();
            int i = 0;
            while (i < keys.length) {
                if (keys[i].equals(targetName)) {
                    this.fCSVRecordDataHolder.deleteColumn(i);
                    continue block0;
                }
                ++i;
            }
        }
        this.adjustSame();
    }

    public void addColumn() {
        int idx = this.fViewer.getLastSelectedColumn();
        if (idx >= 0) {
            String desc = "Add column at [" + (idx + 1) + "][" + this.fCSVRecordDataHolder.getKey()[idx] + "]";
            InsertDialog dialog = new InsertDialog(this.shell, "addColumn" + this.fCSVRecordDataHolder.getKey().length, desc, true);
            if (dialog.open() == 0) {
                if (dialog.empty) {
                    this.fCSVRecordDataHolder.insertColumn(dialog.before ? idx : idx + 1, dialog.title, StringUtil.EMPTY_STRING_ARRAY);
                }
                this.adjustSame();
            }
        }
    }

    public void setNotNullColumns(String[] columnNames) {
        this.fCSVRecordDataHolder.clearNotNullIdx();
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            System.out.println("notNull:" + columnName);
            this.fCSVRecordDataHolder.addNotNullIdx(columnName);
            ++n2;
        }
        this.fViewer.refresh();
    }

    private static class InsertDialog
    extends Dialog {
        Button btEmpty;
        boolean empty = true;
        Combo cmbScripts;
        String title;
        String description;
        Text scriptText;
        Text headerText;
        boolean addColumn;
        boolean before;

        public InsertDialog(Shell parent, String initialTitle, String description, boolean addColumn) {
            super(parent);
            this.addColumn = addColumn;
            this.description = description;
            this.title = initialTitle;
        }

        protected Control createDialogArea(Composite parent) {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            ScrolledForm root = toolkit.createScrolledForm(parent);
            root.setText(this.addColumn ? "Add Column options" : "Add Row options");
            root.setLayout((Layout)new GridLayout());
            root.setLayoutData((Object)new GridData(1808));
            root.getBody().setLayout((Layout)new GridLayout());
            root.getBody().setLayoutData((Object)new GridData(1808));
            Section section = toolkit.createSection(root.getBody(), 448);
            section.setText("hoge");
            section.setDescription(this.description);
            Composite inner = toolkit.createComposite((Composite)section);
            GridLayout layout = new GridLayout();
            inner.setLayout((Layout)layout);
            layout.numColumns = 2;
            toolkit.createLabel(inner, "Add Position:");
            Composite btnPannel = toolkit.createComposite(inner);
            btnPannel.setLayout((Layout)new FillLayout(256));
            final Button btBefore = toolkit.createButton(btnPannel, "Before", 16);
            Button btAfter = toolkit.createButton(btnPannel, "After", 16);
            btBefore.setSelection(this.before);
            btAfter.setSelection(!this.before);
            btBefore.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InsertDialog.this.before = btBefore.getSelection();
                }
            });
            if (this.addColumn) {
                toolkit.createLabel(inner, "Header Title:");
                this.headerText = toolkit.createText(inner, this.title, 4);
            }
            toolkit.createLabel(inner, "Empty:");
            this.btEmpty = toolkit.createButton(inner, "", 32);
            this.btEmpty.setSelection(this.empty);
            toolkit.createLabel(inner, "Java scirpt:");
            this.cmbScripts = new Combo(inner, 8);
            this.cmbScripts.setEnabled(false);
            this.btEmpty.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InsertDialog.this.empty = InsertDialog.this.btEmpty.getSelection();
                    InsertDialog.this.cmbScripts.setEnabled(!InsertDialog.this.empty);
                    InsertDialog.this.scriptText.setEditable(!InsertDialog.this.empty);
                }
            });
            toolkit.createLabel(inner, "Scirpt texts:");
            this.scriptText = toolkit.createText(inner, "", 2);
            this.scriptText.setEnabled(false);
            this.scriptText.setLayoutData((Object)new GridData(1808));
            section.setClient((Control)inner);
            section.setLayoutData((Object)new GridData(1808));
            return root;
        }

        protected void okPressed() {
            if (this.addColumn) {
                this.title = this.headerText.getText();
            }
            super.okPressed();
        }
    }
}

