/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.frameworks.taskwizard;

import java.util.LinkedHashMap;
import org.eclipse.birt.core.ui.frameworks.taskwizard.SimpleTask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ISubtaskSheet;

public class CompoundTask
extends SimpleTask {
    private transient LinkedHashMap<String, ISubtaskSheet> subtasks = new LinkedHashMap();
    protected transient ISubtaskSheet sCurrentTaskSheet = null;
    private transient String sCurrentSubtask = "";

    public CompoundTask(String title) {
        super(title);
    }

    public void addSubtask(String sSubtaskPath, ISubtaskSheet subtask) {
        this.subtasks.put(sSubtaskPath, subtask);
    }

    public void removeSubtask(String sSubtaskPath) {
        if (this.subtasks.containsKey(sSubtaskPath) && this.sCurrentSubtask.equals(sSubtaskPath)) {
            this.switchTo(this.subtasks.keySet().toArray()[0].toString());
        }
        this.subtasks.remove(sSubtaskPath);
    }

    public void switchTo(String sSubtaskPath) {
        if (this.getCurrentSubtask() != null) {
            this.getCurrentSubtask().onHide();
        }
        if (this.containSubtask(sSubtaskPath)) {
            this.sCurrentTaskSheet = this.getSubtask(sSubtaskPath);
            this.sCurrentSubtask = sSubtaskPath;
        }
        this.getCurrentSubtask().onShow(this.context, this.container);
    }

    protected boolean containSubtask(String sSubtaskPath) {
        return this.subtasks.containsKey(sSubtaskPath);
    }

    protected ISubtaskSheet getSubtask(String sSubtaskPath) {
        if (!this.subtasks.containsKey(sSubtaskPath)) {
            return null;
        }
        return this.subtasks.get(sSubtaskPath);
    }

    protected ISubtaskSheet getCurrentSubtask() {
        return this.sCurrentTaskSheet;
    }

    public void dispose() {
        super.dispose();
        if (this.sCurrentTaskSheet != null) {
            this.sCurrentTaskSheet.onHide();
        }
        this.sCurrentTaskSheet = null;
        for (ISubtaskSheet subtask : this.subtasks.values()) {
            subtask.dispose();
        }
        this.subtasks.clear();
    }
}

