/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.IODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.ODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.impl.AdapterUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.CompareUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.DataSetParameterAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.DesignObjectSerializer;
import org.eclipse.birt.report.model.adapter.oda.impl.ModelOdaAdapter;
import org.eclipse.birt.report.model.adapter.oda.util.ParameterValueUtil;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.SelectionChoiceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DynamicValuesQuery;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputParameterAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputParameterUIHints;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ScalarValueChoices;
import org.eclipse.datatools.connectivity.oda.design.ScalarValueDefinition;
import org.eclipse.datatools.connectivity.oda.design.StaticValues;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

abstract class AbstractReportParameterAdapter {
    protected static final String ALLOW_NULL_PROP_NAME = "allowNull";
    protected static final String ALLOW_BLANK_PROP_NAME = "allowBlank";
    protected final IODADesignFactory designFactory = ODADesignFactory.getFactory();

    AbstractReportParameterAdapter() {
    }

    protected void updateLinkedReportParameterFromROMParameter(AbstractScalarParameterHandle reportParam, OdaDataSetParameterHandle dataSetParam, boolean updateDefaultValue) throws SemanticException {
        assert (reportParam != null);
        if (dataSetParam == null) {
            return;
        }
        Object defaultValue = dataSetParam.getExpressionProperty("defaultValue").getValue();
        String paramName = dataSetParam.getParamName();
        if (StringUtil.isBlank((String)paramName)) {
            dataSetParam.setParamName(reportParam.getName());
        }
        if (updateDefaultValue) {
            this.setROMDefaultValue(reportParam, defaultValue);
        }
    }

    private void setROMDefaultValue(AbstractScalarParameterHandle setParam, Object value) throws SemanticException {
        ArrayList<Expression> newValues = null;
        if (!AdapterUtil.isNullExpression(value)) {
            assert (value instanceof Expression);
            newValues = new ArrayList<Expression>();
            newValues.add(new Expression(((Expression)value).getExpression(), ((Expression)value).getUserDefinedType()));
        }
        setParam.setDefaultValueList(newValues);
    }

    void updateLinkedReportParameter(AbstractScalarParameterHandle reportParam, ParameterDefinition paramDefn, ParameterDefinition cachedParamDefn, OdaDataSetHandle setHandle) throws SemanticException {
        if (paramDefn == null) {
            return;
        }
        CommandStack cmdStack = reportParam.getModuleHandle().getCommandStack();
        try {
            cmdStack.startTrans(null);
            this.updateAbstractScalarParameter(reportParam, paramDefn, cachedParamDefn, setHandle);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    protected void updateAbstractScalarParameter(AbstractScalarParameterHandle reportParam, ParameterDefinition paramDefn, ParameterDefinition cachedParamDefn, OdaDataSetHandle setHandle) throws SemanticException {
        this.updateDataElementAttrsToReportParam(paramDefn.getAttributes(), cachedParamDefn == null ? null : cachedParamDefn.getAttributes(), reportParam);
        this.updateInputParameterAttrsToReportParam(paramDefn.getInputAttributes(), cachedParamDefn == null ? null : cachedParamDefn.getInputAttributes(), reportParam, setHandle);
    }

    protected static ParameterDefinition getValidParameterDefinition(OdaDataSetParameterHandle param, DataSetParameters odaParams) {
        if (param == null || odaParams == null) {
            return null;
        }
        if (odaParams.getParameterDefinitions().isEmpty()) {
            return null;
        }
        ParameterDefinition matchedParam = DataSetParameterAdapter.findParameterDefinition(odaParams, param.getNativeName(), param.getPosition());
        return matchedParam;
    }

    private void updateDataElementAttrsToReportParam(DataElementAttributes dataAttrs, DataElementAttributes cachedDataAttrs, AbstractScalarParameterHandle reportParam) throws SemanticException {
        DataElementUIHints cachedDataUiHints;
        if (dataAttrs == null) {
            return;
        }
        boolean allowsNull = dataAttrs.allowsNull();
        if (cachedDataAttrs == null || cachedDataAttrs.allowsNull() != allowsNull) {
            this.setReportParamIsRequired(reportParam, ALLOW_NULL_PROP_NAME, dataAttrs.allowsNull());
        }
        DataElementUIHints dataUiHints = dataAttrs.getUiHints();
        DataElementUIHints dataElementUIHints = cachedDataUiHints = cachedDataAttrs == null ? null : cachedDataAttrs.getUiHints();
        if (dataUiHints != null) {
            String cachedDescription;
            String displayName = dataUiHints.getDisplayName();
            String cachedDisplayName = cachedDataUiHints == null ? null : cachedDataUiHints.getDisplayName();
            boolean isChanged = false;
            if (cachedDisplayName == null || !cachedDisplayName.equals(displayName)) {
                isChanged = true;
                reportParam.setPromptText(displayName);
                reportParam.setPromptTextID(dataUiHints.getDisplayNameKey());
            }
            if (!isChanged && cachedDataUiHints != null && cachedDisplayName != null) {
                reportParam.setPromptText(cachedDisplayName);
                reportParam.setPromptTextID(cachedDataUiHints.getDisplayNameKey());
            }
            isChanged = false;
            String description = dataUiHints.getDescription();
            String string = cachedDescription = cachedDataUiHints == null ? null : cachedDataUiHints.getDescription();
            if (cachedDescription == null || !cachedDescription.equals(description)) {
                isChanged = true;
                reportParam.setHelpText(description);
                reportParam.setHelpTextKey(dataUiHints.getDescriptionKey());
            }
            if (!isChanged && cachedDataUiHints != null && cachedDescription != null) {
                reportParam.setHelpText(cachedDescription);
                reportParam.setHelpTextKey(cachedDataUiHints.getDescriptionKey());
            }
        }
    }

    private void updateInputParameterAttrsToReportParam(InputParameterAttributes inputParamAttrs, InputParameterAttributes cachedInputParamAttrs, AbstractScalarParameterHandle reportParam, OdaDataSetHandle setHandle) throws SemanticException {
        if (inputParamAttrs == null) {
            return;
        }
        InputParameterUIHints paramUiHints = inputParamAttrs.getUiHints();
        if (paramUiHints != null && reportParam.getContainer() instanceof ParameterGroupHandle) {
            ParameterGroupHandle paramGroup = (ParameterGroupHandle)reportParam.getContainer();
            InputParameterUIHints cachedParamUiHints = cachedInputParamAttrs == null ? null : cachedInputParamAttrs.getUiHints();
            String cachedGroupPromptDisplayName = cachedParamUiHints == null ? null : cachedParamUiHints.getGroupPromptDisplayName();
            String groupPromptDisplayName = paramUiHints.getGroupPromptDisplayName();
            if (cachedGroupPromptDisplayName == null || !cachedGroupPromptDisplayName.equals(groupPromptDisplayName)) {
                paramGroup.setDisplayName(groupPromptDisplayName);
                paramGroup.setDisplayNameKey(paramUiHints.getGroupPromptDisplayNameKey());
            }
        }
        this.updateInputElementAttrsToReportParam(inputParamAttrs.getElementAttributes(), cachedInputParamAttrs == null ? null : cachedInputParamAttrs.getElementAttributes(), reportParam, setHandle);
    }

    protected void updateInputElementAttrsToReportParam(InputElementAttributes elementAttrs, InputElementAttributes cachedElementAttrs, AbstractScalarParameterHandle reportParam, OdaDataSetHandle setHandle) throws SemanticException {
        boolean isEnabled;
        Boolean cachedIsOptional;
        if (elementAttrs == null) {
            return;
        }
        this.updateDefaultValueToReportParam(elementAttrs, cachedElementAttrs, reportParam);
        Boolean isOptional = elementAttrs.isOptional();
        Boolean bl = cachedIsOptional = cachedElementAttrs == null ? null : Boolean.valueOf(cachedElementAttrs.isOptional());
        if (!CompareUtil.isEquals(cachedIsOptional, isOptional)) {
            this.setReportParamIsRequired(reportParam, ALLOW_BLANK_PROP_NAME, isOptional);
        }
        this.updateROMSelectionList(elementAttrs.getStaticValueChoices(), cachedElementAttrs == null ? null : cachedElementAttrs.getStaticValueChoices(), reportParam);
        DynamicValuesQuery valueQuery = elementAttrs.getDynamicValueChoices();
        AdapterUtil.updateROMDyanmicList(valueQuery, cachedElementAttrs == null ? null : cachedElementAttrs.getDynamicValueChoices(), reportParam, setHandle);
        DynamicValuesQuery cachedValueQuery = cachedElementAttrs == null ? null : cachedElementAttrs.getDynamicValueChoices();
        boolean bl2 = isEnabled = valueQuery == null ? false : valueQuery.isEnabled();
        if (reportParam.getContainer() != null && reportParam.getContainer() instanceof CascadingParameterGroupHandle) {
            isEnabled = true;
        }
        if (cachedValueQuery == null || cachedValueQuery.isEnabled() != isEnabled) {
            if (isEnabled) {
                reportParam.setValueType("dynamic");
            } else {
                reportParam.setValueType("static");
            }
        }
    }

    protected void updateDefaultValueToReportParam(InputElementAttributes elementAttrs, InputElementAttributes cachedElementAttrs, AbstractScalarParameterHandle reportParam) throws SemanticException {
        StaticValues cachedDefaultValues;
        StaticValues defaultValues = elementAttrs.getDefaultValues();
        StaticValues staticValues = cachedDefaultValues = cachedElementAttrs == null ? null : cachedElementAttrs.getDefaultValues();
        if (!new EcoreUtil.EqualityHelper().equals((EObject)cachedDefaultValues, (EObject)defaultValues)) {
            AdapterUtil.updateROMDefaultValues(defaultValues, reportParam);
        }
    }

    private void updateROMSelectionList(ScalarValueChoices staticChoices, ScalarValueChoices cachedStaticChoices, AbstractScalarParameterHandle paramHandle) throws SemanticException {
        if (staticChoices == null) {
            return;
        }
        String newChoiceStr = DesignObjectSerializer.toExternalForm((EObject)staticChoices);
        String latestChoiceStr = DesignObjectSerializer.toExternalForm((EObject)cachedStaticChoices);
        if (latestChoiceStr != null && latestChoiceStr.equals(newChoiceStr)) {
            return;
        }
        AdapterUtil.updateROMSelectionList(staticChoices, cachedStaticChoices, paramHandle);
    }

    ParameterDefinition updateParameterDefinitionFromReportParam(ParameterDefinition paramDefn, AbstractScalarParameterHandle paramHandle, DataSetDesign dataSetDesign) {
        assert (paramHandle != null);
        if (paramDefn == null) {
            return null;
        }
        paramDefn.setAttributes(this.updateDataElementAttrs(paramDefn.getAttributes(), paramHandle));
        paramDefn.setInputAttributes(this.updateInputElementAttrs(paramDefn.getInputAttributes(), paramHandle, dataSetDesign));
        return paramDefn;
    }

    private DataElementAttributes updateDataElementAttrs(DataElementAttributes dataAttrs, AbstractScalarParameterHandle paramHandle) {
        DataElementAttributes retDataAttrs = dataAttrs;
        if (retDataAttrs == null) {
            retDataAttrs = this.designFactory.createDataElementAttributes();
        }
        retDataAttrs.setNullability(DataSetParameterAdapter.newElementNullability(this.getReportParamAllowMumble(paramHandle, ALLOW_NULL_PROP_NAME)));
        DataElementUIHints uiHints = this.designFactory.createDataElementUIHints();
        String text = paramHandle.getPromptText();
        String textKey = paramHandle.getPromptTextID();
        if (text != null || textKey != null) {
            uiHints.setDisplayName(text);
            uiHints.setDisplayNameKey(textKey);
        }
        text = paramHandle.getHelpText();
        textKey = paramHandle.getHelpTextKey();
        if (text != null || textKey != null) {
            uiHints.setDescription(text);
            uiHints.setDescriptionKey(textKey);
        }
        retDataAttrs.setUiHints(uiHints);
        return retDataAttrs;
    }

    protected InputParameterAttributes updateInputElementAttrs(InputParameterAttributes inputParamAttrs, AbstractScalarParameterHandle paramHandle, DataSetDesign dataSetDesign) {
        InputElementAttributes inputAttrs;
        InputParameterAttributes retInputParamAttrs = inputParamAttrs;
        if (inputParamAttrs == null) {
            retInputParamAttrs = this.designFactory.createInputParameterAttributes();
        }
        if ((inputAttrs = retInputParamAttrs.getElementAttributes()) == null) {
            inputAttrs = this.designFactory.createInputElementAttributes();
        }
        this.updateDefaultStaticValues(inputAttrs, paramHandle);
        inputAttrs.setOptional(this.getReportParamAllowMumble(paramHandle, ALLOW_BLANK_PROP_NAME));
        ScalarValueChoices staticChoices = null;
        Iterator selectionList = paramHandle.choiceIterator();
        while (selectionList.hasNext()) {
            if (staticChoices == null) {
                staticChoices = this.designFactory.createScalarValueChoices();
            }
            SelectionChoiceHandle choice = (SelectionChoiceHandle)selectionList.next();
            ScalarValueDefinition valueDefn = this.designFactory.createScalarValueDefinition();
            valueDefn.setValue(choice.getValue());
            String label = choice.getLabel();
            String labelKey = choice.getLabelKey();
            if (label != null || labelKey != null) {
                valueDefn.setDisplayName(label);
                valueDefn.setDisplayNameKey(labelKey);
            }
            staticChoices.getScalarValues().add((Object)valueDefn);
        }
        inputAttrs.setStaticValueChoices(staticChoices);
        ExpressionHandle valueExpr = paramHandle.getExpressionProperty("valueExpr");
        ExpressionHandle labelExpr = paramHandle.getExpressionProperty("labelExpr");
        DynamicValuesQuery valueQuery = this.updateDynamicValueQuery(paramHandle.getDataSet(), valueExpr.getValue(), labelExpr.getValue(), dataSetDesign, "dynamic".equalsIgnoreCase(paramHandle.getValueType()));
        inputAttrs.setDynamicValueChoices(valueQuery);
        if (paramHandle.getContainer() instanceof ParameterGroupHandle) {
            ParameterGroupHandle groupHandle = (ParameterGroupHandle)paramHandle.getContainer();
            InputParameterUIHints paramUiHints = this.designFactory.createInputParameterUIHints();
            String text = groupHandle.getDisplayName();
            String textKey = groupHandle.getDisplayNameKey();
            if (text != null || textKey != null) {
                paramUiHints.setGroupPromptDisplayName(text);
                paramUiHints.setGroupPromptDisplayNameKey(textKey);
            }
            retInputParamAttrs.setUiHints(paramUiHints);
        }
        retInputParamAttrs.setElementAttributes(inputAttrs);
        return retInputParamAttrs;
    }

    protected DynamicValuesQuery updateDynamicValueQuery(DataSetHandle setHandle, Object valueColumn, Object labelColumn, DataSetDesign dataSetDesign, boolean isEnabled) {
        DynamicValuesQuery valueQuery = null;
        if (setHandle instanceof OdaDataSetHandle && valueColumn != null) {
            valueQuery = this.designFactory.createDynamicValuesQuery();
            if (dataSetDesign != null) {
                DataSetDesign targetDataSetDesign = (DataSetDesign)EcoreUtil.copy((EObject)dataSetDesign);
                if (!setHandle.getName().equals(dataSetDesign.getName())) {
                    targetDataSetDesign = new ModelOdaAdapter().createDataSetDesign((OdaDataSetHandle)setHandle);
                }
                valueQuery.setDataSetDesign(targetDataSetDesign);
            } else {
                DataSetDesign targetDataSetDesign = new ModelOdaAdapter().createDataSetDesign((OdaDataSetHandle)setHandle);
                valueQuery.setDataSetDesign(targetDataSetDesign);
            }
            valueQuery.setDisplayNameColumn(AdapterUtil.extractColumnName(labelColumn));
            valueQuery.setValueColumn(AdapterUtil.extractColumnName(valueColumn));
            valueQuery.setEnabled(isEnabled);
        }
        return valueQuery;
    }

    protected void updateDefaultStaticValues(InputElementAttributes inputAttrs, AbstractScalarParameterHandle paramHandle) {
        StaticValues newValues = null;
        List tmpValues = paramHandle.getDefaultValueList();
        if (tmpValues != null) {
            int i = 0;
            while (i < tmpValues.size()) {
                if (newValues == null) {
                    newValues = this.designFactory.createStaticValues();
                }
                Expression tmpExpr = (Expression)tmpValues.get(i);
                String odaValue = null;
                odaValue = "constant".equalsIgnoreCase(tmpExpr.getType()) ? tmpExpr.getStringExpression() : ParameterValueUtil.toODAValue(((Expression)tmpValues.get(i)).getStringExpression(), paramHandle.getDataType());
                newValues.add((Object)odaValue);
                ++i;
            }
        }
        inputAttrs.setDefaultValues(newValues);
    }

    protected boolean getReportParamAllowMumble(AbstractScalarParameterHandle param, String propName) {
        if (ALLOW_NULL_PROP_NAME.equalsIgnoreCase(propName) || ALLOW_BLANK_PROP_NAME.equalsIgnoreCase(propName)) {
            return !param.isRequired();
        }
        assert (false);
        return false;
    }

    protected void setReportParamIsRequired(AbstractScalarParameterHandle param, String obsoletePropName, boolean value) throws SemanticException {
        if (ALLOW_NULL_PROP_NAME.equalsIgnoreCase(obsoletePropName) || ALLOW_BLANK_PROP_NAME.equalsIgnoreCase(obsoletePropName)) {
            param.setIsRequired(!value);
        } else assert (false);
    }
}

