/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.script.internal.scale;

import java.util.Date;
import org.eclipse.birt.chart.model.attribute.ScaleUnitType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataElementImpl;
import org.eclipse.birt.chart.script.api.scale.ITimeScale;
import org.eclipse.birt.chart.script.internal.scale.ScaleImpl;

public class TimeScaleImpl
extends ScaleImpl
implements ITimeScale {
    protected TimeScaleImpl(Axis axis) {
        super(axis);
    }

    public Date getMax() {
        DataElement data = this.scale.getMax();
        if (data instanceof DateTimeDataElement) {
            return ((DateTimeDataElement)data).getValueAsCalendar().getTime();
        }
        return null;
    }

    public Date getMin() {
        DataElement data = this.scale.getMin();
        if (data instanceof DateTimeDataElement) {
            return ((DateTimeDataElement)data).getValueAsCalendar().getTime();
        }
        return null;
    }

    public int getStepSize() {
        return (int)this.scale.getStep();
    }

    public String getStepTimeUnit() {
        return this.scale.getUnit().getName();
    }

    public void setMax(Date max) {
        this.scale.setMax(max != null ? DateTimeDataElementImpl.create((long)max.getTime()) : null);
    }

    public void setMin(Date min) {
        this.scale.setMin(min != null ? DateTimeDataElementImpl.create((long)min.getTime()) : null);
    }

    public void setStepSize(int size) {
        this.scale.setStep((double)size);
    }

    public void setStepTimeUnit(String unit) {
        this.scale.setUnit(ScaleUnitType.getByName((String)unit));
    }
}

